import db from './db.js';
import Record from "./record";

export default class Random {
    find() {
        return db.transaction('r', db.random_quiz, () => {
            return db.random_quiz.orderBy('id')
                .last();
        });
    }

    update(quiz_id, categoryNo, subCategoryNo, quizNo, sentence, comment, keyword, related_image_name, choice_row_count, answer_no, time_limit, rank, content_id) {
        var randomQuizStore = {
            'quiz_id': quiz_id,
            'category_no': categoryNo,
            'subcategory_no': subCategoryNo,
            'quiz_no': quizNo,
            'sentence': sentence,
            'comment': comment,
            'keyword': keyword,
            'related_image_name': related_image_name,
            'choice_row_count': choice_row_count,
            'answer_no': answer_no,
            'time_limit': time_limit,
            'rank': rank,
            'content_id': content_id
        };

            return db.random_quiz.put(randomQuizStore) ? true : false;
    }

    async findUpdateRandomQuizStatus(quiz) {
        quiz.status = 1;

        return await db.random_quiz.update(quiz.id, quiz);
    }

     deleteRandomQuizStatusCorrect () {
        return db.transaction('rw', db.random_quiz, async () =>{
            var randomQuiz = await db.random_quiz.toArray()
                .then((random) =>
                    random.filter(function (quiz) {
                        return quiz.status > 0;
                    })
                );

            if (randomQuiz.length > 0) {
                db.random_quiz.clear();
                randomQuiz.forEach(function (item) {
                    item.status = 0;
                });
                return randomQuiz;
            } else
                return false;
        });
    }
}