import db from './db.js';
import config from "./config";

export default class Continue {
    find() {
        return db.transaction('r', db.continue_quiz, () => {
            return db.continue_quiz.orderBy('id')
                .last();
        });
    }

    /*
    * funct add new or update if isset continue quiz
    *
    * @categoryNo 
    * @subCategoryNo 
    * @quizNo 
    * @author ChienNguyen
    * @updated 2019.01.13
    */

    update(categoryNo, subCategoryNo, quizNo) {

        let id_continue_quiz = categoryNo;
        var continueQuizStore = {
            'id'            : id_continue_quiz,
            'category_no'   : categoryNo,
            'subcategory_no': subCategoryNo,
            'quiz_no'       : quizNo
        };

        return db.continue_quiz.put(continueQuizStore) ? true : false;
    }

    /*
    * find Continue Quiz 
    * 
    * @param categoryNo
    * @param subCategoryNo
    * @return if
    * @author ChienNguyen
    * @updated 2019.01.13
    */

    findContinueQuiz(categoryNo){
        return db.transaction('r', db.continue_quiz, async () => {
            let rsContinueQuiz = await db.continue_quiz
                    .where('category_no').equals(categoryNo)
                    .first();
            if (typeof rsContinueQuiz == 'undefined'){
                rsContinueQuiz = false;
            }

            return rsContinueQuiz;
        });
    }


    /*
    * get all Continue quiz
    *
    * @author ChienNguyen
    * @updated 2019.01.13
    */
   
    getAllContinueQuiz(){
        return db.transaction('r', db.continue_quiz, async () => {
            return await db.continue_quiz
                        .toArray();
        });
    }
}