import db       from "./db";
const $             = require('jquery');
import config from "./config";
import Login        from './login.js';
/**
 * shared funct
 *
 * @updated 23.12.2018
 * @author ChienNguyen
 */


/**
 * funct random array
 *
 * return random
 */

export function randomArray(arrays) {
    return arrays[Math.floor(Math.random()*arrays.length)];
}


/**
 * funct random Object
 *
 * return random
 */

export function randomObject(objects) {
    return objects[Object.keys(objects)[Math.floor(Math.random()*Object.keys(objects).length)]];
}

/**
	 * create list quiz random for cate
	 *
	 * @param 
	 * @return list array quiz 
	 * @updated 21.12.2018
	 */

export function createListQuizIncorrectRandom (listQuizIncorrectSortedByCate = array()) {
        var listCateQuizRandom = [];
        if(listQuizIncorrectSortedByCate.length)
        {
        	var page = 1;
        	listQuizIncorrectSortedByCate.forEach(function(data,key){
		        for (var i = data.list_quiz.length-1; i >=0; i--) {
			            var randomIndex = Math.floor(Math.random()*(i+1));
			            var itemAtIndex = data.list_quiz[randomIndex];
			            data.list_quiz[randomIndex] = data.list_quiz[i];
			            data.list_quiz[i] = itemAtIndex;
			    }
			    
			    var count_quiz = data.list_quiz.length;
			    for (var i = 0; i < count_quiz; i++) {
			    	var quiz = data.list_quiz[i];
			        var tmpData = {
			        	'id'			 : page,
			        	'category_no'	 : quiz.category_no,
			        	'subcategory_no' : quiz.subcategory_no,
			        	'quiz_no' 		 : quiz.quiz_no,
			        };
			        listCateQuizRandom.push(tmpData);
			        page++;
			    }
		    });  
        }
       return listCateQuizRandom;
}

/**
* check json string
*
* @updated 2019.01.22
*/

export function IsJsonString(str) {
    try {
        JSON.parse(str);
    } catch (e) {
        return false;
    }
    return true;
}


/**
* 
*
* @updated 2019.01.22
*/

export function returnListBigCategory(arrayCategory) {
	var listBigCate = [];
	var tmpCheckBigCate = [];
	try {
    	for(var i = 0; i < arrayCategory.length; i++) {
    		if (tmpCheckBigCate.indexOf(arrayCategory[i].category_notation) === -1) {
        		listBigCate.push(arrayCategory[i]);
        		tmpCheckBigCate.push(arrayCategory[i].category_notation);
        	}
        }
    } catch (e) {
    	console.log(e);
    }
    return listBigCate;
}

/**
* function handle set face mark
*
* @updated 07.01.2019
*/
export function functHandleSetFaceMark () {
	$('.handle_face_mark').click(function(e){
		e.preventDefault();
		// show popup
		var that = this;
		var id = $(that).attr('id');
		var id_choice = $(that).attr('data-id');
		var id_quiz = $(that).attr('data-quiz-id');
	    $(that).find('.popuptext').show();
	    var idPopup = "myPopup" + id;

	    $(".handle_face_mark .popuptext").each(function() {
		    if($(this).prop('id') != idPopup.toString())
		    {	
		    	$(this).removeClass('show');
		    }
		});
	    
	    var popup = document.getElementById(idPopup);
	    popup.classList.toggle("show");

	    // handle 
	    $("#" + id + ' .face-mark').click(function(e){
	  		e.preventDefault();
		  	var src = $(this).attr('data-src');

		  	var check_remove = false;
		  	if($("#" + id).find('.btn_icon p img').length)
		  	{
		  		let current_src = $("#" + id).find('.btn_icon p img').attr('src');
		  		if(current_src.indexOf(src) != -1)
		  		{
		  			check_remove = true;
		  		}
		  	}

		  	if(check_remove == true)
		  	{
		  		$("#" + id).find('.btn_icon p img').remove();
		  		if($(that).hasClass("is_set_face_mark"))
				{
				  	$(that).removeClass("is_set_face_mark");
				}
		  	}
		  	else
		  	{
		  		if(!$(that).hasClass("is_set_face_mark"))
				{
				    $(that).addClass("is_set_face_mark");
				}
				$("#" + id).find('.btn_icon p').html('<img src="'+ config.subfolder +'/'+ src +'" width="26" alt="">');
		  	}

		    // update record

		    db.transaction('rw', db.record, db.quizzes, () => {
		    let recordInfo = db.record
                .where('id').equals(id_quiz) 
                .first();
            recordInfo.then(function(record) 
                {	
                	var loginObj = new Login();
                	if(record)
                	{
                		let face_marks = {};
                		if(record.face_marks && IsJsonString(record.face_marks))
                		{
                			face_marks = JSON.parse(record.face_marks);
                		}
                		face_marks[id_choice] = src;

                		if(check_remove == true)
	            		{
	            			delete face_marks[id_choice];
	            		}

                		record.is_modify = 1;
                		record.face_marks = JSON.stringify(face_marks);
                		
	                	db.record.put(record).catch('Data Limit', err => {
	                        console.log("--- Update Faild ---")
	                    });
                	}
                	else
                	{
                		let quizInfo = db.quizzes
			                .where('id').equals(id_quiz) 
			                .first();
			            quizInfo.then(function(quiz) 
                		{
                			if(quiz)
                			{
                				// 
                				let array_key = [quiz.category_no, quiz.subcategory_no, quiz.quiz_no];
	            				let primary_key = array_key.toString();
	            				let face_marks = {};
	            				if(check_remove != true)
	            				{
	            					face_marks[id_choice] = src;
	            				}
	            				
	                			let recordStore = {
					                'id' : primary_key,
					                'category_no': quiz.category_no, 
					                'subcategory_no': quiz.subcategory_no, 
					                'quiz_no': quiz.quiz_no,
					                'try_count': 0,
					                'incorrect_count': 0,
					                'last_answered': 0,
					                'last_incorrect_count': 0,
					                'selectbox': false,
					                'content_id': quiz.content_id,
					                'client_id': '', 
					                'face_marks': JSON.stringify(face_marks),
					                'learner_id': loginObj.isLogged(),
					                'is_modify': 1
					            };
					            db.record.put(recordStore);
                			}
                		});
                	}
                });
	        });
		});
	});
}
