import db from './db.js';
import config from "./config";
import Dexie from "dexie";

/*
* 
*
* @author ChienNguyen
* @updated 2019.01.15
 */

export default class LearningLog {

	/**
	 * check object and add new
	 *
	 * 
     * @return boelean
     * @updated 2019.01.15
     */
    async add(learningLog) {
    	return db.transaction('rw', db.learning_logs, async () => {
	        if (learningLog) {
	           	// handle data before add
	           	var tmp_start_date = new Date(learningLog.time_start);
	           	var tmp_end_date = new Date(learningLog.time_end);
	           	// sercon
	           	var duration = (tmp_end_date.getTime() - tmp_start_date.getTime())  / 1000;

	           	learningLog.data = '';
	           	learningLog.submitted = 0;
	           	learningLog.duration = duration;

	            learningLog.id = await db.learning_logs.put(learningLog);
	            if(learningLog.id){
	            	return true;
	            }else
	            {
	            	return false;
	            } 
	        }
	        else
	        {
	        	return false;
	        }
	    });
    }

    /**
	 * get all learning log not yet updated into server
	 *
	 * submitted = 0
	 * 
	 * @author ChienNguyen
     * @return array
     * @updated 2019.01.15
     */
    getAllLearningLogsNotYetUpdated() {
    	return db.transaction('r', db.learning_logs, async () => {
	        return await db.learning_logs
            		.where('submitted').equals(0)
                    .toArray();
	    });
    }


     /* update all learning log is updated into server
	 *
	 * if submitted = 0 -> submitted = 1
	 * 
	 * @author ChienNguyen
     * @return boelean
     * @updated 2019.01.15
     */
    updateLearningLogIsUpdated() { 
    	return db.transaction('rw', db.learning_logs, async () => {
    		await db.learning_logs.where("submitted").equals(0).modify({submitted: 1});
            return true;
	    });
    }
}
