<?php
/**
 * User Management
 * @author binhtt
 * @created 2011/14/09
 */
define ( "CREATED_DATETIME", "発行日" );
define ( "USER_NAME", "アカウント" );
define ( "USER_ROLE", "ロール" );
define ( "USER_DESC", "説明" );
define ( "USER_STATE", "状態" );
class SppUsersController extends AppController {
	var $name = "SppUser";
	var $uses = array (
			"SppUser",
			"SppUserRole",
			'SppRole',
			"SppOrganization",
			"SppUserOrganization",
			"SppQuestion",
			"SppCorrection",
			"SppUserOrganization"			 
	);
	var $helpers = array (
			'Html',
			'Form',
			'Session',
			'Dialog',
			'pass4v' 
	);
	var $components = array (
			'Auth',
			'Session',
			'Csv' 
	);
	// role of user.
	var $role_user = "";
	var $Pass4v;
	function beforeFilter() {
		parent::beforeFilter ();
		$this->Auth->allow ( 'add', 'logout', 'index', 'edit', 'login', 'getUserRole', 'menu', 'dialogconfirm', 'delete', 'changePassword', 'csvExport' );
		// Load config file
		Configure::load ( 'settings' );
		
		if ($this->action == 'add' || $this->action == 'edit') {
			$this->Auth->authenticate = $this->SppUser;
		}
	}
	function beforeRender() {
		parent::beforeRender ();
		// $this->set('user', $this->Auth->user());
		// In the views $user['User']['username'] would display the logged in users username
	}
	
	/**
	 * Create list view all user
	 * 
	 * @author binhtt
	 * @param        	
	 *
	 * @return @created 2011/14/09
	 */
	function index() {
		// check session and role
		if(!$this->isSystemManagement()){
			$this->render('/elements/error');
			return;
		}
		
		$currentUser = $this->Auth->user ();
		if (! empty ( $currentUser )) {
			$session = $this->Session->read ();
			$id = $session ['Auth'] ['SppUser'] ['id'];
			$role_user = $this->getUserRoleName ( $id );
			// get keyword in session
			$keyword = $this->Session->read ( 'Search.keyword' );
			if (isset ( $_POST ['data'] ['SppUser'] ['filter'] )) {
				$filter = $_POST ['data'] ['SppUser'] ['filter'];
				$this->Session->delete ( 'Search.keyword' );
				$this->Session->write ( 'Search.keyword', $filter );
				$keyword = $this->Session->read ( 'Search.keyword' );
			}
			$keyword = empty ( $keyword ) ? '' : $keyword;

			if (! empty ( $keyword )) {
				$this->paginate = array (
							'limit' => Configure::read ( 'USER.NUMBER_OF_PAGE' ),
							'order' => 'user_name',
							'conditions' => array (
									'OR' => array (
											'SppUser.user_name LIKE' => "%" . mysql_real_escape_string ( $keyword ) . "%",
											'SppUser.user_desc LIKE' => "%" . mysql_real_escape_string ( $keyword ) . "%" 
											)
											)
											);
			} else {
				$this->paginate = array (
							'order' => 'user_name',
							'limit' => Configure::read ( 'USER.NUMBER_OF_PAGE' ) 
				);
			}
			$this->set ( 'keyword', $keyword );
			$users = $this->paginate ( 'SppUser' );
			$this->set ( "users", $users );
			// role user
			$this->set ( 'role_user', $role_user );
			// add url current to session store
			$this->Session->delete ( 'current.url' );
			$urlCurrent = $this->params ['url'] ['url'];
			$this->Session->write ( 'current.url', $urlCurrent );
				
		} else {
			$this->redirect ( array (
					'action' => 'login' 
			) );
		}
	}
	
	/**
	 * Add new user
	 * 
	 * @author binhtt
	 * @param        	
	 *
	 * @return @created 2011/14/09
	 *         @updated 2012/24/09
	 */
	function add() {
		// check session and role
		if(!$this->isSystemManagement()){
			$this->render('/elements/error');
			return;
		}
		
		$currentUrl = $this->Session->read ( 'current.url' );
		$this->set ( 'current_url', '/' . $currentUrl );
		// Check empty data
		$organizations = $this->SppOrganization->find ('all');
		$this->set ( 'organizations', $organizations );
		$checked_orgs = array();
		if(isset($_POST['selection']))
		{
			$checked_orgs = $_POST['selection'];
		}
		$this->set ('checked_orgs', $checked_orgs);
		
		if (!empty ( $this->data )) {
			// Validate data by validate function in model

			$this->SppUser->create ();

			$this->data ['SppUser'] ['created_datetime'] = date ( "Y-m-d H:i:s" );
			$this->data ['SppUser'] ['updated_datetime'] = date ( "Y-m-d H:i:s" );
			$this->set ( 'data', $this->data );

			$this->SppUser->set ( $this->data );
			if ($this->SppUser->validates ()) {
				if ($this->data ['SppUser'] ['achievement_management'] == 0 && $this->data ['SppUser'] ['support'] == 0 && $this->data ['SppUser'] ['system_management'] == 0) {
					$this->set ( 'cleared', 1 );
					$this->Session->setFlash ( Configure::read ( 'Message.ERR_UNCHECK_ROLE' ) );
				} else {
					$this->SppUser->data ['SppUser'] ['user_pwd'] = Security::hash ( $this->data ['SppUser'] ['user_pwd'] );
					$this->SppUser->data ['SppUser'] ['user_pwd_confirm'] = Security::hash ( $this->data ['SppUser'] ['user_pwd_confirm'] );

					// Begin transaction


					$this->SppUser->begin ();
					try {
						if ($this->SppUser->save ()) {
							// Check and assign user role
							// if have role user management
							$user_id = $this->SppUser->getLastInsertId ();
							if(isset($_POST['selection']))
							{
								$org_ids = $_POST['selection'];
								foreach ( $org_ids as $org_id ) {
									$this->SppUserOrganization->create();
									$this->SppUserOrganization->set ( array (
												'user_id' => $user_id,
												'organization_id' => $org_id
									) );
									$this->SppUserOrganization->save();
								}
							}

							$userId = $this->SppUser->getInsertId ();
							// check role is user
							if ($this->data ['SppUser'] ['achievement_management'] == 1) {
								$roleID = $this->SppRole->find ( 'first', array (
											'conditions' => array (
													'SppRole.role_code' => 'ACHIEVEMENT_MANAGEMENT' 
													)
													) );
													$this->_addRole ( $userId, $roleID ['SppRole'] ['id'] );
													/*
													 * if(!$this->_addRole($userId, $roleID['SppRole']['id'])) {
													 * $this->SppUser->rollback();
													 * }
													 */
							}
							// USER_MANAGEMENT_VIEW add
							if ($this->data ['SppUser'] ['support'] == 1) {
								$roleID = $this->SppRole->find ( 'first', array (
											'conditions' => array (
													'SppRole.role_code' => 'SUPPORT' 
													)
													) );
													$this->_addRole ( $userId, $roleID ['SppRole'] ['id'] );
							}
							// if have role content management
							// check role is content
							if ($this->data ['SppUser'] ['system_management'] == 1) {
								// create new role record
								$roleID = $this->SppRole->find ( 'first', array (
											'conditions' => array (
													'SppRole.role_code' => 'SYSTEM_MANAGEMENT' 
													)
													) );
													$this->_addRole ( $userId, $roleID ['SppRole'] ['id'] );
													/*
													 * if(!$this->_addRole($userId, $roleID['SppRole']['id'])) {
													 * $this->SppUser->rollback();
													 * }
													 */
							}

							// Commit transaction
							$this->SppUser->commit ();

							$this->Session->setFlash ( Configure::read ( 'Message.ADD_SUCCESS' ) );
							$currentUrl = $this->Session->read ( 'current.url' );

							$this->redirect ( '/' . '/' . $currentUrl );
						}
					} catch ( Exception $e ) {
						// Rollback transaction
						$this->SppUser->rollback ();
						$this->set ( 'cleared', 1 );
						$this->set ( 'errors', array (
						Configure::read ( 'Message.ERR_EXCEPTION' )
						) );
					}
				}
			} else {
				$error = $this->SppUser->invalidFields ();
				// debug($error);
				$errorMsg = array ();
				// echo $this->SppUser->invalidate('user_name', 'notEmpty');die;
				if (isset ( $error ['user_name'] ) && $error ['user_name'] == 'notEmpty') {
					array_push ( $errorMsg, Configure::read ( 'Message.ERR_USERNAME_EMPTY' ) );
				}
				if (isset ( $error ['user_name'] ) && $error ['user_name'] == 'length') {
					array_push ( $errorMsg, Configure::read ( 'Message.ERR_USERNAME_LENGTH' ) );
				}
				if (isset ( $error ['user_name'] ) && $error ['user_name'] == 'unique') {
					array_push ( $errorMsg, Configure::read ( 'Message.ERR_USERNAME_UNIQUE' ) );
				}
				if (isset ( $error ['user_name'] ) && $error ['user_name'] == 'allow') {
					array_push ( $errorMsg, Configure::read ( 'Message.ERR_USERNAME_RULE' ) );
				}
				if (isset ( $error ['user_pwd'] ) && $error ['user_pwd'] == 'required') {
					array_push ( $errorMsg, Configure::read ( 'Message.ERR_PWD_EMPTY' ) );
				}
				if (isset ( $error ['user_pwd'] ) && $error ['user_pwd'] == 'confirm') {
					array_push ( $errorMsg, Configure::read ( 'Message.ERR_PWD_CONFIRM' ) );
				}
				if (isset ( $error ['user_pwd'] ) && $error ['user_pwd'] == 'length') {
					array_push ( $errorMsg, Configure::read ( 'Message.ERR_PWD_LENGTH' ) );
				}
				if (isset ( $error ['user_pwd'] ) && $error ['user_pwd'] == 'maxlength') {
					array_push ( $errorMsg, Configure::read ( 'Message.ERR_PWD_MAXLENGTH' ) );
				}
				if (isset ( $error ['user_pwd'] ) && $error ['user_pwd'] == 'allow') {
					array_push ( $errorMsg, Configure::read ( 'Message.ERR_PWD_RULE' ) );
				}
				if (isset ( $error ['user_desc'] ) && $error ['user_desc'] == 'notEmpty') {
					array_push ( $errorMsg, Configure::read ( 'Message.ERR_DESC_EMPTY' ) );
				}
				if (isset ( $error ['user_desc'] ) && $error ['user_desc'] == 'length') {
					array_push ( $errorMsg, Configure::read ( 'Message.ERR_DESC_LENGTH' ) );
				}
				$this->set ( 'cleared', 1 );
				// debug($errorMsg);
				$this->set ( 'errors', $errorMsg );
			}
		}
	}
	
	/**
	 * Edit user
	 * 
	 * @author binhtt
	 * @param
	 *        	user_id
	 * @return @created 2011/14/09
	 */
	function edit($id = null) {
		// Check permision
		// check session and role
		if(!$this->isSystemManagement()){
			$this->render('/elements/error');
			return;
		}
		
		$currentUser = $this->Auth->user ();
		$this->SppUser->id = $id;

		$currentUrl = $this->Session->read ( 'current.url' );
		$this->set ( 'current_url', '/' . $currentUrl );
		$this->set ( 'data', $this->data );
		$checked_orgs = array();
		
		if (! empty ( $this->data )) {

			if(isset($_POST['selection']))
			{
				$checked_orgs = $_POST['selection'];
			}
			$editUserId = $this->Session->read ( 'editUser.id' );
			
			$this->SppUser->begin ();
			$this->SppUserOrganization->deleteAll(array('SppUserOrganization.user_id' => $editUserId),false);
			if(isset($_POST['selection']))
			{
				$org_ids = $_POST['selection'];
				foreach ( $org_ids as $org_id ) {
					$this->SppUserOrganization->create();
					$this->SppUserOrganization->set ( array (
								'user_id' => $this->data['SppUser']['id'],
								'organization_id' => $org_id
					) );
					$this->SppUserOrganization->save();
				}
			}
			$this->set ( 'editUser', $this->data);
			$roles = $this->_createRole ( $this->data ['SppUser'] ['achievement_management'], $this->data ['SppUser'] ['support'], $this->data ['SppUser'] ['system_management']);
			$this->set ( 'roles', $roles );

			if ($this->data ['SppUser'] ['achievement_management'] == 0 && $this->data ['SppUser'] ['support'] == 0 && $this->data ['SppUser'] ['system_management'] == 0) {
				$this->Session->setFlash ( Configure::read ( 'Message.ERR_UNCHECK_ROLE' ) );
			} else {
				if (! empty ( $this->data ['SppUser'] ['user_pwd'] ) && strcmp ( $this->data ['SppUser'] ['user_pwd'], $this->data ['SppUser'] ['user_pwd_confirm'] ) != 0) {
					$this->Session->setFlash ( 'パスワードが一致しません' );
				} else {
					$user = $this->SppUser->findById ( $editUserId );
					if (! empty ( $user )) {
						$fields = array ();
							
						$changePwd = false;
						if (empty ( $this->data ['SppUser'] ['user_pwd'] ) && empty ( $this->data ['SppUser'] ['user_pwd_confirm'] )) {
							$fields = array (
										'user_desc' 
										);
										$this->data ['SppUser'] ['user_pwd'] = $user ['SppUser'] ['user_pwd'];
										$this->data ['SppUser'] ['user_pwd_confirm'] = $user ['SppUser'] ['user_pwd'];
						} else {
							$fields = array (
										'user_pwd',
										'user_desc' 
										);
										$changePwd = true;
						}
						$this->SppUser->id = $user ['SppUser'] ['id'];
						$this->SppUser->set ( $this->data );
						
						if ($this->SppUser->validates ( array (
									'fieldList' => $fields 
						) )) {
							if ($changePwd) {
								$this->data ['SppUser'] ['user_pwd'] = Security::hash ( $this->data ['SppUser'] ['user_pwd'] );
							}

							try {
								if ($this->SppUser->save ( $this->data, false )) {
									// delete all role
									$this->_deleteRoleByUser ( $editUserId );
									if ($this->data ['SppUser'] ['achievement_management'] == 1) {
										$roleID = $this->SppRole->find ( 'first', array (
													'conditions' => array (
															'SppRole.role_code' => 'ACHIEVEMENT_MANAGEMENT' 
															)
															) );
															$this->_addRole ( $editUserId, $roleID ['SppRole'] ['id'] );
															/*
															 * if(!$this->_addRole($editUserId, $roleID['SppRole']['id'])) {
															 * $this->SppUser->rollback();
															 * }
															 */
									}
									// USER_MANAGEMENT_VIEW add
									if ($this->data ['SppUser'] ['support'] == 1) {
										$roleID = $this->SppRole->find ( 'first', array (
													'conditions' => array (
															'SppRole.role_code' => 'SUPPORT' 
															)
															) );
															$this->_addRole ( $editUserId, $roleID ['SppRole'] ['id'] );
									}
									// if have role content management
									// check role is content

									if ($this->data ['SppUser'] ['system_management'] == 1) {
										// create new role record
										$roleID = $this->SppRole->find ( 'first', array (
													'conditions' => array (
															'SppRole.role_code' => 'SYSTEM_MANAGEMENT' 
															)
															) );
															$this->_addRole ( $editUserId, $roleID ['SppRole'] ['id'] );
															/*
															 * if(!$this->_addRole($editUserId, $roleID['SppRole']['id'])) {
															 * $this->SppUser->rollback();
															 * }
															 */
									}

									$this->SppUser->commit ();

									// Edit successfull
									$this->Session->delete ( 'editUser.id' );

									$this->Session->setFlash ( Configure::read ( 'Message.EDIT_SUCCESS' ) );

									$currentUrl = $this->Session->read ( 'current.url' );

									$this->redirect ( '/' . '/' . $currentUrl );
								}
							} catch ( Exception $e ) {
								$this->SppUser->rollback ();
								$this->set ( 'errors', array (
								Configure::read ( 'Message.ERR_EXCEPTION' )
								) );
							}
						} else {
							if(!$changePwd) {
								$this->data ['SppUser'] ['user_pwd'] = '';
								$this->data ['SppUser'] ['user_pwd_confirm'] = '';
							}
							$error = $this->SppUser->invalidFields ();

							$errorMsg = array ();
							// echo $this->SppUser->invalidate('user_name', 'notEmpty');die;
							if (isset ( $error ['user_name'] ) && $error ['user_name'] == 'notEmpty') {
								array_push ( $errorMsg, Configure::read ( 'Message.ERR_USERNAME_EMPTY' ) );
							}
							if (isset ( $error ['user_name'] ) && $error ['user_name'] == 'length') {
								array_push ( $errorMsg, Configure::read ( 'Message.ERR_USERNAME_LENGTH' ) );
							}
							if (isset ( $error ['user_name'] ) && $error ['user_name'] == 'unique') {
								array_push ( $errorMsg, Configure::read ( 'Message.ERR_USERNAME_UNIQUE' ) );
							}
							if (isset ( $error ['user_name'] ) && $error ['user_name'] == 'allow') {
								array_push ( $errorMsg, Configure::read ( 'Message.ERR_USERNAME_RULE' ) );
							}
							if (isset ( $error ['user_pwd'] ) && $error ['user_pwd'] == 'required') {
								array_push ( $errorMsg, Configure::read ( 'Message.ERR_PWD_EMPTY' ) );
							}
							if (isset ( $error ['user_pwd'] ) && $error ['user_pwd'] == 'confirm') {
								array_push ( $errorMsg, Configure::read ( 'Message.ERR_PWD_CONFIRM' ) );
							}
							if (isset ( $error ['user_pwd'] ) && $error ['user_pwd'] == 'length') {
								array_push ( $errorMsg, Configure::read ( 'Message.ERR_PWD_LENGTH' ) );
							}
							if (isset ( $error ['user_pwd'] ) && $error ['user_pwd'] == 'maxlength') {
								array_push ( $errorMsg, Configure::read ( 'Message.ERR_PWD_MAXLENGTH' ) );
							}
							if (isset ( $error ['user_pwd'] ) && $error ['user_pwd'] == 'allow') {
								array_push ( $errorMsg, Configure::read ( 'Message.ERR_PWD_RULE' ) );
							}
							if (isset ( $error ['user_desc'] ) && $error ['user_desc'] == 'notEmpty') {
								array_push ( $errorMsg, Configure::read ( 'Message.ERR_DESC_EMPTY' ) );
							}
							if (isset ( $error ['user_desc'] ) && $error ['user_desc'] == 'length') {
								array_push ( $errorMsg, Configure::read ( 'Message.ERR_DESC_LENGTH' ) );
							}

							$this->set ( 'errors', $errorMsg );
						}
					}
				}
			}
		} else {
			$editUser = $this->SppUser->read ();
			$roles = $this->getUserRole ( $editUser ['SppUser'] ['id'] );
			$checked_orgs = $this->SppUserOrganization->getOrgIdByUser($editUser ['SppUser'] ['id']);
			$this->set ( 'roles', $roles );
			unset ( $editUser ['SppUser'] ['user_pwd'] );
			$this->set ( 'editUser', $editUser );
			$this->Session->write ( 'editUser.id', $id );
			$content_url = $this->Session->read ( 'content.url' );
			$this->set ( 'content_url', '/' . $content_url );
		}
		$organizations = $this->SppOrganization->find ('all');
		$this->set ('organizations', $organizations);
		$this->set ('checked_orgs', $checked_orgs);

	}
	
	/**
	 * Delete a user
	 * 
	 * @author binhtt
	 * @param        	
	 *
	 * @return @created 2011/14/09
	 */
	function delete($id = null) {
		// check session and role
		if(!$this->isSystemManagement()){
			$this->render('/elements/error');
			return;
		}

		if (! empty ( $id )) {

			$this->SppUser->begin ();

			try {
				// Delete all user role
				$this->_deleteRoleByUser ( $id );
				// Delete user infomation
				$this->SppUser->delete ( $id );
					
				$this->SppUser->commit ();
					
				$this->Session->setFlash ( Configure::read ( 'Message.DELETE_SUCCESS' ) );
				$currentUrl = $this->Session->read ( 'current.url' );
				$this->redirect ( '/' . '/' . $currentUrl );
			} catch ( Exception $e ) {
				$this->SppUser->rollback ();
				$this->set ( 'errors', array (
				Configure::read ( 'Message.ERR_EXCEPTION' )
				) );
				$currentUrl = $this->Session->read ( 'current.url' );
				$this->redirect ( '/' . '/' . $currentUrl );
			}
			// $this->redirect(array('action' => 'index'));
		}

	}
	
	/**
	 * Login function
	 * 
	 * @author binhtt
	 * @param        	
	 *
	 * @return @created 2011/15/09
	 */
	function login() {
		if (! empty ( $this->data )) { // Submitted form
			$this->set ( 'userTemp', $this->data ['SppUser'] ['username'] );
			$this->set ( 'passTemp', $this->data ['SppUser'] ['password'] );
			
			if (empty ( $this->data ['SppUser'] ['username'] )) {
				$this->Session->setFlash ( Configure::read ( 'Message.ERR_USERNAME_EMPTY' ), $this->Auth->flashElement, array (), 'auth' );
			} else if (empty ( $this->data ['SppUser'] ['password'] )) {
				$this->Session->setFlash ( Configure::read ( 'Message.ERR_PWD_EMPTY' ), $this->Auth->flashElement, array (), 'auth' );
			} else {
				if (! $this->Auth->user ()) {
					$this->Auth->data ['SppUser'] ['password'] = $this->Auth->password ( $this->Auth->data ['SppUser'] ['password'] );
					$user = $this->SppUser->find ( 'first', array (
							'conditions' => array (
									'SppUser.user_name' => $this->Auth->data ['SppUser'] ['username'],
									'SppUser.user_pwd' => $this->Auth->data ['SppUser'] ['password'] 
							),
							'recursive' => - 1 
					) );
					// debug($user);die;
					if (! empty ( $user ) && $this->_isLockedUser ( $user ['SppUser'] ['locked_datetime'], date ( "Y-m-d H:i:s" ) ) == true) {
						// is locked user
						$this->Session->setFlash ( Configure::read ( 'Message.ERR_LOCKED_USER' ) );
						$this->Session->delete ( 'Message.auth' );
						// $this->redirect($this->referer());
					} else if (! empty ( $user ) && $this->Auth->login ( $user )) {
						$user ['SppUser'] ['pwd_ng_time'] = 0;
						$user ['SppUser'] ['locked_datetime'] = NULL;
						$user ['SppUser'] ['limited_datetime'] = NULL;
						$this->SppUser->save ( $user, false );
						// They logged in, so kill the flash error message
						$this->Session->delete ( 'Message.auth' );
						$this->redirect ( array (
								'action' => 'menu' 
						) );
					} else {
						// check password not good
						$usr = $this->SppUser->find ( 'first', array (
								'conditions' => array (
										'SppUser.user_name' => $this->Auth->data ['SppUser'] ['username'] 
								),
								'recursive' => - 1 
						) );
						if (! empty ( $usr )) { // password wrong
						                   // set limit time
							$now = time ();
							// Set limitted time
							if ($usr ['SppUser'] ['limited_datetime']) {
								if (date ( "Y-m-d H:i:s", $now ) < $usr ['SppUser'] ['limited_datetime']) { // in limit time
									$usr ['SppUser'] ['pwd_ng_time'] += 1;
								} else { // out limit time
								         // reset the number user input wrong password
									$usr ['SppUser'] ['pwd_ng_time'] = 1;
									// set new limited time
									$usr ['SppUser'] ['limited_datetime'] = date ( "Y-m-d H:i:s", $now + Configure::read ( 'Message.TIME_LIMITED' ) );
								}
							} else {
								// dont have limit time
								// reset the number user input wrong password
								$usr ['SppUser'] ['pwd_ng_time'] = 1;
								// set new limited time
								$usr ['SppUser'] ['limited_datetime'] = date ( "Y-m-d H:i:s", $now + Configure::read ( 'Message.TIME_LIMITED' ) );
							}
							if ($usr ['SppUser'] ['pwd_ng_time'] === Configure::read ( 'Message.PWD_ND_TIME' )) {
								// set locked time
								$usr ['SppUser'] ['locked_datetime'] = date ( "Y-m-d H:i:s", $now + Configure::read ( 'Message.TIME_LOCKED' ) );
								$usr ['SppUser'] ['pwd_ng_time'] = 0;
								$usr ['SppUser'] ['limited_datetime'] = null;
							}
							$this->SppUser->save ( $usr, false );
						}
						$this->Session->setFlash ( $this->Auth->loginError, $this->Auth->flashElement, array (), 'auth' );
					}
				} else {
					$this->redirect ( array (
							'action' => 'menu' 
					) );
				}
			}
		} else {
			if ($this->Auth->user ()) {
				$this->redirect ( array (
						'action' => 'menu' 
				) );
			}
		}
	}
	function logout() {
		$this->Auth->logout ();
		$this->Session->delete ( 'Upload.File' );
		$this->redirect ( array (
				'action' => 'login' 
		) );
	}
	
	/**
	 * Create main menu
	 * 
	 * @author : binhtt
	 * @param        	
	 *
	 * @return
	 *
	 */
	function menu() {
		if ($user = $this->Auth->user ()) {
			$this->Session->delete ( 'Search.keyword' );
			// add by Thieu
			$this->Session->delete ( 'Search.searchkey' );
			
			$this->Session->delete ( 'content.url' );
			$this->Session->delete ( 'Upload.File' );
			$this->Session->delete ( 'content.Item' );
			$this->Session->delete ( 'dataBuff' );
			
			$roles = $this->getUserRole ( $user ['SppUser'] ['id'] );
			$this->set ( 'roles', $roles );
			$this->set( 'questionNotAnswer', $this->SppQuestion->countQuestionNotAnswer());
			$this->set( 'correctionNotAnswer', $this->SppCorrection->countCorrectionNotAnswer());
		} else {
			$this->redirect ( array (
					'action' => 'login' 
			) );
		}
	}
	
	/**
	 * Change password
	 * 
	 * @author binhtt
	 * @param        	
	 *
	 * @return @created 2011/14/09
	 */
	function changePassword() {
		// check session and role
		if(!$this->isAchievementManagement()){
			$this->render('/elements/error');
			return;
		}
		$user = $this->Auth->user ();
		$session = $this->Session->read ();
		$id = $session ['Auth'] ['SppUser'] ['id'];
		
		if (! empty ( $user ) && ! empty ( $this->data )) {
			$this->set ( 'data', $this->data );
			$errors = array ();
			if (empty ( $this->data ['SppUser'] ['old_password'] )) {
				array_push ( $errors, Configure::read ( 'Message.ERR_CHANGEPWD_OLD' ) );
			}
			if (empty ( $this->data ['SppUser'] ['new_password'] )) {
				// $errors[1] = Configure::read('Message.ERR_CHANGEPWD_NEW');
				array_push ( $errors, Configure::read ( 'Message.ERR_CHANGEPWD_NEW' ) );
			}
			if (empty ( $this->data ['SppUser'] ['new_password_confirm'] )) {
				// $errors[0] = Configure::read('Message.ERR_CHANGEPWD_NEW_CONFIRM');
				array_push ( $errors, Configure::read ( 'Message.ERR_CHANGEPWD_NEW_CONFIRM' ) );
			}
			
			if (preg_match ( "/^[0-9a-zA-Z]*$/", $this->data ['SppUser'] ['new_password'] ) === 0) {
				array_push ( $errors, Configure::read ( 'Message.ERR_PWD_RULE' ) );
			}
			
			if (preg_match ( "/^[0-9a-zA-Z]*$/", $this->data ['SppUser'] ['new_password_confirm'] ) === 0) {
				array_push ( $errors, Configure::read ( 'Message.ERR_PWD_RULE' ) );
			}
			
			if (empty ( $errors )) {
				// check old password is correct
				$password = $this->Auth->password ( $this->data ['SppUser'] ['old_password'] );
				
				$validate = $this->SppUser->find ( 'first', array (
						'conditions' => array (
								'SppUser.id' => $id,
								'SppUser.user_pwd' => $password 
						),
						'recursive' => - 1 
				) );
				if (! empty ( $validate )) {
					// check new password match with confirm password
					if (strcmp ( $this->data ['SppUser'] ['new_password'], $this->data ['SppUser'] ['new_password_confirm'] ) !== 0) {
						$this->Session->setFlash ( Configure::read ( 'Message.ERR_PWD_CONFIRM' ) );
						$this->redirect ( $this->referer () );
					} else {
						if (strlen ( $this->data ['SppUser'] ['new_password'] ) < 6) {
							$this->Session->setFlash ( Configure::read ( 'Message.ERR_PWD_LENGTH' ) );
							$this->redirect ( $this->referer () );
						} else {
							if (strlen ( $this->data ['SppUser'] ['new_password'] ) > 50) {
								$this->Session->setFlash ( Configure::read ( 'Message.ERR_PWD_MAXLENGTH' ) );
								$this->redirect ( $this->referer () );
							} else {
								// save into database
								$data = $this->data;
								$this->data = $validate;
								$this->data ['SppUser'] ['user_pwd'] = $this->Auth->password ( $data ['SppUser'] ['new_password'] );
								// debug($this->data);die;
								if ($this->SppUser->save ( $this->data, false )) {
									$this->redirect ( array (
											'action' => 'menu' 
									) );
								} else {
									$this->Session->setFlash ( Configure::read ( 'Message.ERR_CHANGE_PWD' ) );
									$this->redirect ( $this->referer () );
								}
							}
						}
					}
				} else {
					$this->Session->setFlash ( Configure::read ( 'Message.ERR_CHANGE_PWD' ) );
					// $this->redirect($this->referer());
				}
			} else {
				$this->set ( 'errors', $errors );
				// $this->redirect($this->referer());
			}
		} else {
			if (! empty ( $user )) {
				unset ( $user ['SppUser'] ['user_pwd'] );
				$this->set ( 'data', $user );
			} else {
				// dont have permission
				$this->render ( '/elements/error' );
			}
		}
	}
	
	/**
	 *
	 * Add new role when create user
	 * 
	 * @param
	 *        	$userId
	 * @param
	 *        	$roleCode
	 * @param
	 *        	$roleName
	 * @param
	 *        	$created
	 * @param $updated return
	 *        	bool
	 */
	function _addRole($userId, $roleId) {
		// create new role record
		$this->SppUserRole->create ();
		$userRole = array ();
		$userRole ["user_id"] = $userId;
		$userRole ["role_id"] = $roleId;
		return $this->SppUserRole->save ( $userRole );
	}
	
	/**
	 *
	 * Delete all role of user
	 * 
	 * @param
	 *        	$user_id
	 */
	function _deleteRoleByUser($userId) {
		$this->loadModel ( 'SppUserRole' );
		$userRoles = $this->SppUserRole->find ( 'all', array (
				'conditions' => array (
						'SppUserRole.user_id' => $userId 
				) 
		) );
		if (! empty ( $userRoles )) {
			foreach ( $userRoles as $userRole ) {
				$this->SppUserRole->delete ( $userRole ['SppUserRole'] ['id'] );
			}
		}
	}
	
	/**
	 *
	 * check a user is locked
	 * 
	 * @param
	 *        	$lockedTime
	 * @param
	 *        	$now
	 */
	function _isLockedUser($lockedTime, $now) {
		$result = false;
		if ($now < $lockedTime) {
			$result = true;
		}
		return $result;
	}
	
	function dialogConfirm() {
		$this->render ( '/elements/dialogconfirm' );
	}
	function _createRole($achievement_management, $support, $system_management) {
		$result = array (
				'achievement_management' => $achievement_management,
				'support' => $support,
				'system_management' => $system_management
		);
		return $result;
	}
	function csvExport() {
		// check session and role
		if(!$this->isSystemManagement()){
			$this->render('/elements/error');
			return;
		}
		$this->layout = false;
		$encode = $_POST ['encode'];
		$data = $this->getCSVData ();
		$array = array ();
		// edit array
		foreach ( $data as $detail ) {
			$newDetail = array ();
			$newDetail [] = $detail ['SppUser'] ['user_name'];
			$role_name = "";
			foreach ( $detail ['SppRole'] as $role ) {
				$role_name .= $role ['role_name'] . "/";
			}
			$role_name = str_replace ( "USER_MANAGEMENT", "ユーザ管理", $role_name );
			$role_name = str_replace ( "CONTENT_MANAGEMENT", "コンテンツ管理", $role_name );
			$role_name = str_replace ( "LICENSE_MANAGEMENT", "ライセンス管理", $role_name );
			$role_name = str_replace ( "DOWNLOAD_MANAGEMENT", "DL集計", $role_name );
			$role_name = str_replace ( "PUSH_MANAGEMENT", "メッセージ管理", $role_name );
			$newDetail [] = $role_name;
			$newDetail [] = $detail ['SppUser'] ['user_desc'];
			$newDetail [] = $detail ['SppUser'] ['locked_datetime'] > date ( "Y-m-d H:i:s" ) ? "ロック" : "";
			
			array_push ( $array, $newDetail );
		}
		
		$header = array (
				USER_NAME,
				USER_ROLE,
				USER_DESC,
				USER_STATE 
		);
		$fileName = date ( 'Ymdhms' );
		$this->Csv->export ( $encode, $array, $header, $fileName . '.csv' );
	}
	private function getCSVData() {
		$searchkey = '';
		if (isset ( $_POST ['data'] ['SppUser'] ['filter'] )) {
			$searchkey = $_POST ['data'] ['SppUser'] ['filter'];
		}
		
		$keyword = empty ( $searchkey ) ? '' : $searchkey;
		$keySearch = "";
		if (! empty ( $keyword )) {
			$keySearch = array (
					'order' => 'user_name',
					'conditions' => array (
							'OR' => array (
									'SppUser.user_name LIKE' => "%" . mysql_real_escape_string ( $keyword ) . "%",
									'SppUser.user_desc LIKE' => "%" . mysql_real_escape_string ( $keyword ) . "%" 
							) 
					) 
			);
		} else {
			$keySearch = array (
					'order' => 'user_name' 
			);
		}
		
		$this->set ( 'keyword', $keyword );
		$data = $this->SppUser->find ( 'all', $keySearch );
		return $data;
	}
}
?>