<?php // $Id;
/**
 * @copyright     2011 (c) SEVENSEAS TECHWORKS Co., Ltd. All Rights Reserved.
 * @package       pass4v
 * @since         2011-07-14
 * We use CakePHP(tm) ver 1.3.9
 */

class Pass4vComponent extends Object
{
	/**
	 * start up process
	 */
	function startup(&$controller)
	{
		$this->controller = $controller;
	}

	/**
	 * write access log
	 *
	 * access log file set Configure accessLogFilename paramater
	 *
	 * @param string $name      target controller name
	 * @param string $status    message status string (success,error,warn,failure,... )
	 * @param string $message   message
	 * @param string $referer   referer information
	 * @param string $agenttype user agent type string
	 */
	function accessLog($name, $status, $message=null, $referer=null, $agenttype=null)
	{
		Configure::read('flagLoggingUserAgent') ? $agent = "(".$_SERVER["HTTP_USER_AGENT"].")" : $agent = "" ;
		if (!empty($agenttype)) {
			$agent .= ":agentType=[".$agenttype."]";
		}
		if ($fh = fopen(Configure::read('accessLogFilename'), 'a+')) {
			fprintf($fh, "[%s] [%-8s]:%s:%s:%s:<%s>:%s\n", date('Y-m-d H:i:s'), $status, $name, $message, $agent, $_SERVER["REMOTE_ADDR"], $referer);
			fclose($fh);
		}
	}
	
	/**
	 * check parameter exists
	 *
	 * @param array $params     target paramaters
	 * @param array $keys       must exists prameter keys
	 * @return boolean          if not exist must paramater keys false
	 */
	function checkParamsKey($params, $keys)
	{
		if(empty($params)){
			return false;
		}
		foreach ($keys as $key) {
			if (!array_key_exists($key, $params)) { return $key; }
		}
		return true;
	}

	/**
	 * 認証・チェック
	 *
	 * 必須パラメータチェック、アプリケーションチェック、ユーザ認証を行う
	 * ユーザ認証はAuthコンポーネントとは別になる
	 *
	 * @param array $params     確認対象パラメータ（通常 $this->params['form'] の値）
	 * @param array $addkeys    必須パラメータ (application_id, user_id, password, [see:mustParamList])に追加してチェックしたいパラメータを指定する
	 * @param string $func      ログ出力時に記録するためのファンクション（呼び出す側の __FUNCTION__ の値を指定する）
	 * @param string $xml       trueを指定すると応答はXMLになる、指定がない場合は useErrorResponseXML に従う
	 * @return boolean          if error occurred return false
	 *
	 * 端末コード認証を使う場合、terminal_code パラメータは必須項目になり mustParamList に入る
	 * ユーザ情報（userinfo）、アプリケーション情報（application）、端末コード（terminal_code）を保持する public 変数を利用するコントローラ側で必ず用意しておくこと
	 */
	function firstCheck($params, $addkeys, $func, $xml=null) {
		$keys = Configure::read('mustParamList');
		if (!empty($addkeys) && is_array($addkeys)) {
			foreach ($addkeys as $key=>$value) {
				$keys[] = $value;
			}
		}
		$res = $this->checkParamsKey($params, $keys);
		if ($res !== true) {
			$this->errorResponse(Configure::read('errorParameter'), "(".$func."),Post parameter not compleated, must set [".$res."]", $xml);
			return false;
		}
		return true;
	}
	/**
	 * 応答処理
	 *
	 * @param array $response   応答結果
	 * @param string $logmsg    ログメッセージ
	 * @param string $xml       trueを指定すると応答はXMLになる、指定がない場合は useErrorResponseXML に従う
	 */
	function response($response, $logmsg, $xml=null)
	{
		$useXML = Configure::read('useResponseXML');
		if (isset($xml)) { $xml ? $useXML = true : $useXML = false; }

		$this->accessLog($this->controller->name, "success", $logmsg);
		if ($useXML) {
			$this->controller->set("result", $this->cakeArrayToXML($response, 'response', false, true, 'info'));
		} else {
			$this->controller->set("result", $response);
		}
		$this->controller->set('xmlResponse', $xml);
		$this->controller->render("/common/response");
	}

	/**
	 * error response
	 *
	 * typeに'XML'をセットすると応答はXMLに、'JSON'をセットするとJSONになる
	 * typeの指定がなれけば応答はuseErrorResponseXMLの定義値によりXMLかJSONになる
	 *
	 * @param array $result     結果表示用（リザルトとコード、メッセージ）
	 * @param string $logmsg    ログを記録する際のメッセージ
	 * @param string $xml       trueを指定すると応答はXMLになる、指定がない場合は useErrorResponseXML に従う
	 */
	function errorResponse($result, $logmsg, $xml=null)
	{
		$useXML = Configure::read('useErrorResponseXML');
		if (isset($xml)) { $xml ? $useXML = true : $useXML = false; }

		$this->accessLog($this->controller->name, 'error', $logmsg);
		if ($useXML) {
			$this->errorResponseXML($result, 'response');
		} else {
			$this->errorResponseJSON($result);
		}
	}

	/**
	 * XMLによるエラー応答
	 *
	 * 利用にあたって：
	 *     この時点でexitする点に注意
	 *     'code' が必須となる以外は任意
	 *     array( 'code' => 'xxxxx', ..... );
	 *     ex:
	 *     <error><code>xxxxx</code> .... </error>
	 *
	 * @param array $result     応答結果内容ハッシュ
	 * @param string $keyParent トップ要素名（default error）
	 */
	function errorResponseXML($result, $keyParent=null)
	{
		if (empty($keyParent)) { $keyParent = 'error'; }
		$this->sendXMLheader();
		echo $this->cakeArrayToXML($result, $keyParent, true, true);
		exit;
	}

	/**
	 * JSONによるエラー応答
	 *
	 * 利用にあたって：
	 *     この時点でexitする点に注意
	 *     'code' が必須となる以外は任意
	 *     array( 'code' => 'xxxxx', ..... );
	 *     ex:
	 *     { 'error' : { 'code' : xxxxx , .... } }
	 *
	 * @param array $result  応答結果内容ハッシュ
	 */
	function errorResponseJSON($result)
	{
		$this->sendJSONheader();
		echo json_encode($result, JSON_FORCE_OBJECT);
		exit;
	}

	/**
	 * XML応答ヘッダ生成
	 *
	 */
	function sendXMLheader()
	{
		header("Pragma: no-cache");
		header("Cache-Control: no-cache");
		header("Expires: -1");
		header("Content-type: text/xml;charset:UTF-8");
		echo '<?xml version="1.0" ?>';
	}

	/**
	 * JSON応答ヘッダ生成
	 *
	 */
	function sendJSONheader()
	{
		header("Pragma: no-cache");
		header("Cache-Control: no-cache");
		header("Expires: -1");
		header("Content-Type: application/json; charset=utf-8");
	}

	/**
	 * 配列をXMLに変換
	 *
	 * $shiftの指定により、添え字が数字の場合は一階層掘り下げるようにし、rowとして扱わないようにする
	 * $rawの指定により、データをCDATAとして扱わずそのまま利用するように指示する（受け取る側の都合に合わせる）
	 *
	 * @param array $arr        対象配列
	 * @param string $keyParent 親になるキー文字列
	 * @param boolean $shift    対象のキーが数字の場合にシフトするか
	 * @param boolean $raw      CDATAを付与するか
	 * @param string $attr      数字の場合でシフトしない時の添字
	 * @return string
	 */
	function cakeArrayToXML($arr, $keyParent="rows", $shift=false, $raw=false, $attr="row")
	{
		// Original see: http://www.almondjosephmendoza.com/2010/03/converting-cakephp-array-to-xml.html
		// Special Thanks!!

		$arrayRow = "<$keyParent>";

		foreach($arr as $tkey => $trow){
			if (is_numeric($tkey)){
				if ($shift) {
					$nkey = key($trow);
					$trow = array_shift($trow);
					$arrayRow .= $this->cakeArrayToXML($trow, $nkey, $shift, $raw, $attr);
				} else {
					$arrayRow .= $this->cakeArrayToXML($trow, $attr, $shift, $raw, $attr);
				}
			} elseif(is_array($trow)) {
				$arrayRow .= $this->cakeArrayToXML($trow, $tkey, $shift, $raw, $attr);
			} else {
				if ($raw) {
					$arrayRow .= "<$tkey>$trow</$tkey>";
				} else {
					$arrayRow .= "<$tkey><![CDATA[$trow]]></$tkey>";
				}
			}
		}
		$arrayRow .= "</$keyParent>";

		return $arrayRow;
	}

	function downloadContent($download_file,  $func)
	{
		$this->controller->autoLayout = false;
		$this->controller->autoRender = false;
		//Configure::write('debug', 0);
		$ZipFolder = Configure::read('forderContentZip');
		if (empty($dir)) {
			$dir = Configure::read('upload.path');
		}
		
		$filename = $download_file['SppContentFile']['file_name'];
		
		if (strrpos($filename, '.') === false) {
            $pos = 0;
        } else {
            $pos = strrpos($filename, '.') + 1;
        }
        
        
		$ext = substr($filename, $pos);
		
        if(strcmp($ext, 'zip') === 0) {
        	
        	header("Content-disposition: attachment; filename=" . $download_file['SppContentFile']['file_name']);
            header("Content-type: application/octet-stream; name=" . $download_file['SppContentFile']['file_name']);
            header("Content-Length: " . $download_file['SppContentFile']['file_size']);
            	//print(file_get_contents($this->Uploader->uploadDir . $file['SppContentFile']['file_name']));	
			echo $download_file['SppContentFile']['file_content'];
            //exit();
        	//print(stream_get_contents($download_file['SppContentFile']['file_content']));
			$this->accessLog($this->controller->name, "success", "(".$func.":".__FUNCTION__."):Download file=[".$ZipFolder.DS.$download_file['SppContentFile']['file_name'].'.zip'."]");
			return true;
        } else {
	        $zip = new ZipArchive();
			$res = $zip->open($ZipFolder.DS.$download_file['SppContentFile']['file_name'].'.zip', ZipArchive::CREATE);
			$zip->addFromString($download_file['SppContentFile']['file_name'],$download_file['SppContentFile']['file_content']);
			$zip->close();
			if (file_exists($ZipFolder.DS.$download_file['SppContentFile']['file_name'].'.zip')) {
				header("Content-disposition: attachment; filename=".$download_file['SppContentFile']['file_name'].'.zip');
				header("Content-type: application/octet-stream; name=".$download_file['SppContentFile']['file_name'].'.zip');
		
				header("Content-Length: " .  filesize($ZipFolder.DS.$download_file['SppContentFile']['file_name'].'.zip'));
				print(file_get_contents($ZipFolder.DS.$download_file['SppContentFile']['file_name'].'.zip'));
				$this->accessLog($this->controller->name, "success", "(".$func.":".__FUNCTION__."):Download file=[".$ZipFolder.DS.$download_file['SppContentFile']['file_name'].'.zip'."]");
				return true;
			} else {
				$this->accessLog($this->controller->name, "error", "(".$func.":".__FUNCTION__."),Download file=[".$ZipFolder.DS.$download_file['SppContentFile']['file_name'].'.zip'."] not exist or not read");
					
			}
        }		
		return false;
	}
	 
	function genRandomString($length=5,$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPRSTUVWXYZ') {
		$string = null;
		for ($p = 0; $p < $length; $p++) {
		$string .= $characters[mt_rand(0, strlen($characters)-1)];
		}
		return $string;
	}
}