import config   from './config.js';
import db       from "./db";
import SyncData from "./syncData";
import Mypage from "./mypage";
const $         = require('jquery');
const jsCookie  = require('js-cookie');
const page      = require('page');
import client_JS from  './device_info';
import Category from "./category";


export default class Login {

    login(email_address, password){
        // Check nextwork is online
        if(navigator.onLine) {
            var client_Js = new client_JS();
            var device_token = client_Js.getInfoDevice();

            document.getElementById("loadingOverlay").style.display = 'block';
            var dataLogin = window.btoa('{"email_address":"'+email_address+'","password":"'+password+'", "device_token":"'+ device_token +'"}');
            // var dataLogin = $(".login").serialize();
            var dataRequest = {'content':dataLogin};
            var syncDatas = new SyncData();
            var status = syncDatas.clearData();


            $.ajax({
                method: "POST",
                url: config.url_api_login,
                data: dataRequest,
                dataType: "json",
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                success: function(data) {
                    if(data.result == 'OK'){
                        var strDataResponse = window.atob(data.response);
                        var objDataResponse = JSON.parse(strDataResponse);
                        var dataUser = objDataResponse.learner_info;
                        dataUser[password] = window.btoa(dataUser.password);
                        var id_logged = jsCookie.get('id_logged');

                        var confirm = false;
                        if ((dataUser.device_token != null && dataUser.device_token != 1) && dataUser.device_token != device_token && !id_logged) {
                            confirm = window.confirm(config.MESSAGE_DEVIVE_LOGIN);
                        } else {
                            confirm = true;
                        }

                        if (confirm == true) {
                            db.user.clear();

                            // insert database after logged
                            jsCookie.set('id_logged', dataUser.id, { expires: 1 });
                            jsCookie.set('user', dataUser, { expires: 1 });
                            jsCookie.remove('cookieAutoSaveLeaningLog');

                            // handle sync data from server
                            // set
                            jsCookie.set('is_process_sync', true, { expires: 1 });
                            jsCookie.set('code_error_process_sync', 0, { expires: 1 });
                            let allDataForClient = [];
                            syncDatas.handleSyncDataFromServer(dataUser.id, allDataForClient);

                            // check process sync
                            var check_process_sync = setInterval(function(){
                                if(jsCookie.get('is_process_sync') == (false).toString())
                                {
                                    clearInterval(check_process_sync);
                                    $('[data-popup="popup-1"]').fadeOut(350);
                                    $('#login').hide();
                                    $('#logout').show();
                                    document.getElementById("loadingOverlay").style.display = 'none';
                                }
                            },500);

                            var dataUpdate = window.btoa('{"learner_id":"'+ dataUser.id + '", "device_token":"'+ device_token +'"}');
                            var data = {'content':dataUpdate};
                            $.ajax({
                                method: "POST",
                                url: config.url_api_update_device_token,
                                data: data,
                                dataType: "json",
                                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                                success: function(data) {
                                    if(data.result == 'OK'){
                                        return
                                    }
                                }
                            });
                        } else {
                            setTimeout(function() {
                                $('[data-popup="popup-1"]').fadeOut(350);
                                document.getElementById("loadingOverlay").style.display = 'none';
                            }, 1000);
                        }
                    }
                    else {
                        document.getElementById("loadingOverlay").style.display = 'none';
                        if (data.message != '') {
                            $('.error_login').text(data.message);
                        } else {
                            $('.error_login').text('メールアドレス、またパスワードが正しくありません');
                        }
                    }
                },
                error: function(xhr, desc, err) {
                    console.log(xhr);
                    console.log("Details0: " + desc + "\nError:" + err);
                    document.getElementById("loadingOverlay").style.display = 'none';
                },
            });
        } else {
            alert(config.NETWORK.OFFLINE_PAGE)
        }

    }



    logout(checkDeviceToken = 'Logout'){
        // Check nextwork is online
        if(navigator.onLine) {
            var myPageObj = new Mypage();
            var syncDatas = new SyncData();
            var that = this;
            document.getElementById("loadingOverlay").style.display = 'block';
            try {
                let studyInfo =  myPageObj.getStudyInfo();
                var save_study = false;

                studyInfo.then(function(content) {
                    save_study = $.ajax({
                        type: "POST",
                        url : config.url_api_mypage_report,
                        data: {'content' : content},
                        success: function(data){
                            if (data.result == "OK") {
                                let learner_id = jsCookie.get('id_logged');
                                var dataLogin = window.btoa('{"learner_id":"'+learner_id+'", "device_token":"'+ checkDeviceToken +'"}');
                                var dataRequest = {'content':dataLogin};
                                var logout = false;

                                logout = $.ajax({
                                    method: "POST",
                                    url: config.url_api_logout,
                                    data: dataRequest,
                                    async: false,
                                    dataType: "json",
                                    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                                    success: function(data) {
                                        if (data.result == "OK") {
                                            jsCookie.remove('id_logged');
                                            jsCookie.remove('user');
                                            jsCookie.remove('user_rank');
                                            localStorage.setItem('soundon', false);
                                            jsCookie.set('data_sync_seccess', false, { expires: 1 });
                                            syncDatas.clearData();

                                            // Clear all cookie
                                            that.clearCache();

                                            return true;
                                        } else {
                                            return false;
                                        }
                                        document.getElementById("loadingOverlay").style.display = 'none';
                                    },
                                    error: function (xhr, status) {
                                        document.getElementById("loadingOverlay").style.display = 'none';
                                        return false;
                                    }
                                });

                                if (logout) {
                                    setTimeout(function() {
                                        window.location.href = config.subfolder + '/'
                                    }, 1500);
                                }
                                else
                                {
                                    document.getElementById("loadingOverlay").style.display = 'none';
                                }
                            }
                            else
                            {
                                document.getElementById("loadingOverlay").style.display = 'none';
                                return true
                            }
                        },
                        error: function (xhr, status) {
                            console.log('Call saveSudyInfo error');
                            document.getElementById("loadingOverlay").style.display = 'none';
                            return false;
                        }
                    });
                });
            } catch (e) {
                console.log(e);
                document.getElementById("loadingOverlay").style.display = 'none';
            }
        } else {
            alert(config.NETWORK.OFFLINE_PAGE)
        }
    }

    /*
    * check isset login of learner
    *
    * @return if isset then return ID learner else return false
    * @updated 07.01.2019
    */
    isLogged(){
        var id_logged = jsCookie.get('id_logged');
        if(typeof id_logged != 'undefined' && id_logged != 0){
            return id_logged;
        }
        else {
            return false;
        }
    }

    clearCache(){
        var cookie = document.cookie.split(';');
        localStorage.clear();

        for (var i = 0; i < cookie.length; i++) {
            var chip = cookie[i],
                entry = chip.split("="),
                name = entry[0];

            document.cookie = name+" =; expires = Thu, 01 Jan 1970 00:00:00 UTC";
        }
    }
}
