import config from './config.js';
import db     from './db.js';
import Quiz   from './quiz.js';
import Record from './record.js';
import Login        from './login.js';

const R = require('ramda');

// Quiz must be join with Choice if you want to use this class
export default class QuizRecorder {
    /**
     * @param   {object}        quiz
     * @param   {string|array}  userAnswers
     * @return  {[type]}
     */
    async solve(quiz, userAnswers) {
        var recordObj   = new Record();
        var loginObj = new Login();
        console.log("start record find:"+quiz.category_no+":"+quiz.quiz_no);
        var record      = await recordObj.find(quiz.category_no, quiz.quiz_no);
        console.log("start record end");
        var recordStore = record;


        if (!record) {
        console.log("recordなし");
            let array_key = [quiz.category_no, quiz.subcategory_no, quiz.quiz_no];
            let primary_key = array_key.toString();
        console.log("primary_key:"+primary_key);

            recordStore = {
                'id' : primary_key,
                'category_no': quiz.category_no, 
                'subcategory_no': quiz.subcategory_no, 
                'quiz_no': quiz.quiz_no,
                'try_count': 0,
                'incorrect_count': 0,
                'last_answered': 0,
                'last_incorrect_count': 0,
                'selectbox': false,
                'content_id': quiz.content_id,
                'client_id': '', 
                'learner_id': loginObj.isLogged(),
                'is_modify': 1
            };

        var start = new Date();  // log start timestamp
            recordStore.id = await db.record.put(recordStore);
        var end = new Date();  // log start timestamp
        console.log("record put:"+(end - start));
        }

        console.log("isAnswerCorrect");
        if (this.isAnswerCorrect(quiz, userAnswers)) {
            recordStore.last_answered = 1;
            recordStore.try_count++;
        } else {
            recordStore.last_answered = 0;
            recordStore.incorrect_count++;
            recordStore.last_incorrect_count++;
            recordStore.try_count++;
        }
        // update 
        recordStore.is_modify = 1;

        console.log("return solve");
        return await db.record.update(recordStore.id, recordStore).catch('Data Limit', err => {
            err.failures.forEach(failure => {
                alert(config.DATA_LIMIT_DESKTOP.MEG_OVERFLOW_DATA_LIMIT)
            });
        });
    }

    async bookmark(quiz) {
        var recordObj   = new Record();
        var loginObj = new Login();
        var record      = await recordObj.find(quiz.category_no, quiz.quiz_no);
        var recordStore = record;

        if (!record) {
            let array_key = [quiz.category_no, quiz.subcategory_no, quiz.quiz_no];
            let primary_key = array_key.toString();
            recordStore = {
                'id' : primary_key,
                'category_no': quiz.category_no,
                'subcategory_no': quiz.subcategory_no, 
                'quiz_no': quiz.quiz_no,
                'try_count': 0,
                'incorrect_count': 0,
                'last_answered': 0,
                'last_incorrect_count': 0,
                'selectbox': true,
                'content_id': quiz.content_id,
                'client_id': '',
                'learner_id': loginObj.isLogged(),
                'is_modify': 1
            };

            return await db.record.put(recordStore) ? true : false;
        }

        recordStore.selectbox = !recordStore.selectbox;
        
         // update 
        recordStore.is_modify = 1;

        return await db.record.update(recordStore.id, recordStore).catch('Data Limit', err => {
            err.failures.forEach(failure => {
                alert(config.DATA_LIMIT_DESKTOP.MEG_OVERFLOW_DATA_LIMIT)
            });
        });
    }

    isAnswerCorrect(quiz, userAnswers) {
        let quizObj  = new Quiz();
        let quizType = quizObj.getQuizType(quiz);
        let answerNo = quiz.answer_no;

        switch (quizType) {
            case config.QUIZ_TYPE_YES_NO:
            case config.QUIZ_TYPE_ONE_CHOICE:
                return quiz.answer_no == userAnswers;
            case config.QUIZ_TYPE_MULTI_CHOICES:
                answerNo = answerNo.split('|')
                                   .map((answer) => parseInt(answer));
                return R.equals(userAnswers, answerNo);
            case config.QUIZ_TYPE_FILL_EMPTY:
                return false;
        }

        return false;
    }

    async getQuizRecord (categoryNo, quizNo) {
        var recordObj   = new Record();
        let record      = await recordObj.find(categoryNo, quizNo);

        return record;
    }

    findAll(){
        return db.transaction('r', db.record, async () => {
            return db.record
                .toArray();
        });
    }

    // bitone-g add 2019.1.19 -- start --
    async sync(quiz1, quiz2) {
        var recordObj1   = new Record();
        var recordObj2   = new Record();
        var record1      = await recordObj1.find(quiz1.category_no, quiz1.quiz_no);
        var record2      = await recordObj2.find(quiz2.category_no, quiz2.quiz_no);
        if(record1.try_count == record2.try_count){
        	return true;
        }
        var try_count = (record1.try_count > record2.try_count)?record1.try_count:record2.try_count;
        var incorrect_count = (record1.incorrect_count > record1.incorrect_count)?record1.record1.incorrect_count:record2.incorrect_count;
        var last_incorrect_count = (record1.last_incorrect_count > record1.last_incorrect_count)?record1.record1.last_incorrect_count:record2.last_incorrect_count;
        var last_answered = record1.last_answered;
        record1.try_count = try_count;
        record1.incorrect_count = incorrect_count;
        record1.last_incorrect_count = last_incorrect_count;
        record1.last_answered = last_answered;
        record2.try_count = try_count;
        record2.incorrect_count = incorrect_count;
        record2.last_incorrect_count = last_incorrect_count;
        record2.last_answered = last_answered;
        
        await db.record.update(record2.id, record2);
        await db.record.update(record1.id, record1);
        
        return true;
    }
    // bitone-g add 2019.1.19 -- end --
}