import config from './config.js';
import db     from './db.js';
import Choice from './choice.js';
import QuizRecorder from './quizRecorder.js';
import Continue from "./continue";
import SyncData     from "./syncData";
import Record from "./record";
import Incorrect     from './incorrect.js';
import {createListQuizIncorrectRandom } from './common';
const page      = require('page');
const jsCookie      = require('js-cookie');
const $             = require('jquery');

export default class Quiz {
    find(categoryNo, subCategoryNo, quizNo, currentPage = 0, mode = 'nomarl') {
        return db.transaction('rw', db.category, db.sub_category, db.quizzes, db.choices, db.record, db.random_quiz, db.random_incorrect, async () => {
            let choiceObj = new Choice();
            let quiz = await db.quizzes
                .where('category_no').equals(categoryNo)
                .and((quiz) =>
                    (
                        quiz.subcategory_no == subCategoryNo  &&
                        quiz.quiz_no        == quizNo
                    )
                )
                .first();

            // if (currentPage == 0) {
            //     let quizzes = await db.quizzes
            //         .where('category_no').equals(categoryNo)
            //         .and((quiz) => quiz.subcategory_no == subCategoryNo)
            //         .sortBy('quiz_no');
            //         // .toArray();
            //
            //     for(var i = 0; quizzes.length > i; i++){
            //         if (quizzes[i]['quiz_no'] == quiz['quiz_no']) {
            //             currentPage = i + 1;
            //         }
            //     }
            //     quiz.mode = 'normal';
            // }

            var quizmode = jsCookie.get('quiz_mode');
            if (quizmode == "random") {
                let randomQ = await db.random_quiz
                    .reverse()
                    .sortBy('local');

                quiz.random = 'random';
                quiz.mode = 'random';
                quiz.pagingQuiz = this.getAnswerNextQuiz(categoryNo, subCategoryNo, quizNo, randomQ)
            } else if (mode == 'bookmark') {
                quiz.pagingQuiz = await this.pagingQuizMode(categoryNo, subCategoryNo, currentPage, mode);
                quiz.mode = 'bookmark';
            }
            else {
                quiz.pagingQuiz = await this.pagingQuizMode(categoryNo, subCategoryNo, currentPage);
                quiz.mode = 'normal';
            }
            quiz.choices = await choiceObj.find(categoryNo, subCategoryNo, quiz.quiz_no);

            /**
             * Fix render link img 
             * 
             * @updated 20.12.2018
             */
            if(quiz.choices.length)
            {
                for (var i = 0 ; i < quiz.choices.length ; i++) {
                    quiz.choices[i].answer = quiz.choices[i].answer.replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
                }
            }
            
            quiz.comment = quiz.comment
                .replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
            quiz.sentence = quiz.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');

            return quiz;
        });
    }

    findAnswerQuizSubZero(categoryNo, subCategoryNo, quizNo, currentPage = 1) {
        return db.transaction('r', db.quizzes, db.choices, db.record, async () => {
            let choiceObj = new Choice();

            let quizzes = await db.quizzes
                .where('category_no').equals(categoryNo)
                .toArray();

            quizzes = await Promise.all(quizzes.map(async (quiz) => {
                let records = await db.record
                    .where('category_no').equals(categoryNo)
                    .and((record) => {
                        return (
                            record.quiz_no    == quiz.quiz_no     &&
                            record.content_id == quiz.content_id  &&
                            record.selectbox  == true
                        );
                    }).toArray();

                if (records.length >= 1 )
                    quiz.record = records[0];
                else
                    quiz.record = records;

                return quiz;
            })).then((quizzes) =>   quizzes.filter((quiz) => quiz.record.selectbox));

            if (quizzes.length > 0) {
                let pages = [];

                let quiz = quizzes[currentPage-1];

                pages.pageTotal = quizzes.length;

                if ((currentPage - 1) > 0){
                    pages.pagePrev = currentPage - 1;
                }

                if (currentPage < quizzes.length){
                    pages.pageNext = currentPage + 1 ;
                }

                pages.currentPage = currentPage;
                pages.category_no = categoryNo;
                if (subCategoryNo == 0) {
                    quiz.bookmarkall = 'all';
                }
                pages.subcategory_no = subCategoryNo;
                quiz.mode = 'bookmark';
                quiz.pagingQuiz = pages;

                quiz.choices = await choiceObj.find(categoryNo, quiz.subcategory_no, quiz.quiz_no);
                for (var i = 0; i < quiz.choices.length; i++) {
                    quiz.choices[i]['answer'] = quiz.choices[i]['answer'].replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
                }
                return quiz;
            }

            quiz.mode = 'normal';

            let randomQuiz = jsCookie.get('random');
            if (typeof(randomQuiz) != "undefined") {
                var randomQ = JSON.parse(jsCookie.get('random'));
                quiz.random = 'random';
                quiz.mode = 'random';
                quiz.pagingQuiz = this.getAnswerNextQuiz(categoryNo, subCategoryNo, quizNo, randomQ)
            } else {
                quiz.pagingQuiz = await this.pagingQuizMode(categoryNo, subCategoryNo, currentPage);
            }

            quiz.choices = await choiceObj.find(categoryNo, subCategoryNo, quiz.quiz_no);

            if(quiz.choices.length)
            {
                for (var i = 0 ; i < quiz.choices.length ; i++) {
                    quiz.choices[i].answer = quiz.choices[i].answer.replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
                }
            }

            quiz.comment = quiz.comment
                .replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
            quiz.sentence = quiz.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');

            return quiz;
        });
    }

    /**
     * get info quiz
     *
     * @param categoryNo int
     * @param subCategoryNo int
     * @param quizNo int
     *
     * return object info quiz
     */

    getInfoQuiz(categoryNo, subCategoryNo, quizNo) {
        return db.transaction('r', db.quizzes, db.choices, async () => {
            let choiceObj = new Choice();
            let quiz = await db.quizzes
                .where('category_no').equals(categoryNo)
                .and((quiz) =>
                    (
                        quiz.subcategory_no == subCategoryNo  &&
                        quiz.quiz_no        == quizNo
                    )
                )
                .first();

            // 
            quiz.choices = await choiceObj.find(categoryNo, subCategoryNo, quiz.quiz_no);
           
            // conver data
            quiz.comment = quiz.comment
                .replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
            quiz.sentence = quiz.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');

            return quiz;
        });
    }

   

    getAnswerNextQuiz (categoryNo, subCategory, quizNo, quizzes) {
        var currentPage = parseInt(jsCookie.get('randompage')) ;
        var pages = [];
        // this.shuffle(quizzes);

        if (quizzes.length < currentPage){
            return page.redirect(config.subfolder + config.error_page);
        }

        var quiz = quizzes[currentPage - 1];

        if (currentPage - 1 >= 0) {
            pages.pagePrev = currentPage -1;
            pages.prevSubcategory_no = quizzes[currentPage - 1 ]['subcategory_no'];
        }

        if (currentPage == quizzes.length) {
            pages.pagePrev = currentPage - 1;
            pages.prevSubcategory_no = quizzes[currentPage - 1 ]['subcategory_no'];
            pages.quizEnd = 'end';
            pages.pageNext = 'popup-result';

            pages.randomTotalCorrect = parseInt(jsCookie.get('randomTotalCorrect'));
            pages.randomTotalError =  parseInt(jsCookie.get('randomTotalError'));
        }
        else {
            if (currentPage > 1) {
                pages.pagePrev = parseInt(currentPage) -1;
                pages.prevSubcategory_no = quizzes[currentPage - 1 ]['subcategory_no'];
            }
        }

        if (quizzes.length >= currentPage){
            if (quizzes.length - 1 == currentPage) {
                pages.pageNext = currentPage + 1;
                pages.nextSubcategory_no = quizzes[currentPage-1]['subcategory_no'];
            } else {
                if (quizzes.length == currentPage) {
                    pages.pageNext = currentPage;
                    pages.nextSubcategory_no = quizzes[currentPage-1]['subcategory_no'];
                } else {
                    pages.pageNext = currentPage + 1 ;
                    pages.nextSubcategory_no = quizzes[currentPage + 1]['subcategory_no'];
                }
            }
        }
        jsCookie.set('randompage', currentPage, { expires: 1 } );
        pages.pageTotal = quizzes.length;
        pages.currentPage = parseInt(currentPage-1);
        pages.category_no = quizzes[currentPage-1]['category_no'];
        pages.quiz_no = quizzes[currentPage-1]['quiz_no'];

        return pages;
    }

    getTotalQuizOfCategory(categoryNo) {
        return db.transaction('r', db.quizzes, () => {
            return db.quizzes
                .where('category_no').equals(categoryNo)
                .count();
        });
    }

    getTotalQuizOfSubCategory(categoryNo, subCategoryNo) {
        return db.transaction('r', db.quizzes, () => {
            return db.quizzes
                .where('category_no').equals(categoryNo)
                .and((quiz) => {
                    return (
                        quiz.subcategory_no   == subCategoryNo  &&
                        quiz.choice_row_count >= 1
                    );
                })
                .count();
        });
    }

    getTotalAnsweredQuizOfCategory(categoryNo, learnerId) {
        return db.transaction('r', db.record, () => {
            return db.record
                .where('category_no').equals(categoryNo)
                .and((record) => {
                    return (
                        record.try_count > 0   // &&
                        // At this time, we have no login feature
                        // record.learnerId == learnerId
                    );
                })
                .count();
        });
    }

    getTotalAnsweredQuizOfSubCategory(categoryNo, subCategoryNo) {
        return db.transaction('r', db.record, () => {
            return db.record
                .where('category_no').equals(categoryNo)
                .and((record) => {
                    return (
                        record.subcategory_no == subCategoryNo &&
                        record.try_count      >  0
                    );
                })
                .count();
        });
    }

    getTotalUnansweredQuizOfCategory(categoryNo, learnerId) {
        return db.transaction('r', db.quizzes, db.record, async () => {
            let quizzes = await db.quizzes
                .where('category_no').equals(categoryNo)
                .toArray();

            quizzes = await Promise.all(quizzes.map(async (quiz) => {
                let records = await db.record
                    .where('category_no').equals(categoryNo)
                    .and((record) => {
                        return record.quiz_no == quiz.quiz_no
                    })
                    .toArray();

                quiz.records = records.length ? records : [];

                return quiz;
            }))
            .then((quizzes) =>
                quizzes.filter((quiz) => !quiz.records.length)
            );

            return quizzes.length;
        });
    }

    getTotalNoAnsweredQuizOfCategory(categoryNo, learnerId) {
        return db.transaction('r', db.quizzes, db.record, async () => {
            var quizzes = await db.quizzes
                .where('category_no').equals(categoryNo)
                //.and((quiz) => quiz.choice_row_count != -1)
                .count();
            return quizzes;
        });
    }

    getTotalUnansweredQuizOfSubCategory(categoryNo, subCategoryNo, learnerId) {
        return db.transaction('r', db.quizzes, db.record, async () => {
            let quizzes = await db.quizzes
                .where('category_no').equals(categoryNo)
                .and((quiz) => quiz.subcategory_no == subCategoryNo)
                .toArray();

            quizzes = await Promise.all(quizzes.map(async (quiz) => {
                let records = await db.record
                    .where('category_no').equals(categoryNo)
                    .and((record) => record.quiz_no == quiz.quiz_no)
                    .toArray();

                quiz.records = records.length ? records : [];

                return quiz;
            }))
            .then((quizzes) =>
                quizzes.filter((quiz) => !quiz.records.length)
            );

            return quizzes.length;
        });
    }

    getTotalIncorrectAnsweredQuizOfCategory(categoryNo, learnerId) {
        return db.transaction('r', db.quizzes, db.record, async () => {
            let quizzes = await db.quizzes
                .where('category_no').equals(categoryNo)
                .toArray();

            quizzes = await Promise.all(quizzes.map(async (quiz) => {
                let records = await db.record
                    .where('category_no').equals(categoryNo)
                    .and((record) => {
                        return (
                            record.quiz_no       == quiz.quiz_no     &&
                            record.content_id    == quiz.content_id  &&
                            record.last_answered == 0
                        );
                    })
                    .toArray();

                quiz.records = records.length ? records : [];

                return quiz;
            }))
            .then((quizzes) =>
                quizzes.filter((quiz) => quiz.records.length)
            );

            return quizzes.length;
        });
    }

    getTotalIncorrectAnsweredQuizOfSubCategory(categoryNo, subCategoryNo, learnerId) {
        return db.transaction('r', db.quizzes, db.record, async () => {
            let quizzes = await db.quizzes
                .where('category_no').equals(categoryNo)
                .and((quiz) => quiz.subcategory_no == subCategoryNo)
                .toArray();

            quizzes = await Promise.all(quizzes.map(async (quiz) => {
                let records = await db.record
                    .where('category_no').equals(categoryNo)
                    .and((record) => {
                        return (
                            record.quiz_no       == quiz.quiz_no     &&
                            record.content_id    == quiz.content_id  &&
                            record.last_answered == 0   &&
                            record.try_count     >  0
                        );
                    })
                    .toArray();

                quiz.records = records.length ? records : [];

                return quiz;
            }))
            .then((quizzes) =>
                quizzes.filter((quiz) => quiz.records.length)
            );

            return quizzes.length;
        });
    }

    getTotalBookmarkQuizOfCategory(categoryNo, learnerId) {
        return db.transaction('r', db.quizzes, db.record, async () => {
            let quizzes = await db.quizzes
                .where('category_no').equals(categoryNo)
                .toArray();

            quizzes = await Promise.all(quizzes.map(async (quiz) => {
                let records = await db.record
                    .where('category_no').equals(categoryNo)
                    .and((record) => {
                        return (
                            record.quiz_no    == quiz.quiz_no     &&
                            record.content_id == quiz.content_id  &&
                            record.selectbox  == true
                        );
                    })
                    .toArray();

                quiz.records = records.length ? records : [];

                return quiz;
            }))
            .then((quizzes) =>
                quizzes.filter((quiz) => quiz.records.length)
            );

            return quizzes.length;
        });
    }

    getTotalBookmarkQuizOfSubCategory(categoryNo, subCategoryNo, learnerId) {
        return db.transaction('r', db.quizzes, db.record, async () => {
            let quizzes = await db.quizzes
                .where('category_no').equals(categoryNo)
                .and((quiz) => quiz.subcategory_no == subCategoryNo)
                .toArray();

            quizzes = await Promise.all(quizzes.map(async (quiz) => {
                let records = await db.record
                    .where('category_no').equals(categoryNo)
                    .and((record) => {
                        return (
                            record.quiz_no    == quiz.quiz_no     &&
                            record.content_id == quiz.content_id  &&
                            record.selectbox  == true
                        );
                    })
                    .toArray();

                quiz.records = records.length ? records : [];

                return quiz;
            }))
            .then((quizzes) =>
                quizzes.filter((quiz) => quiz.records.length)
            );
            return quizzes.length;
        });
    }

    pagingQuizMode(categoryNo, subCategoryNo, currentPage, mode = 'normal') {
        return db.transaction('r', db.quizzes, db.choices, db.record, db.random_quiz, async () => {
            let choiceObj = new Choice();
            let recordObj = new QuizRecorder();
            var totalRecords, page, limit;

            var quiz_mode = jsCookie.get('quiz_mode');

            if(quiz_mode == 'incorrect') {
                var quizzes = await db.quizzes
                    .where('category_no').equals(categoryNo)
                    .and((quiz) => quiz.subcategory_no == subCategoryNo)
                    .toArray((quizzes) => {
                        return Promise.all(quizzes.map(async (quiz) => {
                            let records = await db.record
                                .where('category_no').equals(categoryNo)
                                .and((record) =>
                                    record.quiz_no       == quiz.quiz_no  &&
                                    record.content_id    == quiz.content_id  &&
                                    record.last_answered == 0             &&
                                    record.try_count     >  0
                                ).toArray();

                            quiz.record = records;

                            return quiz;
                        }))
                            .then((quizzes) =>
                                quizzes.filter((quiz) => quiz.record.length)
                            );
                    });
                totalRecords = quizzes.length;
                if (totalRecords == 1){
                    currentPage = 0;
                }

                page = await db.quizzes
                    .where('category_no').equals(categoryNo)
                    .and((page) => page.subcategory_no == subCategoryNo)
                    .offset(currentPage)
                    .limit(1)
                    .toArray((quizzes) => {
                        return Promise.all(quizzes.map(async (quiz) => {
                            let records = await db.record
                                .where('category_no').equals(categoryNo)
                                .and((record) =>
                                    record.quiz_no       == quiz.quiz_no  &&
                                    record.content_id    == quiz.content_id  &&
                                    record.last_answered == 0             &&
                                    record.try_count     >  0
                                ).toArray();

                            quiz.record = records;

                            return quiz;
                        })).then((quizzes) =>
                            quizzes.filter((quiz) => quiz.record.length)
                        );
                    });
            }
            else if (quiz_mode == 'not-answered-yet') {
                let quizzes = await db.quizzes
                    .where('category_no').equals(categoryNo)
                    .and((quizzes) => {
                        return quizzes.subcategory_no == subCategoryNo
                    })
                    .toArray((quizzes) => {
                        return Promise.all(quizzes.map(async (quiz) => {
                            let records = await db.record
                                .where('category_no').equals(categoryNo)
                                .and((record) => {
                                    return record.quiz_no == quiz.quiz_no
                                })
                                .toArray();

                            quiz.records = records;

                            return quiz;
                        })).then((quizzes) =>
                            quizzes.filter((quiz) => !quiz.records.length)
                        );
                    });
                totalRecords = quizzes.length;
                if (totalRecords == 1){
                    currentPage = 0;
                }
                page = await db.quizzes
                    .where('category_no').equals(categoryNo)
                    .and((page) => page.subcategory_no == subCategoryNo)
                    .offset(currentPage)
                    .limit(1)
                    .toArray((quizzes) => {
                        return Promise.all(quizzes.map(async (quiz) => {
                            let records = await db.record
                                .where('category_no').equals(categoryNo)
                                .and((record) => {
                                    return record.quiz_no == quiz.quiz_no
                                })
                                .toArray();

                            quiz.records = records;

                            return quiz;
                        })).then((quizzes) =>
                            quizzes.filter((quiz) => !quiz.records.length)
                        );
                    });

            }
            else if (mode == "list_search") {
                totalRecords = await db.random_quiz
                    .where('category_no').equals(categoryNo)
                    .and((quiz) => quiz.subcategory_no == subCategoryNo)
                    .count();

                page = await db.random_quiz
                    .where('category_no').equals(categoryNo)
                    .and((page) => page.subcategory_no == subCategoryNo)
                    .offset(currentPage)
                    .limit(1)
                    .toArray();
            }
            else if (mode == "bookmark") {
                var quizzes= [];
                let quizzesBookmark = await db.record
                    .where('category_no').equals(categoryNo)
                    .and((record) => {
                        return (
                            record.selectbox  == true
                        );
                    }).toArray();

                for (var i = 0; i < quizzesBookmark.length; i++) {
                    let quizz = await db.quizzes
                        .where('category_no').equals(categoryNo)
                        .and((quizz) => {
                            return (
                                quizzesBookmark[i].quiz_no    == quizz.quiz_no     &&   quizzesBookmark[i].content_id == quizz.content_id
                            );
                        }).first();
                    quizz.record = quizzesBookmark[i];
                    quizzes.push(quizz);
                }

                if (quizzes.length > 0) {
                    let pages = {};
                    let quiz = quizzes[currentPage-1];

                    if ((currentPage - 1) > 0){
                        pages.pagePrev = currentPage - 1;
                    } else {
                        pages.pagePrev = quizzes.length;
                    }

                    if (currentPage < quizzes.length){
                        pages.pageNext = currentPage + 1 ;
                    } else {
                        pages.pageNext = 1
                    }

                    if (subCategoryNo == 0) {
                        quiz.bookmarkall = 'all';
                    }
                    pages.subcategory_no = quiz.subcategory_no;
                    pages.category_no = categoryNo;
                    pages.pageTotal = quizzesBookmark.length;
                    pages.currentPage = currentPage;

                    return pages;
                }
            }
            else {
                totalRecords = await db.quizzes
                    .where('category_no').equals(categoryNo)
                    .and((quiz) => quiz.subcategory_no == subCategoryNo)
                    .count();

                page = await db.quizzes
                    .where('category_no').equals(categoryNo)
                    .and((page) => page.subcategory_no == subCategoryNo)
                    .offset(currentPage)
                    .limit(1)
                    .sortBy('quiz_no');
            }

            if (page.length == 1) {
                page = page[0];
            } else {
                page.category_no = categoryNo;
                page.subcategory_no = subCategoryNo;
            }

            if ((currentPage - 1) >= 0 && totalRecords >= 1){
                page.pagePrev = currentPage - 1;
            } else if (currentPage == 0) {
                page.pagePrev = 1;
            }

            if (currentPage < totalRecords && totalRecords > 1){
                page.pageNext = currentPage + 1 ;
            }

            if (page.pagePrev > totalRecords) {
                page.pagePrev = totalRecords;
            }
            page.pageTotal = totalRecords;
            page.currentPage = currentPage;

            return page;
        });
    }

    findByNormalMode(categoryNo, subCategoryNo, quizNo ,currentPage = 1, mode = "") {
        return db.transaction('r', db.quizzes, db.choices, db.record, db.random_quiz, async () => {
            let choiceObj = new Choice();
            let recordObj = new QuizRecorder();
            var quiz =[];

            var quizzes = await db.quizzes
                .where('category_no').equals(categoryNo)
                .and((quiz) => quiz.subcategory_no == subCategoryNo)
                .sortBy('quiz_no');

            if (quizNo >= 1) {
                for (i = 0; i  <quizzes.length; i++) {
                    if (quizzes[i].quiz_no == quizNo) {
                        currentPage = i+1;
                        quiz = quizzes[i];
                    }
                }
            } else {
                quiz = quizzes[currentPage-1];
            }

            if (mode == 'search') {
                quiz.search = true;
            }

            if(typeof quiz != "undefined") {
                quiz.choices = await choiceObj.find(categoryNo, subCategoryNo, quiz.quiz_no);
                quiz.record  = await recordObj.getQuizRecord(categoryNo, quiz.quiz_no);
                if (mode == "list_search" ){
                    quiz.pagingQuiz = await this.pagingQuizMode(categoryNo, subCategoryNo, currentPage, mode);
                } else {
                    quiz.pagingQuiz = await this.pagingQuizMode(categoryNo, subCategoryNo, currentPage);
                }
                quiz.msg = 'OK';
                for (var i = 0; i < quiz.choices.length; i++) {
                    quiz.choices[i]['answer'] = quiz.choices[i]['answer'].replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
                }
            } else {
                // quiz.msg = 'Updating Quiz !!!'
            }

            quiz.comment = quiz.comment
                .replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
            quiz.sentence = quiz.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');

            return quiz;
        });
    }

    /*
    *
    *
    * @updated 2019.01.13
    */
   
    findByContinueMode(categoryNo, subCategoryNo, currentPage = 0) {
        return db.transaction('r', db.quizzes, db.record, db.choices, db.continue_quiz, db.random_quiz, async () => {
            let choiceObj = new Choice();
            var continueObj = new Continue();
            let recordObj = new QuizRecorder();

            var quizNo = 0;
            let quizzes;

            var continueQuiz = await continueObj.findContinueQuiz(categoryNo);
            if (continueQuiz){
                quizNo = continueQuiz.quiz_no;
                subCategoryNo = continueQuiz.subcategory_no;
            }else {
                quizzes = await db.quizzes
                        .where('category_no').equals(categoryNo)
                        .and((quizz) => {
                            return (
                                quizz.subcategory_no    == subCategoryNo
                            );
                        }).first();

                quizNo = quizzes.quiz_no
            }

            quizzes = await db.quizzes
                .where('category_no').equals(categoryNo)
                .and((quizz) => {
                    return (
                        quizz.subcategory_no    == subCategoryNo &&
                        quizz.quiz_no           == quizNo
                    );
                }).first();

            var totalQuiz = await db.quizzes
                .where('category_no').equals(categoryNo)
                .and((quizz) => {
                    return (
                        quizz.subcategory_no    == subCategoryNo
                    );
                }).sortBy('quiz_no');

            for(var i = 0; totalQuiz.length > i; i++){
                if (totalQuiz[i]['quiz_no'] == quizNo) {
                    currentPage = i + 1;
                }
            }

            let quiz = quizzes;

            if(typeof quiz != "undefined") {
                quiz.choices = await choiceObj.find(categoryNo, subCategoryNo, quiz.quiz_no);
                quiz.record  = await recordObj.getQuizRecord(categoryNo, quiz.quiz_no);
                quiz.pagingQuiz = await this.pagingQuizMode(categoryNo, subCategoryNo, currentPage, 'normal' );
                quiz.msg = 'OK'
                for (var i = 0; i < quiz.choices.length; i++) {
                    quiz.choices[i]['answer'] = quiz.choices[i]['answer'].replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
                }
                quiz.mode = "normal"
            }
            else {
                // quiz.msg = 'Updating Quiz !!!'
            }
            quiz.comment = quiz.comment
                .replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
            quiz.sentence = quiz.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');

            return quiz;
        });
    }

    shuffle (array) {
        var input = array;

        for (var i = input.length-1; i >=0; i--) {

            var randomIndex = Math.floor(Math.random()*(i+1));
            var itemAtIndex = input[randomIndex];

            input[randomIndex] = input[i];
            input[i] = itemAtIndex;
        }
        return input;
    }

    findByRandomMode(categoryNo, subCategoryNo, currentPage = 1) {
        return db.transaction('r', db.choices, db.record, db.random_quiz, async () => {
            let choiceObj = new Choice();
            let recordObj = new QuizRecorder();
            let quizzes, quiz;
            var pages = {};
            var answerNote = jsCookie.get('answerNote');
            var randomNote = jsCookie.get('randomNote');

            quizzes = await db.random_quiz
                .reverse().sortBy('local');
            // this.shuffle(quizzes);

            if (quizzes.length < currentPage){
                return page.redirect(config.subfolder + config.error_page);
            }

            if (quizzes == "undefined") {
                return page.redirect(config.subfolder + config.category_list);
            }

            var cateNo = quizzes[currentPage - 1]['category_no'];
            var subCateNo = quizzes[currentPage - 1]['subcategory_no'];
            var quizNo = quizzes[currentPage - 1]['quiz_no'];
            var choices = await choiceObj.find(categoryNo, subCategoryNo, quizNo);
            var uniqueChoices = $.unique(choices.sort()).sort();

            quiz = quizzes[currentPage - 1];

            if (currentPage - 1 >= 0) {
                pages.pagePrev = currentPage -1;
                pages.prevSubcategory_no = quizzes[currentPage - 1 ]['subcategory_no'];
            }

            if (currentPage == quizzes.length) {
                pages.pagePrev = currentPage - 1;
                pages.prevSubcategory_no = quizzes[currentPage - 1 ]['subcategory_no'];
                pages.quizEnd = 'end';
                pages.pageNext = 'popup-result';

                pages.randomTotalCorrect = parseInt(jsCookie.get('randomTotalCorrect'));
                pages.randomTotalError = parseInt(jsCookie.get('randomTotalError'));
            }
            else {
                if (currentPage > 1) {
                    pages.pagePrev = parseInt(currentPage) -1;
                    pages.prevSubcategory_no = quizzes[currentPage - 1 ]['subcategory_no'];
                }
            }

            if (quizzes.length >= currentPage){
                if (quizzes.length - 1 == currentPage) {
                    pages.pageNext = currentPage + 1;
                    pages.nextSubcategory_no = quizzes[currentPage-1]['subcategory_no'];
                } else {
                    if (quizzes.length == currentPage) {
                        pages.pageNext = currentPage;
                        pages.nextSubcategory_no = quizzes[currentPage-1]['subcategory_no'];
                    } else {
                        pages.pageNext = currentPage + 1 ;
                        pages.nextSubcategory_no = quizzes[currentPage + 1]['subcategory_no'];
                    }
                }
            }

            jsCookie.set('randompage', currentPage, { expires: 1 } )
            pages.pageTotal = quizzes.length;
            pages.currentPage = parseInt(currentPage-1);
            pages.category_no = quizzes[currentPage-1]['category_no'];
            pages.quiz_no = quizzes[currentPage-1]['quiz_no'];

            quiz.pagingQuiz = pages;

            if (answerNote == 'on'){
                quiz.choices = this.shuffle(uniqueChoices);
            }else{
                quiz.choices = uniqueChoices;
            }
            quiz.mode = 'random';
            quiz.random = 'random';

            quiz.record  = await recordObj.getQuizRecord(categoryNo, quiz.quiz_no);
            for (var i = 0; i < quiz.choices.length; i++) {
                quiz.choices[i]['answer'] = quiz.choices[i]['answer'].replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
            }
            quiz.comment = quiz.comment
                .replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
            quiz.sentence = quiz.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');

            return quiz;
        });
    }

    getRandomRangeMode(categoryNo, range) {

        let listQuiz =  this.getQuizRandom(categoryNo, range);
        listQuiz.then(function (value) {
            if (value.length > 0) {
                db.random_quiz.clear();
                db.open();
                db.random_quiz.bulkPut(value)
                    .catch('Data Limit', err => {
                        err.failures.forEach(failure => {
                            alert(config.DATA_LIMIT_DESKTOP.MEG_OVERFLOW_DATA_LIMIT)
                        });
                    });

                return page.redirect(config.subfolder + '/quiz/page/1/random/' + value[0]['category_no'] + '/' + value[0]['subcategory_no'] + '/' + value[0]['quiz_no']);
            } else {
                var mgs = config.MGS_BOOKMARK;
                alert(mgs);
                // return page.redirect(config.subfolder + config.category_list);
            }
        });
    }

    getRandomRangeModeIncorrect(categoryNo, range) {

        let listQuiz =  this.getQuizRandomIncorrect(categoryNo, range);
        listQuiz.then(function (value) {
            if (value.length > 0) {
                db.random_quiz.clear();
                db.open();
                db.random_quiz.bulkPut(value)
                    .catch('Data Limit', err => {
                        err.failures.forEach(failure => {
                            alert(config.DATA_LIMIT_DESKTOP.MEG_OVERFLOW_DATA_LIMIT)
                        });
                    });

                return page.redirect(config.subfolder + '/quiz/page/1/random/' + value[0]['category_no'] + '/' + value[0]['subcategory_no'] + '/' + value[0]['quiz_no']);
            } else {
                var mgs = config.MGS_BOOKMARK;
                alert(mgs);
                // return page.redirect(config.subfolder + config.category_list);
            }
        });
    }

    getSearchList (quizzes) {
        if (quizzes.length > 0) {
            db.open();
            db.random_quiz.clear();
            db.random_quiz.bulkPut(quizzes)
        }
    }

    getFirstRandomQuiz (){
        return db.transaction('r', db.random_quiz, async () => {
            return  db.random_quiz.orderBy('id').first();
        });
    }

    getQuizRandom(categoryNo, range){
        return db.transaction('r', db.category, db.quizzes, async () => {
            var listquiz = [];

            let quizzes = await db.quizzes
                .where('category_no').equals(parseInt(categoryNo))
                .toArray();

            if (quizzes.length > 0) {
                var quiz = this.shuffle(quizzes);
                for(var x = 0; x < range; x++) {

                    quizzes[x].status = 0;
                    quizzes[x].local = x;
                    listquiz[x] = quizzes[x];
                }
                return listquiz

            } else {
                return null;
            }

        });
    }

    getQuizRandomIncorrect(categoryNo, range){
        return db.transaction('r', db.category, db.record, db.quizzes, async () => {
            var listquiz = [];

			console.log("getQuizRandomIncorrect:"+categoryNo);
			
            var rec = new Record();
					let incorrectQuizz = await rec.getIncorrectQuizNumbers(categoryNo);
					console.log("incorrectQuizz:"+incorrectQuizz.join(","));

            let quizzes = await db.quizzes	// 間違いのみ
                .where('quiz_no').anyOf(incorrectQuizz)
                .and((quiz) =>  quiz.category_no == categoryNo)
                .toArray();
                
			console.log("quizzes.length:"+quizzes.length);
            if (quizzes.length > 0) {
                var quiz = this.shuffle(quizzes);
                for(var x = 0; x < range; x++) {

                    quizzes[x].status = 0;
                    quizzes[x].local = x;
                    listquiz[x] = quizzes[x];
                }
                return listquiz;

            } else {
                return null;
            }

        });
    }


    findByIncorrectRandomMode(categoryNo, subCategoryNo, currentPage = 1, isAnswer = false) {
        return db.transaction('rw', db.category, db.quizzes, db.choices, db.record, db.sub_category, db.random_incorrect, async () => {
            var incorrectObj = new Incorrect();
            let quiz = null;

            // get 
            let currentIncorrectRandom = await incorrectObj.getInfoQuizForRandomIncorrect(currentPage);
            let totalIncorrectRandom = await incorrectObj.getTotalQuizForRandomIncorrect();

            if(currentPage == totalIncorrectRandom)
            {
                await incorrectObj.createRandomIncorrect();
                totalIncorrectRandom = await incorrectObj.getTotalQuizForRandomIncorrect();
            }

            if (typeof(currentIncorrectRandom) != "undefined") {
                
                let choiceObj = new Choice();
                quiz = await db.quizzes
                    .where('category_no').equals(currentIncorrectRandom.category_no)
                    .and((quiz) =>  quiz.subcategory_no == currentIncorrectRandom.subcategory_no &&
                                    quiz.quiz_no == currentIncorrectRandom.quiz_no
                                    )
                    .first();

                quiz.comment = quiz.comment
                    .replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
                quiz.sentence = quiz.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');

                let page = [];
                page.pageTotal = totalIncorrectRandom;

                if((currentPage + 1) <= totalIncorrectRandom)
                {
                    let nextIncorrectRandom = await incorrectObj.getInfoQuizForRandomIncorrect(currentPage + 1);
                    if(nextIncorrectRandom)
                    {
                        page.pageNext = currentPage + 1;
                        page.category_no = nextIncorrectRandom.category_no;
                        page.subcategory_no = nextIncorrectRandom.subcategory_no;
                        if(currentPage > 1)
                        {
                            page.pagePrev = currentPage - 1;
                        }
                        else
                        {
                            page.pagePrev = 0;
                        }
                    }
                }
                else
                {
                    let first_page = 1;
                    let nextIncorrectRandom = await incorrectObj.getInfoQuizForRandomIncorrect(first_page);
                    if(nextIncorrectRandom)
                    {
                        page.pageNext = 1;
                        page.category_no = nextIncorrectRandom.category_no;
                        page.subcategory_no = nextIncorrectRandom.subcategory_no;
                        page.pagePrev = 1;
                    }
                }
                 //
                page.currentPage = quiz.quiz_no;
                quiz.pagingQuiz = page;
                quiz.choices = await choiceObj.find(categoryNo, subCategoryNo, quiz.quiz_no);
                for (var i = 0; i < quiz.choices.length; i++) {
                    quiz.choices[i]['answer'] = quiz.choices[i]['answer'].replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
                }
            }
            return quiz;
        });
    }

    findByIncorrectMode(categoryNo, subCategoryNo, currentPage = 1) {
        return db.transaction('r', db.quizzes, db.choices, db.record, db.random_quiz, async () => {

            let choiceObj = new Choice();
            let quizzes = await db.quizzes
                .where('category_no').equals(categoryNo)
                .and((quiz) => quiz.subcategory_no == subCategoryNo)
                .toArray((quizzes) => {
                    return Promise.all(quizzes.map(async (quiz) => {
                        let records = await db.record
                            .where('category_no').equals(categoryNo)
                            .and((record) =>
                                record.quiz_no       == quiz.quiz_no  &&
                                record.content_id    == quiz.content_id  &&
                                record.last_answered == 0             &&
                                record.try_count     >  0
                            ).toArray();

                        if (records.length >=1 )
                            quiz.record = records[0];
                        else
                            quiz.record = records;

                        quiz.records = records;


                        return quiz;
                    }))
                    .then((quizzes) =>
                        quizzes.filter((quiz) => quiz.records.length)
                    );
                });

            if (quizzes.length == 1) {
                currentPage = 1;
            }



            quizzes.sort(function(a,b) {
                return a.quiz_no - b.quiz_no;
            });

            let page = {};

            // it resutl = 0 then error. Please check & validate after set quiz
            let quiz = quizzes[currentPage-1];

            page.pageTotal = quizzes.length;

            if ((currentPage - 1) > 0){
                page.pagePrev = currentPage - 1;
            }

            if (currentPage < quizzes.length){
                page.pageNext = currentPage + 1 ;
            }
            else if (currentPage == quizzes.length)
            {
                page.pageNext = 1 ;
            }
            // 
            page.currentPage = quiz.quiz_no;

            page.category_no = categoryNo;
            page.subcategory_no = subCategoryNo;
            quiz.pagingQuiz = page;
            quiz.choices = await choiceObj.find(categoryNo, subCategoryNo, quiz.quiz_no);
            for (var i = 0; i < quiz.choices.length; i++) {
                quiz.choices[i]['answer'] = quiz.choices[i]['answer'].replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
            }
            quiz.comment = quiz.comment
                .replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
            quiz.sentence = quiz.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');

            return quiz;
        });
    }

    findByIncorrectTopMode(categoryNo, subCategoryNo, quizNo) {
        return db.transaction('r', db.quizzes, db.choices, db.record, async () => {
            let choiceObj = new Choice();
            let quizzes = await db.quizzes
                .where('category_no').equals(categoryNo)
                .and((quiz) => quiz.subcategory_no == subCategoryNo &&
                               quiz.quiz_no == quizNo
                    )
                .toArray((quizzes) => {
                    return Promise.all(quizzes.map(async (quiz) => {
                        let records = await db.record
                            .where('category_no').equals(categoryNo)
                            .and((record) =>
                                record.quiz_no       == quiz.quiz_no  &&
                                record.content_id    == quiz.content_id  &&
                                record.last_answered == 0             &&
                                record.try_count     >  0
                            ).toArray();

                        if (records.length >=1 )
                            quiz.record = records[0];
                        else
                            quiz.record = records;

                        quiz.records = records;


                        return quiz;
                    }))
                    .then((quizzes) =>
                        quizzes.filter((quiz) => quiz.records.length)
                    );
                });

            let page = [];

            // it resutl = 0 then error. Please check & validate after set quiz
            let quiz = quizzes[0];

            quiz.comment = quiz.comment
                .replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
            quiz.sentence = quiz.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');

            page.pageTotal = quizzes.length;
            page.pagePrev = null;
            page.pageNext = null;

            page.category_no = categoryNo;
            page.subcategory_no = subCategoryNo;

             // 
            page.currentPage = quiz.quiz_no;

            quiz.pagingQuiz = page;
            quiz.choices = await choiceObj.find(categoryNo, subCategoryNo, quiz.quiz_no);
            for (var i = 0; i < quiz.choices.length; i++) {
                quiz.choices[i]['answer'] = quiz.choices[i]['answer'].replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
            }
            return quiz;
        });
    }

    findByRedSheetMode(categoryNo, subCategoryNo, currentPage = 1) {
        return db.transaction('r', db.quizzes,  db.choices, db.record, db.random_quiz, async () => {
            var quizzes = [];
            let choiceObj = new Choice();
            let quizz = await db.quizzes
                .where('category_no').equals(categoryNo)
                // .and((quiz) => quiz.subcategory_no == subCategoryNo)
                .sortBy('quiz_no');

            this.shuffle(quizz);
            quizz.forEach(el => {
                var text = el.comment;
                 if (text.indexOf('<font color="red">') != -1) {
                     quizzes.push(el)
                 }
            });

            if (quizzes.length > 0){
                let pages  = {};
                let quiz = [];
                // it resutl = 0 then error. Please check & validate after set quiz
                quiz = quizzes[currentPage-1];

                pages.pageTotal = quizzes.length;

                if ((currentPage - 1) > 0){
                    pages.pagePrev = currentPage - 1;
                    pages.pagePrevQuizNo = quizzes[currentPage - 1].quiz_no ;
                }

                if (currentPage == quizzes.length){
                    pages.quizEnd = 'end';
                }

                if (currentPage <= quizzes.length){
                    if (quizzes.length - 1 == currentPage) {
                        pages.pageNext = currentPage + 1;
                        pages.nextSubcategory_no = quizzes[currentPage-1]['subcategory_no'];
                    } else {
                        if (quizzes.length == currentPage) {
                            pages.pageNext = currentPage;
                            pages.nextSubcategory_no = quizzes[currentPage-1]['subcategory_no'];
                        } else {
                            pages.pageNext = currentPage + 1 ;
                            pages.nextSubcategory_no = quizzes[currentPage + 1]['subcategory_no'];
                        }
                    }
                }

                pages.currentPage = currentPage;
                pages.category_no = categoryNo;
                pages.subcategory_no = quiz.subcategory_no;
                quiz.pagingQuiz = pages;
                quiz.mode = 'red-sheet';

                quiz.comment = quiz.comment
                    .replace(/<font color="red">/g, '<font color="red" style="background-color:red;" onclick="this.style.background=\'white\'">')
                    .replace(/<font color="red" style="background-color:red;" onclick="this.style.background='white'">&#215;<\/font>/g, '<font color="red">&#215;</font>')
                    .replace(/<font color="red" style="background-color:red;" onclick="this.style.background='white'">〇<\/font>/g, '<font color="red">〇</font>');

                quiz.comment = quiz.comment
                    .replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
                quiz.sentence = quiz.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');

                quiz.choices = await choiceObj.find(categoryNo, quiz.subcategory_no, quiz.quiz_no);
                if(quiz.choices.length)
                {
                    for (var i = 0 ; i < quiz.choices.length ; i++) {
                        quiz.choices[i].answer = quiz.choices[i].answer.replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
                    }
                }
                quiz.sheet = 'sheet';

                return quiz;
            } else {
                $('[data-popup="popup-sheet"]').fadeOut(350);
                var mgs = config.MGS_RED_SHEET;
                alert(mgs);
                // return page.redirect(config.subfolder + config.category_list);
            }
        });
    }

    findBySheetBookMode(categoryNo, subCategoryNo, currentPage = 1) {
        return db.transaction('r', db.quizzes,  db.choices, db.record, db.random_quiz, async () => {
            var quizzes = [];
            let choiceObj = new Choice();
            let quizz = await db.quizzes
                .where('category_no').equals(categoryNo)
                .sortBy('quiz_no');

            if(quizz.length > 0){
                this.shuffle(quizz);
            }

            quizz = await Promise.all(quizz.map(async (quiz) => {
                let records = await db.record
                    .where('category_no').equals(categoryNo)
                    .and((record) => {
                        return (
                            record.quiz_no    == quiz.quiz_no     &&
                            record.content_id == quiz.content_id  &&
                            record.selectbox  == true
                        );
                    })
                    .toArray();

                if (records.length >=1 )
                    quiz.record = records[0];
                else
                    quiz.record = records;

                return quiz;
            })).then((quizzes) => quizzes.filter((quiz) => quiz.record.selectbox));

            quizz.forEach(el => {
                var text = el.comment;
                if (text.indexOf('<font color="red">') != -1) {
                    quizzes.push(el)
                }
            });

            if (quizzes.length > 0){
                let pages = {};
                // it resutl = 0 then error. Please check & validate after set quiz
                let quiz = quizzes[currentPage - 1];

                pages.pageTotal = quizzes.length;

                if ((currentPage - 1) > 0){
                    pages.pagePrev = currentPage - 1;
                    pages.pagePrevQuizNo = quizzes[currentPage - 1].quiz_no ;
                }

                if (currentPage == quizzes.length){
                    pages.quizContinue = 'end';
                }

                if (currentPage == 1){
                    pages.quizConPrev = quizzes.length;
                }

                if (currentPage <= quizzes.length){
                    if (quizzes.length - 1 == currentPage) {
                        pages.pageNext = currentPage + 1;
                        pages.nextSubcategory_no = quizzes[currentPage-1]['subcategory_no'];
                    } else {
                        if (quizzes.length == currentPage) {
                            pages.pageNext = currentPage;
                            pages.nextSubcategory_no = quizzes[currentPage-1]['subcategory_no'];
                        } else {
                            pages.pageNext = currentPage + 1 ;
                            pages.nextSubcategory_no = quizzes[currentPage + 1]['subcategory_no'];
                        }
                    }
                }

                pages.currentPage = currentPage;
                pages.category_no = categoryNo;
                pages.subcategory_no = quiz.subcategory_no;
                quiz.pagingQuiz = pages;
                quiz.mode = 'bookmark';

                quiz.comment = quiz.comment
                    .replace(/<font color="red">/g, '<font color="red" style="background-color:red;" onclick="this.style.background=\'white\'">')
                    .replace(/<font color="red" style="background-color:red;" onclick="this.style.background='white'">&#215;<\/font>/g, '<font color="red">&#215;</font>')
                    .replace(/<font color="red" style="background-color:red;" onclick="this.style.background='white'">〇<\/font>/g, '<font color="red">〇</font>')
                ;

                quiz.comment = quiz.comment
                    .replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
                quiz.sentence = quiz.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');

                quiz.choices = await choiceObj.find(categoryNo, quiz.subcategory_no, quiz.quiz_no);
                if(quiz.choices.length)
                {
                    for (var i = 0 ; i < quiz.choices.length ; i++) {
                        quiz.choices[i].answer = quiz.choices[i].answer.replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
                    }
                }
                quiz.sheet = 'sheet';

                return quiz;
            } else {
                $('[data-popup="popup-sheet"]').fadeOut(350);
                var mgs = config.MGS_RED_SHEET;
                alert(mgs)
                // return page.redirect(config.subfolder + config.category_list)
            }
        });
    }

    findByBookmarkMode(categoryNo, subCategoryNo, currentPage = 1) {
        return db.transaction('r', db.quizzes, db.record, db.choices, db.random_quiz, async () => {
            let choiceObj = new Choice();
            let quizzes = [];

            let quizzesBookmark = await db.record
                .where('category_no').equals(categoryNo)
                .and((record) => {
                    return (
                        record.selectbox  == true
                    );
                })
                .sortBy('quiz_no');

            for (i = 0; i < quizzesBookmark.length; i++) {
                let quizz = await db.quizzes
                    .where('category_no').equals(categoryNo)
                    .and((quizz) => {
                        return (
                            quizzesBookmark[i].quiz_no    == quizz.quiz_no     &&
                            quizzesBookmark[i].content_id == quizz.content_id
                        );
                    }).first();

                quizz.record = quizzesBookmark[i];
                quizzes.push(quizz);
            }

            if (quizzes.length > 0) {
                let pages = {};
                // it resutl = 0 then error. Please check & validate after set quiz
                let quiz = quizzes[currentPage-1];

                pages.pageTotal = quizzes.length;

                if ((currentPage - 1) > 0){
                    pages.pagePrev = currentPage - 1;
                } else {
                    pages.pagePrev = quizzes.length;
                }

                if (currentPage < quizzes.length){
                    pages.pageNext = currentPage + 1 ;
                } else {
                    pages.pageNext = 1
                }

                pages.currentPage = currentPage;
                pages.category_no = categoryNo;

                if (subCategoryNo == 0) {
                    quiz.bookmarkall = 'all';
                }
                pages.subcategory_no = quiz.subcategory_no;
                quiz.mode = 'bookmark';
                quiz.pagingQuiz = pages;

                quiz.choices = await choiceObj.find(categoryNo, quiz.subcategory_no, quiz.quiz_no);
                for (var i = 0; i < quiz.choices.length; i++) {
                    quiz.choices[i]['answer'] = quiz.choices[i]['answer'].replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
                }
                quiz.comment = quiz.comment
                    .replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
                quiz.sentence = quiz.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');

                return quiz;
            } else {
                var mgs = config.MGS_BOOKMARK;
                alert(mgs)
            }

        });
    }

    getNotAnsweredYetMode(categoryNo) {
    console.log("getNotAnsweredYetMode start");
        let listQuiz =  this.getNotAnsweredYet(categoryNo);
    console.log("getNotAnsweredYetMode list ok");
        listQuiz.then(function (value) {
            if (value.length > 0) {
    console.log("db.random_quiz.bulkPut start");
                db.random_quiz.clear();
                db.open();
                db.random_quiz.bulkPut(value)
                    .catch('Data Limit', err => {
                        err.failures.forEach(failure => {
                            alert(config.DATA_LIMIT_DESKTOP.MEG_OVERFLOW_DATA_LIMIT)
                        });
                    });
    console.log("db.random_quiz.bulkPut end");
            }
        });
    console.log("getNotAnsweredYetMode end");
    }

    getNotAnsweredYet(categoryNo){
        return db.transaction('r', db.quizzes, db.record, async () => {
        
           /* let quizzes = await db.quizzes
                .toArray();

            quizzes = await Promise.all(quizzes.map(async (quiz) => {
                let records = await db.record
                    .where('category_no').equals(categoryNo)
                    .and((record) => {
                        return record.quiz_no == quiz.quiz_no
                    })
                    .toArray();

                quiz.records = records;

                return quiz;
            })).then((quizzes) =>
                    quizzes.filter((quiz) => !quiz.records.length)
                );
            */
            
            let quizzes;

            let records = await db.record.where('category_no').equals(categoryNo).toArray();
            let recKeys = records.map((obj)=>obj.id);
            //console.log(recKeys);
            quizzes = await db.quizzes.where('category_no').equals(categoryNo)
                        .and((quizzes) => {
                            return recKeys.indexOf(quizzes.id) == -1
                        })
                       .sortBy('quiz_no');
            
            if (quizzes.length > 0) {
                return quizzes
            } else {
                return null;
            }

        });
    }

    findByNotAnsweredYetMode(categoryNo, subCategoryNo, currentPage = 1) {
        return db.transaction('r', db.quizzes, db.record, db.choices, db.random_quiz, async () => {
            let choiceObj = new Choice();
            let quizzes;

            if (currentPage == 1) {

            let records = await db.record.where('category_no').equals(categoryNo).toArray();
            let recKeys = records.map((obj)=>obj.id);
            //console.log(recKeys);
            quizzes = await db.quizzes.where('category_no').equals(categoryNo)
                        .and((quizzes) => {
                            return recKeys.indexOf(quizzes.id) == -1
                        })
                       .sortBy('quiz_no');
                       
            console.log("get quizzes of "+quizzes.length );

             /*   quizzes = await db.quizzes
                    .where('category_no').equals(categoryNo)
                    .sortBy('quiz_no');

                quizzes = await Promise.all(quizzes.map(async (quiz) => {
                    let records = await db.record
                        .where('category_no').equals(categoryNo)
                        .and((record) => {
                            return record.quiz_no == quiz.quiz_no
                        })
                        .toArray();

                    quiz.records = records;

                    return quiz;
                }))
                    .then((quizzes) =>
                        quizzes.filter((quiz) => !quiz.records.length)
                    );*/
            } else {
                quizzes = await db.random_quiz
                    .where('category_no').equals(categoryNo)
                    .sortBy('quiz_no');
            }


            if (quizzes.length > 0 ) {
                // let quiz = quizzes[0];
                let page = {};
                // it resutl = 0 then error. Please check & validate after set quiz
                let quiz = quizzes[currentPage-1];

                page.pageTotal = quizzes.length;

                if ((currentPage - 1) > 0){
                    page.pagePrev = currentPage - 1;
                }

                if (currentPage < quizzes.length){
                    page.pageNext = currentPage + 1 ;
                }

                page.category_no = categoryNo;
                page.subcategory_no = subCategoryNo;
                quiz.pagingQuiz = page;
                quiz.choices = await choiceObj.find(categoryNo, subCategoryNo, quiz.quiz_no);
                for (var i = 0; i < quiz.choices.length; i++) {
                    quiz.choices[i]['answer'] = quiz.choices[i]['answer'].replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
                }

                quiz.comment = quiz.comment
                    .replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
                quiz.sentence = quiz.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').replace(/@DIRECTORY_PATH/g, config.image_path + quiz.content_id + '/insert_images');
console.log("return quiz");
                return quiz;
            } else {
                var mgs = config.MGS_NOT_YET_ANSWER;
                alert(mgs)
            }

        });
    }

    getQuizType(quiz) {
        var quizType;

        if (quiz.comment.indexOf('<MULTI_ANSWER_TAG>') !== -1) {
            quizType = config.QUIZ_TYPE_FILL_EMPTY;
        } else if (quiz.choices.length) {
            let answerNo = quiz.answer_no;
            answerNo = answerNo.split('|');
            quizType = (answerNo.length > 1) ? config.QUIZ_TYPE_MULTI_CHOICES : config.QUIZ_TYPE_ONE_CHOICE;
        } else if (!quiz.choices.length) {
            quizType = config.QUIZ_TYPE_YES_NO;
        }

        return quizType;
    }

    getQuizCorrectChoices(quiz) {
        let answerNo = quiz.answer_no;
        answerNo = answerNo.split('|')
                           .map((answerNo) => answerNo * 1);

        return quiz.choices.filter((choice) =>
            answerNo.indexOf(choice.choice_no) !== -1
        );
    }

     /**
     * get total quiz
     *
     * @param is_client_flg
     * @author  ChienNguyen
     * @updated 2019.01.11
     */

    getTotalQuizz(is_client_flg) {
        return db.transaction('r', db.quizzes, async () => {
            return db.quizzes
                .where('choice_row_count').notEqual(-1)
                .filter((quizze) => {
                    if(is_client_flg){
                        return (
                            quizze.category_no >= 500 
                        );
                    }else
                    {
                        return true;
                    }
                })
                .count();
        });
    }

    getTotallQuizOfSubCategory(categoryNo, subCategoryNo) {
        return db.transaction('r', db.quizzes, async () => {
            return db.quizzes
                .where('category_no').equals(categoryNo)
                .and((quizzes) => {
                    return quizzes.subcategory_no == subCategoryNo
                })
                .count();
        });
    }

    getTotallQuizOfCategory(categoryNo) {
        return db.transaction('r', db.quizzes, async () => {
            return db.quizzes
                .where({'category_no': categoryNo})

                .count();
        });
    }
    getTotallQuizNotYetOfCategory(subcategory) {
        return db.transaction('r', db.quizzes, db.record, async () => {
            return await db.record
                .where('category_no').equals(subcategory.category_no)
                .and((record) => {
                    return record.subcategory_no == subcategory.subcategory_no
                }).count();
        });
    }

    getQuizAllOfSubCategory(categoryNo, subCategoryNo) {
        var recordObj = new Record();
        return db.transaction('r', db.quizzes, db.record, async ()=> {
            let quizzes = await db.quizzes
                .where('category_no').equals(categoryNo)
                .and((quizzes) => {
                    return quizzes.subcategory_no == subCategoryNo
                })
                .sortBy('quiz_no');

            quizzes = await Promise.all(quizzes.map(async (quiz) => {
                let records = await db.record
                    .where('category_no').equals(categoryNo)
                    .and((record) => {
                        return record.quiz_no == quiz.quiz_no
                    }).first();

                if (records) {
                    /*if (parseInt(records.incorrect_count) == 3){
                        quiz.incorrect_count = 2;
                    } else if (parseInt(records.incorrect_count) > 3){
                        quiz.incorrect_count = 3;
                    } else {*/
                        //quiz.try_count =records.try_count;
                        quiz.incorrect_count =records.incorrect_count;
                        quiz.correct_count = records.try_count - records.incorrect_count;
                    //}
                    if(records.selectbox == true){
                        quiz.selectbox = "true";
                    }
                }

                quiz.records = records;
                return quiz;
            }));

            return quizzes;
        });
    }

    getTotallQuizOfContent(contentId) {
        return db.transaction('r', db.quizzes, async () => {
            let quizzes =  await db.quizzes
                .where({'content_id': contentId})
                .toArray();
            var category = [];

            return quizzes

        });
    }

    findContinueQuiz(){
        return db.transaction('r', db.continue_quiz, async () => {
            return db.continue_quiz
                .toArray();
        });
    }

    findBookmarkQuiz(){
        return db.transaction('r', db.record, async () => {
            return db.record
                .toArray();
        });
    }

    startTimer(duration = '' , display = '', status = 'run') {
        var timer = duration, minutes, seconds;
        var myinterval;
        if (status == 'run') {
            myinterval = setInterval(function () {
                minutes = parseInt(timer / 60, 10)
                seconds = parseInt(timer % 60, 10);

                minutes = minutes < 10 ? "0" + minutes : minutes;
                seconds = seconds < 10 ? "0" + seconds : seconds;
                $('.answer').click(function(event) {
                    clearInterval(myinterval)
                });

                if (--timer < 0 ) {
                    clearInterval(myinterval)
                    // timer = duration;
                }
                display.textContent = minutes + ":" + seconds;

            }, 1000);
        } else {
            clearInterval(myinterval);
        }

    }

    getQuizzesSearch(key = '') {
        return db.transaction('r', db.quizzes, db.record, async ()=> {
            let quizzes = await db.quizzes
                .toArray();
            let records = await db.record
                .toArray();

            for(var i = 0; i < records.length; i++){
                 records[i].key = records[i].category_no + "_" + records[i].quiz_no;            
            }
            for(var j = 0; j < quizzes.length; j++){
                var key = quizzes[j].category_no + "_" + quizzes[j].quiz_no;
                let exist_key = records.filter(function(a){ 
                    return a.key == key;
                });

                if(
                    exist_key[0]
                    ){
                    if (parseInt(exist_key[0].incorrect_count) == 3){
                        quizzes[j].incorrect_count = 2;
                    } else if (parseInt(exist_key[0].incorrect_count) > 3){
                        quizzes[j].incorrect_count = 3;
                    } else {
                        quizzes[j].incorrect_count = exist_key[0].incorrect_count;
                    }
                    if(exist_key[0].selectbox == true){
                        quizzes[j].selectbox = "true";
                    }

                    quizzes[j].records = exist_key[0];    
                }
                quizzes[j].subfolder = config.subfolder;

            }
            return quizzes;
        });
    }

	quizzesSearch(keyword = '') {
        return db.transaction('r', db.quizzes, db.record, db.choices, async ()=> {
            // let quizzes = await db.quizzes.filter (function(q){
            //         var patt = new RegExp(keyword);
            //         return patt.test(q.sentence.toUpperCase());
            //     }).toArray();

            let quizzes = await db.quizzes
                .toArray();
            //console.log(quizzes);
            //records
            let records = await db.record
                .toArray();
            for(var i = 0; i < records.length; i++){
                 records[i].key = records[i].category_no + "_" + records[i].quiz_no;            
            }
            //console.log(records);
            //join choises
            let choises = await db.choices.filter (function(c){
                    var patt = new RegExp(keyword);
                    return patt.test(c.answer.replace(/(<([^>]+)>)/ig,"").toUpperCase());
                }).toArray();
            //console.log(choises);
            for(var i = 0; i < choises.length; i++){
                 choises[i].key = choises[i].category_no + "_" + choises[i].subcategory_no + "_" + choises[i].quiz_no;            
            }
            //filter results
            var results = [];
            for(var j = 0; j < quizzes.length; j++){
                var is_result = false;
                var content = quizzes[j].sentence.replace(/(<([^>]+)>)/ig,"");
                //console.log(content);
                //sentence
                if(content.toUpperCase().indexOf(keyword) > -1){
                    //console.log('sentence: ' + content);
                    is_result = true;
                }else{//answer
                    var key_choice = quizzes[j].category_no + "_" + quizzes[j].subcategory_no + "_" + quizzes[j].quiz_no;
                    let exist_key_choice = choises.filter(function(a){ 
                        return a.key == key_choice;
                    });

                    if(exist_key_choice[0]){
                        //console.log('answer: ' + exist_key_choice[0].answer);
                        is_result = true;
                    }
                }

                if(is_result){
                    var key = quizzes[j].category_no + "_" + quizzes[j].quiz_no;
                    let exist_key = records.filter(function(a){ 
                        return a.key == key;
                    });

                    if(
                        exist_key[0]
                        ){
                        if (parseInt(exist_key[0].incorrect_count) == 3){
                            quizzes[j].incorrect_count = 2;
                        } else if (parseInt(exist_key[0].incorrect_count) > 3){
                            quizzes[j].incorrect_count = 3;
                        } else {
                            quizzes[j].incorrect_count = exist_key[0].incorrect_count;
                        }
                        if(exist_key[0].selectbox == true){
                            quizzes[j].selectbox = "true";
                        }

                        quizzes[j].records = exist_key[0];    
                    }
                    quizzes[j].subfolder = config.subfolder;
                    results.push(quizzes[j]);
                }
            }
            //console.log("Total: " + results.length);
            return results;

        });
    }

    // bitone-g add 2019.1.19 -- start --
    getQuizOfPair(category_no, key='') {
        return db.transaction('r', db.quizzes, async () => {
        	var quiz;
        	var category_ofs0;
        	var category_ofs1;
        	if(category_no >= 500){
        		category_ofs0 = parseInt((category_no-500)/20)*20;
        		category_ofs1 = category_ofs0 + 20 -1;
        	} else {
        		category_ofs0 = parseInt((category_no)/20)*20 + 500;
        		category_ofs1 = category_ofs0 + 20 -1;
        	}
            quiz = await db.quizzes
                .where('category_no').between(category_ofs0,category_ofs1)
                    .and((quiz) => {
                        return quiz.sentence.startsWith(key) 
                    }).first();
            return quiz;
        });
    }
    // bitone-g add 2019.1.19 -- end --


}
