import db from './db.js';
import SubCategory from './sub_category.js';
import Quiz from './quiz.js';
import Record from './record.js';
import Contents from "./contents";
import config from "./config";
import Dexie from "dexie";
import {createListQuizIncorrectRandom , returnListBigCategory} from './common';
const page      = require('page');

export default class Incorrect {

	/**
	 * get top quiz incorrect
	 *
	 * 
	 * @return list object quiz 
	 * @author ChienNguyen
	 * @updated 21.12.2018
	 */
	
	getTopQuizIncorrect() {
        return db.transaction('r', db.category, db.quizzes, db.choices, db.record, db.sub_category, async () => {
        	let result_list_quiz = [];
        	// get list category name
        	let nameCates = [];
        	let listCategory = await db.category.toArray();

            let records = await db.record
            		.where('last_answered').equals(0)
            		.and((record) =>
			                record.try_count > 0 &&
			                record.incorrect_count >= 2)
            		.limit(20)
                    .toArray((records) => {
                    	return Promise.all(records.map(async (record) => {
	                        let quizze_info = await db.quizzes
				                .where('category_no').equals(record.category_no)
				                .and((quizzes) => quizzes.quiz_no == record.quiz_no)
				                .first();
				            if(quizze_info)
				            {
				            	let subCategory = await db.sub_category
				                            .where('category_no').equals(quizze_info.category_no)
				                            .and((sub_category) =>
				                                sub_category.subcategory_no       == quizze_info.subcategory_no
				                            ).first();

				                let cate_info = listCategory.filter(function(a){ 
								                	return a.category_no == quizze_info.category_no 
								                });
				                if(cate_info.length){
				                	quizze_info.category_name = cate_info[0].category_name;
				                }
				                if(subCategory){
				                	quizze_info.subcategory_name = subCategory.subcategory_name;
				                }

				                // convert data
				                quizze_info.subfolder = config.subfolder;
				                quizze_info.incorrect_count = record.incorrect_count; 
				                quizze_info.pageCount = 1;
						        quizze_info.sentence = quizze_info.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').substring(0, 20).split('<')[0];
						    
				                // add 
				                result_list_quiz.push(quizze_info);
				            }
	                        }));
                        });
            // sort
            if(result_list_quiz.length)
            {
            	result_list_quiz = result_list_quiz.slice(0);
					result_list_quiz.sort(function(a,b) {
					    return b.incorrect_count - a.incorrect_count;
					});
            }
            return result_list_quiz;
        });
    }

    /**
     * if you want to group this array
     * 
     * @author  ChienNguyen
     */
    
	groupArray(array, key) {
		let rsFinalArray = [];
	  	let finalArray = [];
		array.forEach(function(element) {
		    var newArray = [];
		    
		    array.forEach(function(element1) {
		      	if (element[key] == element1[key]) {
		      		// conver data
		          	newArray.push(element1);
		      	}
		    });
		    if (!(finalArray.some(arrVal => newArray[0][key] == arrVal[0][key]))) {
		        finalArray.push(newArray);
		    }
		});

		if(finalArray.length)
		{
			var tmppageCount = {};

			finalArray.forEach(function(data) {
				var data = data.slice(0);
				data.sort(function(a,b) {
						if(a.category_no != b.category_no)
						{
							return a.category_no - b.category_no;
						}else
						{
							if(a.subcategory_no != b.subcategory_no)
							{
								return a.subcategory_no - b.subcategory_no;
							}
							else
							{
								return a.quiz_no - b.quiz_no;
							}
						}
					    
					});
				var length_data = data.length;
				var set_no_quiz = 1;
				var tmpData = [];
				data.forEach(function(quiz) {
					let key_count = quiz.category_no + "_" + quiz.subcategory_no;
					if(tmppageCount[key_count])
					{
						tmppageCount[key_count]++;
					}
					else
					{
						tmppageCount[key_count] = 1;
					}
					quiz.pageCount = tmppageCount[key_count];
					quiz.no_quiz = set_no_quiz;
					tmpData.push(quiz);
					set_no_quiz++;
				});

				let tmp = {
					'category_notation' : data[0].category_notation,
					'list_quiz' 	: tmpData
				};
				rsFinalArray.push(tmp);
			});
		}
		return rsFinalArray
	}

    /**
	 * get list quiz incorrect sorted by cate
	 *
	 * @param is_client_flg
	 * @return list object quiz 
	 * @author  ChienNguyen
	 * @updated 21.12.2018
	 */
	
	getListQuizIncorrectSortedByCate(is_client_flg) {
        return db.transaction('r', db.category, db.quizzes, db.choices, db.record, db.sub_category, async () => {
        	let result_list_cate_isset_incorrect = [];
        	let result_list_quiz = [];
        	// get list category name
        	var allNameCateNotation = {}; 
        	let listCategory = await db.category
	        	.filter((category) => {
	                    if(is_client_flg){
	                        return (
	                            category.category_no >= 500 
	                        );
	                    }else
	                    {
	                        return true;
	                    }
	                })
	        	.toArray();

        	// all id category
        	let allIdCategory = [];
        	if(listCategory.length)
        	{
        		listCategory.forEach(category => {
	                allIdCategory.push(category.category_no);
	                allNameCateNotation[category.category_no] = category.category_notation;
	            });
        	}

        	// get list record have the last time I gave the wrong answer 
        	
        	var allIdSubCate = []; 
        	var allNameSubCate = {}; 
        	var allIdQuiz = []; 
        	var incorrectCountForQuiz = {}; 

        	var listRecord = await db.record
            		.where('last_answered').equals(0)
            		.and((record) =>
			                record.incorrect_count > 0)
            		.filter((record) => {
	                    if(is_client_flg){
	                    	if (allIdCategory.indexOf(record.category_no) === -1) {
							  	return false;
							}
							else {
							  	return true;
							}
	                    }else
	                    {
	                        return true;
	                    }
	                })
                    .toArray();


            listRecord.forEach(record => {
            	let array_key = [record.category_no, record.subcategory_no, record.quiz_no];
 				let primary_key = array_key.toString();

 				//  create key sub categories
 				let key_sub = [record.category_no, record.subcategory_no];
                key_sub = key_sub.toString();

 				// set
                incorrectCountForQuiz[primary_key] = record.incorrect_count;
                // 
                if (allIdSubCate.indexOf(key_sub) === -1) {
                	allIdSubCate.push(key_sub);
                }
                //
                allIdQuiz.push(primary_key);
            });   

            // get list sub categories
            await db.sub_category
				    .where('id').anyOf(allIdSubCate)
				    .toArray((list_sub) => {
				    	return Promise.all(list_sub.map(async (sub) => {
				    		//  create key sub categories
			 				let key_sub = [sub.category_no, sub.subcategory_no];
			                key_sub = key_sub.toString();
			                allNameSubCate[key_sub] = sub.subcategory_name;
				    	}));
					});

            // get info list quiz
            await db.quizzes
				    .where('id').anyOf(allIdQuiz)
				    .toArray((quizzes) => {
				    	return Promise.all(quizzes.map(async (quiz) => {
				    		let array_key = [quiz.category_no, quiz.subcategory_no, quiz.quiz_no];
 							let primary_key = array_key.toString();

 							let key_sub = [quiz.category_no, quiz.subcategory_no];
			                key_sub = key_sub.toString();
				    		// convert data
				    		quiz.category_notation = allNameCateNotation[quiz.category_no] ? allNameCateNotation[quiz.category_no] : '';
				    		quiz.subcategory_name = allNameSubCate[key_sub] ? allNameSubCate[key_sub] : '';
					        quiz.subfolder = config.subfolder;
					        quiz.incorrect_count = incorrectCountForQuiz[primary_key] ? incorrectCountForQuiz[primary_key] : 0;
							quiz.sentence = quiz.sentence.replace('&lt;MULTI_ANSWER_TAG&gt;', '').substring(0, 15).split('<')[0];
				    		result_list_quiz.push(quiz);
				    	}));
				    });
            // 
            if(result_list_quiz.length)
            {
            	result_list_cate_isset_incorrect = this.groupArray(result_list_quiz, 'category_notation');
            }
            return result_list_cate_isset_incorrect; 
        });
    }


    /**
	 * create random incorrect
	 * get all quiz incorrect then insert into table random_incorrect
	 * 
	 * @return list object quiz 
	 * @author  ChienNguyen
	 * @updated 21.12.2018
	 */
	
	createRandomIncorrect() {
        return db.transaction('rw', db.category, db.quizzes, db.choices, db.record, db.sub_category, db.random_incorrect, async () => {
        	db.random_incorrect.clear();
        	var listQuizIncorrectRandom  = await this.getListQuizIncorrectSortedByCate();
        	if(listQuizIncorrectRandom.length)
        	{
        	    listQuizIncorrectRandom  = createListQuizIncorrectRandom(listQuizIncorrectRandom);
        		db.random_incorrect.bulkPut(listQuizIncorrectRandom).then(function(lastKey) {
	                console.log("Last random_incorrect id was: " + lastKey); 
	            }).catch(Dexie.BulkError, function (e) {
	                console.error ("Some random_incorrect did not succeed. However, " +
	                                           100000-e.failures.length + " random_incorrect was added successfully");
	            });
        	}
        	return true;
        });
    }


    /**
	 * create random incorrect from array
	 * get all quiz incorrect then insert into table random_incorrect
	 * 
	 * @return boolean
	 * @author  ChienNguyen
	 * @updated 21.12.2018
	 */
	
	createRandomIncorrectFromArray(arrayQuizIncorrect) {
        return db.transaction('rw', db.category, db.quizzes, db.choices, db.record, db.sub_category, db.random_incorrect, async () => {
        	db.random_incorrect.clear();
        	if(arrayQuizIncorrect.length)
        	{
        		db.random_incorrect.bulkPut(arrayQuizIncorrect).then(function(lastKey) {
	                console.log("Last random_incorrect id was: " + lastKey); 
	            }).catch(Dexie.BulkError, function (e) {
	                console.error ("Some random_incorrect did not succeed. However, " +
	                                           100000-e.failures.length + " random_incorrect was added successfully");
	            });
        	}
        	return true;
        });
    }

    /**
	 * get total quiz incorrect
	 * 
	 * 
	 * @return count
	 * @author  ChienNguyen
	 * @updated 21.12.2018
	 */
	

    getTotalQuizForRandomIncorrect() {
        return db.transaction('r', db.random_incorrect, () => {
            return db.random_incorrect
                .count();
        });
    }

    /**
	 * get info quiz for id
	 * 
	 * 
	 * @return object info
	 * @author  ChienNguyen
	 * @updated 21.12.2018
	 */
	
    getInfoQuizForRandomIncorrect(id){
        return db.transaction('r', db.random_incorrect, async () => {
            return  db.random_incorrect
            .where('id').equals(id)
            .first();
        });
    }

}
