import Login from "./login";
import config from "./config";
import Mypage from "./mypage";
import SyncData from "./syncData";
import Dexie from "dexie";
import Packaged_sync from "./packaged_sync";
import db from "./db";
const $         = require('jquery');
const clientjs = require('clientjs');
const jsCookie      = require('js-cookie');

export default class ClientJs {

    getInfoDevice () {
        //https://clientjs.org
        var client = new ClientJS(); // Create A New Client Object

        var fingerprint = client.getFingerprint(); // Calculate Device/Browser Fingerprint
        // var device = client.getDevice(); // Calculate Device/Browser device
        // var deviceType = client.getDeviceType(); // Calculate Device/Browser deviceType
        // var deviceVendor = client.getDeviceVendor(); // Calculate Device/Browser deviceVendor
        return fingerprint
    }

    checkInfoDeviceLogin () {
        // Check nextwork is online
        if(navigator.onLine){
            var loginObj = new Login();
            if(loginObj.isLogged()){
                var is_logged = jsCookie.get('id_logged');
                var dataUser = jsCookie.get('user');
                var device_token = this.getInfoDevice();

                if (typeof dataUser != "undefined") {
                    dataUser = JSON.parse(dataUser)
                }

                let learner_id = jsCookie.get('id_logged');

                var dataLogin = window.btoa('{"learner_id":"'+ learner_id +'", "device_token":"'+ device_token +'"}');
                var dataRequest = {'content':dataLogin};
                var checkInfo = false;

                $.ajax({
                    method: "POST",
                    url: config.url_api_device_login,
                    data: dataRequest,
                    dataType: "json",
                    async: false,
                    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                    success: function(data) {
                        // console.log(data)
                        if(data.result == 'NG' || data.status == 1){

                            var myPageObj = new Mypage();
                            var syncDatas = new SyncData();
                            let studyInfo =  myPageObj.getStudyInfo();
                            var save_study = false;

                            studyInfo.then(function(content) {
                                $.ajax({
                                    type: "POST",
                                    url : config.url_api_mypage_report,
                                    data: {'content' : content},
                                    success: function(data){
                                        var confirm = false;
                                        if (data.result == "OK") {
                                            $.ajax({
                                                type: "POST",
                                                url : config.url_api_sync_data_quiz_log,
                                                data: dataRequest,
                                                dataType: "json",
                                                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                                                success: function(response){
                                                    var strDataResponse = window.atob(response.data);
                                                    var result = JSON.parse(strDataResponse);

                                                    // if (result['records'].length > 0) {

                                                    let list_record_on_server = result.data['records'];
                                                    if(list_record_on_server && Array.isArray(list_record_on_server)){
                                                        list_record_on_server.forEach(record =>  {
                                                            let array_key = [record.category_no, record.subcategory_no, record.quiz_no];
                                                            let primary_key = array_key.toString();
                                                            record.id = primary_key;
                                                            //
                                                            if(record.selectbox == 1)
                                                            {
                                                                record.selectbox = true;
                                                            }
                                                            else
                                                            {
                                                                record.selectbox = false;
                                                            }

                                                            record.is_modify = 0;

                                                        });

                                                        db.record.bulkPut(list_record_on_server).then(function(lastKey) {
                                                            console.log("Last record id was: " + lastKey);
                                                        }).catch(Dexie.BulkError, function (e) {
                                                            console.error ("Some record did not succeed. However, " +
                                                                100000-e.failures.length + " raindrops was added successfully");
                                                        });
                                                    }

                                                    // update continue
                                                    let list_continue_quiz_on_server = result.data['continue_logs'];
                                                    if(list_continue_quiz_on_server && Array.isArray(list_continue_quiz_on_server)){
                                                        list_continue_quiz_on_server.forEach(continue_quiz =>  {
                                                            continue_quiz.id = continue_quiz.category_no;
                                                        });
                                                        db.continue_quiz.bulkPut(list_continue_quiz_on_server).then(function(lastKey) {
                                                            console.log("Last related_images id was: " + lastKey);
                                                        }).catch(Dexie.BulkError, function (e) {
                                                            console.error ("Some continue_quiz did not succeed. However, " +
                                                                100000-e.failures.length + " continue_quiz was added successfully");
                                                        });
                                                    }


                                                    // update setting for leaner
                                                    let settings_log = result.data['settings_log'];
                                                    if(settings_log){
                                                        if(settings_log.sound == 'on')
                                                        {
                                                            localStorage.setItem("soundon", true);
                                                        }else
                                                        {
                                                            localStorage.setItem("soundon", false);
                                                        }
                                                    }

                                                    // Update Info Device khi login again.
                                                    $.ajax({
                                                        method: "POST",
                                                        url: config.url_api_update_device_token,
                                                        data: dataRequest,
                                                        dataType: "json",
                                                        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                                                        success: function(data) {
                                                            if(data.result == 'OK'){
                                                                return
                                                            }
                                                        }
                                                    });

                                                    alert(config.MESSAGE_UPDATE_DATE_AGAIN);
                                                },
                                                error: function (xhr, status) {
                                                    console.log('Call Sync result learn quiz error');
                                                }
                                            });
                                        }
                                    },
                                    error: function (xhr, status) {
                                        console.log('Call saveSudyInfo error');
                                        return false;
                                    }
                                });
                            });

                            checkInfo = save_study;
                        }
                    },
                    error: function(xhr, desc, err) {
                        console.log(xhr);
                        console.log("Details0: " + desc + "\nError:" + err);
                    },
                });
            }
        }

    }

}