<?php
class SppOrganization extends AppModel {
	var $name = 'SppOrganization';

	function getOrganizationList($code_large, $code_middle, $code_small){
		$conditions = array();
		$joins = array();
		$joins[]= array(
            'table' => 'spp_payment_methods',
            'alias' => 'SppPaymentMethod',
            'type' => 'left',
            'conditions' => array('SppPaymentMethod.id = SppOrganization.payment_method_id')
		);

		if(!empty($code_large)){
			$conditions['code_large '] = $code_large;
		}
		if(!empty($code_middle)){
			$conditions['code_middle '] = $code_middle;
		}
		if(!empty($code_small)){
			$conditions['code_small '] = $code_small;
		}

		$fields = "SppOrganization.id, code_large, code_middle, code_small, organization_name, certificate,
				   allowed_registration_no, registration_no, days_of_usage, SppPaymentMethod.method_name, organization_date";
		return array(
					'fields' => $fields,
				    'limit' => Configure::read('ORGANIZATION.NUMBER_OF_PAGE'),
					'conditions' => $conditions,
					'joins' => $joins);
	}

	function getAllForCSV(){
		$joins = array();
		$joins[]= array(
            'table' => 'spp_payment_methods',
            'alias' => 'SppPaymentMethod',
            'type' => 'left',
            'conditions' => array('SppPaymentMethod.id = SppOrganization.payment_method_id')
		);

		$fields = "SppOrganization.*, SppPaymentMethod.method_name";
		return $this->find('all',array(
					'fields' => $fields,
					'joins' => $joins));
	}

	function getOrganizationById($organization_id){
		$joins = array();
		$joins[]= array(
            'table' => 'spp_payment_methods',
            'alias' => 'SppPaymentMethod',
            'type' => 'left',
            'conditions' => array('SppPaymentMethod.id = SppOrganization.payment_method_id')
		);
		$fields = "SppOrganization.id, code_large, code_middle, code_small, organization_name, organization_date, registration_no,
				   allowed_registration_no, certificate, days_of_usage, payment_method_id, SppPaymentMethod.method_name";
		return $this->find('first',array(
					'fields' => $fields,
					'conditions' => array('SppOrganization.id' => $organization_id),
					'joins' => $joins));
	}

	function checkCodeExisted($organization_code){
		$organization = $this->find('first',array('conditions'=>
		array('CONCAT(code_large,code_middle,code_small)' => $organization_code)));
		if(!empty($organization)){
			return true;
		}
		return false;
	}

	function getOrgByUserId($user_id){
		$joins = array();
		$joins[]= array(
				'table' => 'spp_user_organizations',
				'alias' => 'SppUserOrganization',
				'type' => 'left',
				'conditions' => array('SppUserOrganization.organization_id = SppOrganization.id')
		);
		$fields = "SppOrganization.id, code_large, code_middle, code_small, organization_name, organization_date, registration_no,
				   allowed_registration_no, certificate, days_of_usage, payment_method_id";
		return $this->find('all',array(
					'fields' => $fields,
					'conditions' => array('SppUserOrganization.user_id' => $user_id),
					'joins' => $joins));
	}

	function getOrgCodeForAchivementUser($user_id){
		$joins = array();
		$joins[]= array(
				'table' => 'spp_user_organizations',
				'alias' => 'SppUserOrganization',
				'type' => 'left',
				'conditions' => array('SppUserOrganization.organization_id = SppOrganization.id')
		);
		$fields = "CONCAT(code_large,code_middle,code_small) AS code, organization_name";
		return $this->find('all',array(
					'fields' => $fields,
					'conditions' => array('SppUserOrganization.user_id' => $user_id),
					'joins' => $joins));
	}
}