<?php
class SppCorrection extends AppModel {
	var $name = "SppCorrection";

	function getCorrectionById($id){
		$joins = array();
		$joins[]= array(
            'table' => 'spp_learners',
            'alias' => 'SppLearner',
            'type' => 'left',
            'conditions' => array('SppLearner.id = SppCorrection.learner_id')
		);
		$fields = "SppCorrection.id, SppCorrection.learner_id, SppCorrection.created_datetime, SppCorrection.correction_person,
				   SppCorrection.correction_datetime, SppCorrection.category_name, SppCorrection.subcategory_name, SppCorrection.quiz_no,
				   SppCorrection.image_submit, SppCorrection.image_answer,SppCorrection.correction_comment,
				   SppCorrection.mark, SppLearner.first_name, SppLearner.last_name";
		return $this->find('first',array(
					'fields' => $fields,
					'conditions' => array('SppCorrection.id' => $id),
					'joins' => $joins));
	}

	function getCorrection($learner_id, $content_id = null, $category_no = null, $subcategory_no = null, $quiz_no = null){
		$conditions = array();
		$conditions['learner_id'] = $learner_id;
		if(!empty($content_id)){
			$conditions['content_id'] = $content_id;
		}
		if(!empty($category_no)){
			$conditions['category_no'] = $category_no;
		}
		if(!empty($subcategory_no)){
			$conditions['subcategory_no'] = $subcategory_no;
		}
		if(!empty($quiz_no)){
			$conditions['quiz_no'] = $quiz_no;
		}
		return $this->find('first',array('conditions' => $conditions));
	}

	function getListCorrection($include_corrected, $created_date_from, $created_date_to, $learner_id, $first_name, $last_name, $org_code){
		$conditions = array();
		$fields = "";
		$joins = array();
		$joins[]= array(
            'table' => 'spp_learners',
            'alias' => 'SppLearner',
            'type' => 'left',
            'conditions' => array('SppLearner.id = SppCorrection.learner_id')
		);

		if(!empty($created_date_from)){
			$conditions['SppCorrection.created_datetime >= '] = $created_date_from->format('Y-m-d H:i:s');
		}
		if(!empty($created_date_to)){
			$conditions['SppCorrection.created_datetime <= '] = $created_date_to->format('Y-m-d H:i:s');
		}
		if(!empty($learner_id)){
			$conditions[] = "SppCorrection.learner_id LIKE '%".$learner_id."%'";
		}
		if(!empty($first_name)){
			$conditions['OR']= array("SppLearner.first_name LIKE '%".$first_name."%'", "SppLearner.first_name_kana LIKE '%".$first_name."%'" );
		}
		if(!empty($last_name)){
			$conditions['OR']= array("SppLearner.last_name LIKE '%".$last_name."%'", "SppLearner.last_name_kana LIKE '%".$last_name."%'" );
		}
		if(!$include_corrected){
			$conditions['SppCorrection.correction_datetime'] = NULL;
		}

		if(!empty($org_code)){
			$conditions[] = "SppCorrection.learner_id in (SELECT spp_learners.id FROM spp_learners WHERE spp_learners.organization_code like '".$org_code."')";
		}

		$fields = "SppCorrection.id, SppCorrection.learner_id, SppCorrection.created_datetime, SppCorrection.correction_person,
				   SppCorrection.correction_datetime, SppCorrection.category_name, SppCorrection.subcategory_name,
				   SppCorrection.quiz_no, SppLearner.first_name, SppLearner.last_name";
		return array(
					'fields' => $fields,
				    'limit' => Configure::read('CORRECTION.NUMBER_OF_PAGE'),
					'conditions' => $conditions,
					'joins' => $joins,
					'order' => array('SppCorrection.created_datetime' =>'desc'));
	}

	function countCorrectionNotAnswer(){
		return $this->find('count',array(
					'conditions' => array('SppCorrection.correction_datetime is NULL')));
	}

	function countCorrectionByLearnerId($learner_id){
		return $this->find('count',array(
					'conditions' => array('SppCorrection.learner_id'=>$learner_id)));
	}
	function getAllForCSV(){
		$fields = "";
		$joins = array();
		$joins[]= array(
            'table' => 'spp_learners',
            'alias' => 'SppLearner',
            'type' => 'left',
            'conditions' => array('SppLearner.id = SppCorrection.learner_id')
		);

		$fields = "SppCorrection.*, SppLearner.first_name, SppLearner.last_name";
		return $this->find('all',array(
					'fields' => $fields,
					'joins' => $joins,
					'order' => array('SppCorrection.created_datetime' =>'desc')));
	}

	public function resizeImage($filename, $max_width, $max_height)
	{
		list($orig_width, $orig_height) = getimagesize($filename);

		$width = $orig_width;
		$height = $orig_height;

		# taller
		if ($height > $max_height) {
			$width = ($max_height / $height) * $width;
			$height = $max_height;
		}

		# wider
		if ($width > $max_width) {
			$height = ($max_width / $width) * $height;
			$width = $max_width;
		}

		$image_p = imagecreatetruecolor($width, $height);

		imagefill($image_p, 0, 0, imagecolorallocate($image_p, 255, 255, 255));
		imagealphablending($image_p, TRUE);

		$image = imagecreatefromjpeg($filename);

		imagecopyresampled($image_p, $image, 0, 0, 0, 0,
		$width, $height, $orig_width, $orig_height);

		imagejpeg($image_p,$filename, 100);
		imagedestroy($image_p);
	}
}