<?php
define("ORGANIZATION_CODE_LARGE", "コード（大）");
define("ORGANIZATION_CODE_MIDDLE", "コード（中");
define("ORGANIZATION_CODE_SMALL", "コード（小）");
define("ORGANIZATION_NAME", "団体名");
define("ALLOWED_REGISTRATION_NO", "登録許可数");
define("REGISTRATION_NO", "登録数");
define("DAYS_OF_USAGE", "利用日数");
define("ORGANIZATION_DATE", "利用期限");
define("CERTIFICATE", "認証有無");
define("PAYMENT_METHOD", "支払区分");
class SppOrganizationController extends AppController
{
	var $name = "SppOrganization";
	var $users = array("SppOrganization","SppPaymentMethod","SppLearner","SppOrganizationContent", "SppLicense", "SppLicenseContent");
	var $components = array('RequestHandler','Session', 'Csv', 'Pass4v');
	var $helpers = array('Html', 'Form');
	var $paginate = array();
	var $Pass4v;
	function beforeFilter()
	{
		parent::beforeFilter();
		$this->Auth->allow('index','edit','add','removecontentselect');
		Configure::load('settings');

		// check session and role
		if(!$this->isSystemManagement()){
			$this->render('/elements/error');
			return;
		}
	}
	function beforeRender() {
		parent::beforeRender();
	}

	function index($code_large="",$code_middle="",$code_small=""){
		//clear session
		$this->deleteTemp();

		if($code_large == "empty"){
			$code_large = "";
		}
		if($code_middle == "empty"){
			$code_middle = "";
		}
		if($code_small == "empty"){
			$code_small = "";
		}
		try{
			
			// delete organization
			if(isset($this->params['url']['delid'])){
				$delid = $this->params['url']['delid'];
				if($delid != ""){
					$del_organization = $this->SppOrganization->findById($delid);
					if(!empty($del_organization)){
						$this->loadModel('SppLearner');
						$learner_belong = $this->SppLearner->find('first',array('conditions' => array('organization_code'=>
						$del_organization['SppOrganization']['code_large'].$del_organization['SppOrganization']['code_middle'].$del_organization['SppOrganization']['code_small'])));
						if(empty($learner_belong)){
							$this->SppOrganization->begin();
							$this->SppOrganization->delete($delid,true);
							$this->loadModel('SppOrganizationContent');
							$this->SppOrganizationContent->deleteAll(array('organization_id' => $delid));
							$this->SppOrganization->commit();
						} else {
							$this->Session->setFlash(Configure::read('Message.ERR_CAN_NOT_DELETED_ORG'));
						}
					}
					$url = '/spporganization/index';
					$code_large = $this->Session->read('code_large');
					$code_middle = $this->Session->read('code_middle');
					$code_small = $this->Session->read('code_small');
					if(!empty($code_large) || !empty($code_middle) || !empty($code_small)){
						if(empty($code_large)){
							$url = $url."/empty";
						} else{
							$url = $url."/".$code_large;
						}
						if(empty($code_middle)){
							$url = $url."/empty";
						} else{
							$url = $url."/".$code_middle;
						}
						if(empty($code_small)){
							$url = $url."/empty";
						} else{
							$url = $url."/".$code_small;
						}
					}
					$this->redirect($url);
				}
			}
			// search with condition
			if ($this->RequestHandler->isPost()){
				$this->Session->delete('Search.searchkey');
				$search_key = array();
				if(!empty($this->data['SppOrganization']['code_large'])){
					$code_large = $this->data['SppOrganization']['code_large'];
					$search_key['SppOrganization']['code_large'] = $code_large;
				}
				if(!empty($this->data['SppOrganization']['code_middle'])){
					$code_middle = $this->data['SppOrganization']['code_middle'];
					$search_key['SppOrganization']['code_middle'] = $code_middle;
				}
				if(!empty($this->data['SppOrganization']['code_small'])){
					$code_small = $this->data['SppOrganization']['code_small'];
					$search_key['SppOrganization']['code_small'] = $code_small;
				}
				$this->Session->write('Search.searchkey', $search_key);
				if(isset($this->data['submit_csv_output'])){
					$this->exportCSV($_POST['encode']);
				}
			} else {
				$search_key = $this->Session->read('Search.searchkey');
				if(!empty($search_key)){
					if(!empty($search_key['SppOrganization']['code_large'])){
						$code_large = $search_key['SppOrganization']['code_large'];
					}
					
					if(!empty($search_key['SppOrganization']['code_middle'])){
						$code_middle = $search_key['SppOrganization']['code_middle'];
					}
					
					if(!empty($search_key['SppOrganization']['code_small'])){
						$code_small = $search_key['SppOrganization']['code_small'];
					}
				}
			}
			$this->paginate = $this->SppOrganization->getOrganizationList($code_large, $code_middle, $code_small);
			$organizations = $this->paginate('SppOrganization', 2);
			$this->set('organizations', $organizations);
			$this->set('code_large', $code_large);
			$this->set('code_middle', $code_middle);
			$this->set('code_small', $code_small);
			$this->Session->write('code_large', $code_large);
			$this->Session->write('code_middle', $code_middle);
			$this->Session->write('code_small', $code_small);
		}catch (Exception $e){
			$this->Session->setFlash($e->getMessage());
			$this->SppOrganization->rollBack();
		}
	}

	function edit(){
		$organization_id;
		$this->loadModel('SppOrganizationContent');
		if(isset($this->params['url']['id'])){
			$organization_id = $this->params['url']['id'];
			$organization = $this->SppOrganization->getOrganizationById($organization_id);
		}
		if (!empty($_GET['new'])) {
			if(!empty($organization_id)){
				$contentids = $this->SppOrganizationContent->getContentIdList($organization_id);
				$this->deleteTemp();
			}
		} else {
			$contentids = $this->Session->read('selectcontent.contentid');
			$data = $this->Session->read('selectcontent.databuffer');
			$this->Session->delete('selectcontent.databuffer');
			//$this->set('data', $data);
		}

		//intalize $contents
		$contents = array();

		if (!empty($contentids)) {
			$contents = $this->getContentByIds($contentids);
			$this->Session->write('selectcontent.contentid', $contentids);
		}
		try{
			if ($this->RequestHandler->isPost()){
				if(!empty($organization)){
					$is_error = false;
					if(empty($this->data['SppOrganization']['organization_name'])){
						$this->Session->setFlash(Configure::read('Message.ERR_MISSING_ORGANIZATION_NAME'));
						$is_error = true;
					}
					if(!$is_error && empty($this->data['SppOrganization']['allowed_registration_no'])){
						$this->Session->setFlash(Configure::read('Message.ERR_MISSING_ALLOWED_REGISTRATION_NO'));
						$is_error = true;
					}

					if(!$is_error && (!is_numeric($this->data['SppOrganization']['allowed_registration_no'])
					|| ($this->data['SppOrganization']['allowed_registration_no'] < 0))){
						$this->Session->setFlash(Configure::read('Message.ERR_ALLOWED_REGISTRATION_NO_INVALID'));
						$is_error = true;
					}

					if($this->data['SppOrganization']['allowed_registration_no'] < $organization['SppOrganization']['registration_no']){
						$this->Session->setFlash(Configure::read('Message.ERR_ALLOWED_REGISTRATION_NO_SMALL'));
						$is_error = true;
					}

					if(!$is_error && (empty($this->data['SppOrganization']['days_of_usage']) && empty($this->data['SppOrganization']['organization_date']))){
						$this->Session->setFlash(Configure::read('Message.ERR_MISSING_DAYS_OF_USAGE'));
						$is_error = true;
					}
					if(!$is_error && (!empty($this->data['SppOrganization']['days_of_usage'])&&!empty($this->data['SppOrganization']['organization_date']))){
						$this->Session->setFlash(Configure::read('Message.ERR_MISSING_DAYS_OF_USAGE'));
						$is_error = true;
					}
					if(!$is_error && (!empty($this->data['SppOrganization']['days_of_usage']) && !is_numeric($this->data['SppOrganization']['days_of_usage'])
					|| (!empty($this->data['SppOrganization']['days_of_usage']) && $this->data['SppOrganization']['days_of_usage'] < 1))){
						$this->Session->setFlash(Configure::read('Message.ERR_DAYS_OF_USAGE_INVALID'));
						$is_error = true;
					}

					$organization['SppOrganization']['organization_name'] = $this->data['SppOrganization']['organization_name'];
					$organization['SppOrganization']['organization_date'] = (!empty($this->data['SppOrganization']['organization_date'])?$this->data['SppOrganization']['organization_date']:"0000-00-00");
					$organization['SppOrganization']['allowed_registration_no'] = $this->data['SppOrganization']['allowed_registration_no'];
					$organization['SppOrganization']['days_of_usage'] = (!empty($this->data['SppOrganization']['days_of_usage'])?$this->data['SppOrganization']['days_of_usage']:"0");
					$organization['SppOrganization']['certificate'] = !$this->data['SppOrganization']['certificate'];
					$organization['SppOrganization']['payment_method_id'] = $this->data['SppOrganization']['payment_method_id'];

		$this->Pass4v->accessLog($this->name, "Warn", "(".__FUNCTION__."),is_error=".$is_error, $referer, $_SERVER['HTTP_USER_AGENT']);
					if(!$is_error){
						$this->SppOrganization->begin();
						if(!$this->SppOrganization->save($organization)){
							$is_error = true;
						}
						$organization['SppOrganization']['organization_date'] = (!empty($this->data['SppOrganization']['organization_date'])?$this->data['SppOrganization']['organization_date']:"");
						if(!$is_error){
							// update organization_content
							$this->SppOrganizationContent->deleteAll(array('organization_id' => $organization['SppOrganization']['id']));
							if(!$this->saveOrganizationContent($contentids,$organization['SppOrganization']['id'])){
								$is_error = true;
							}
						}
						if(!$is_error){
							$this->loadModel('SppLicense');
							$this->loadModel('SppLicenseContent');
							// update license_content
							$organization_code = $organization['SppOrganization']['code_large'].$organization['SppOrganization']['code_middle'].$organization['SppOrganization']['code_small'];
							$licenses = $this->SppLicense->getLicensesByOrganization($organization_code);
							if(!empty($licenses)){
								$license_ids = array();
								foreach ($licenses as $license) {
									array_push($license_ids, $license['SppLicense']['id']);
								}
								$this->SppLicenseContent->deleteAll(array('license_id' => $license_ids));
								if(count($licenses) > 0){
									if(strcmp($organization['SppOrganization']['organization_date'], "0000-00-00") != 0){
										$organization_date = $organization['SppOrganization']['organization_date'];
										$ret = $this->SppLicense->query("UPDATE spp_licenses SET expired_end_date='$organization_date' WHERE learner_id IN (SELECT id FROM spp_learners WHERE organization_code='$organization_code')");
									}
									foreach ($license_ids as $license_id){
										if(!$this->saveLicenseContent($contentids,$license_id)){
											$is_error = true;
											break;
										}
									}
								}
							}
							
						}
						
						if(!$is_error){
							$this->SppOrganization->commit();
								$this->Session->setFlash(Configure::read('Message.EDIT_SUCCESS'));
								return $this->redirect(array('action' => 'index'));
						} else {
							$this->SppOrganization->rollback();
							$this->Session->setFlash(Configure::read('Message.EDIT_ERROR'));
						}
					}
				}
			} else {
				// set value back after select content
				if(!empty($data) && !empty($organization)){
					$organization['SppOrganization']['organization_name'] = $data['SppOrganization']['organization_name'];
					$organization['SppOrganization']['organization_date'] = $data['SppOrganization']['organization_date'];
					$organization['SppOrganization']['allowed_registration_no'] = $data['SppOrganization']['allowed_registration_no'];
					$organization['SppOrganization']['days_of_usage'] = $data['SppOrganization']['days_of_usage'];
					$organization['SppOrganization']['certificate'] = !$data['SppOrganization']['certificate'];
					
					$organization['SppOrganization']['payment_method_id'] = $data['SppOrganization']['payment_method_id'];
				}
			}
					$organization['SppOrganization']['organization_date'] = (!empty($organization['SppOrganization']['organization_date'])&&$organization['SppOrganization']['organization_date']!='0000-00-00')?$organization['SppOrganization']['organization_date']:"";
		} catch(Exception $e){
			$this->SppOrganization->rollback();
			$this->Session->setFlash(Configure::read('Message.ERR_EXCEPTION'));
		}
		if(!empty($organization)){
			$this->set('organization',$organization);
		} else {
			$this->render('/elements/error');
		}

		$this->loadModel('SppPaymentMethod');
		$payment_methods = $this->SppPaymentMethod->find('all');
		$this->set('payment_methods',$payment_methods);
		$this->set('contents', $contents);

	}

	function exportCSV($encode){
		$this->layout = false;
		$organizations = $this->SppOrganization->getAllForCSV();
		$array = array();
		//edit array
		if(!empty($organizations)){
			foreach ($organizations as $organization) {
				$temp = array(
				$organization['SppOrganization']['code_large'],
				$organization['SppOrganization']['code_middle'],
				$organization['SppOrganization']['code_small'],
				$organization['SppOrganization']['organization_name'],
				$organization['SppOrganization']['allowed_registration_no'],
				$organization['SppOrganization']['registration_no'],
				$organization['SppOrganization']['days_of_usage'],
				($organization['SppOrganization']['organization_date']!='0000-00-00')?$organization['SppOrganization']['organization_date']:"",
				$organization['SppOrganization']['certificate'] == 1 ? '有':'無',
				$organization['SppPaymentMethod']['method_name'],
				);
				array_push($array, $temp);
			}
		}
		$header = array(ORGANIZATION_CODE_LARGE, ORGANIZATION_CODE_MIDDLE, ORGANIZATION_CODE_SMALL, ORGANIZATION_NAME, ALLOWED_REGISTRATION_NO, REGISTRATION_NO, DAYS_OF_USAGE,ORGANIZATION_DATE,CERTIFICATE,PAYMENT_METHOD);
		$fileName = '利用コード'.date('Ymdhms');
		$this->Csv->export($encode, $array, $header, $fileName . '.csv');
	}

	function add(){
		$code_large = "";
		$code_middle = "";
		$code_small = "";
		$organization_name = "";
		$organization_date = "";
		$allowed_registration_no = 0;
		$days_of_usage = "";
		$certificate = 1;
		$payment_method_id=Configure::read('PAYMENT_METHOD.COMPANY');
		$data = $this->Session->read('selectcontent.databuffer');
		
		//get string id of content in session stores
		$contentids = $this->Session->read('selectcontent.contentid');

		//intalize $contents
		$contents = array();
		try{
			if ($this->RequestHandler->isPost()){
				$this->SppOrganization->begin();
				$is_error = false;
				if(empty($this->data['SppOrganization']['code_large'])){
					$this->Session->setFlash(Configure::read('Message.ERR_MISSING_CODE_LARGE'));
					$is_error = true;
				}
				if(empty($this->data['SppOrganization']['organization_name'])){
					$this->Session->setFlash(Configure::read('Message.ERR_MISSING_ORGANIZATION_NAME'));
					$is_error = true;
				}
				if(!$is_error && empty($this->data['SppOrganization']['allowed_registration_no'])){
					$this->Session->setFlash(Configure::read('Message.ERR_MISSING_ALLOWED_REGISTRATION_NO'));
					$is_error = true;
				}
				if(!$is_error && (!is_numeric($this->data['SppOrganization']['allowed_registration_no'])
				|| ($this->data['SppOrganization']['allowed_registration_no'] < 0))){
					$this->Session->setFlash(Configure::read('Message.ERR_ALLOWED_REGISTRATION_NO_INVALID'));
					$is_error = true;
				}

					if(!$is_error && (empty($this->data['SppOrganization']['days_of_usage']) && empty($this->data['SppOrganization']['organization_date']))){
						$this->Session->setFlash(Configure::read('Message.ERR_MISSING_DAYS_OF_USAGE'));
						$is_error = true;
					}
					if(!$is_error && (!empty($this->data['SppOrganization']['days_of_usage'])&&!empty($this->data['SppOrganization']['organization_date']))){
						$this->Session->setFlash(Configure::read('Message.ERR_MISSING_DAYS_OF_USAGE'));
						$is_error = true;
					}
					if(!$is_error && (!empty($this->data['SppOrganization']['days_of_usage']) && !is_numeric($this->data['SppOrganization']['days_of_usage'])
					|| (!empty($this->data['SppOrganization']['days_of_usage']) && $this->data['SppOrganization']['days_of_usage'] < 1))){
						$this->Session->setFlash(Configure::read('Message.ERR_DAYS_OF_USAGE_INVALID'));
						$is_error = true;
					}

				$code_large = trim($this->data['SppOrganization']['code_large']);
				$code_middle = trim($this->data['SppOrganization']['code_middle']);
				$code_small = trim($this->data['SppOrganization']['code_small']);
				$organization_name = $this->data['SppOrganization']['organization_name'];
				$allowed_registration_no = $this->data['SppOrganization']['allowed_registration_no'];
				$days_of_usage = (!empty($this->data['SppOrganization']['days_of_usage'])?$this->data['SppOrganization']['days_of_usage']:0);
				$certificate = $this->data['SppOrganization']['certificate'];
				$payment_method_id = $this->data['SppOrganization']['payment_method_id'];
				$organization_date = (!empty($this->data['SppOrganization']['organization_date'])?$this->data['SppOrganization']['organization_date']:"NULL");
				// can not create with orgganization code is 8998
				if($code_large.$code_middle.$code_small == Configure::read('PERSONAL_CODE')){
					$this->Session->setFlash(Configure::read('Message.ERR_ORGANIZATION_CODE_EXISTING'));
					$is_error = true;
				}
				if(!$is_error){
					if($this->SppOrganization->checkCodeExisted($code_large.$code_middle.$code_small)){
						$this->Session->setFlash(Configure::read('Message.ERR_ORGANIZATION_CODE_EXISTING'));
						$is_error = true;
					}
				}
				if(!$is_error){
					$this->SppOrganization->create();
					$this->SppOrganization->set(array(
							'code_large'=>$code_large,
							'code_middle'=>$code_middle,
							'code_small'=>$code_small,
							'organization_name' => $organization_name,
							'allowed_registration_no' =>$allowed_registration_no,
							'registration_no'=> 0,
							'days_of_usage'=>$days_of_usage,
							'certificate' => !$certificate,
							'payment_method_id'=> $payment_method_id,
							'organization_date'=> $organization_date));
					$result = $this->SppOrganization->save();
					if($result){
						$last_org_id = $this->SppOrganization->getLastInsertId();
						if($this->saveOrganizationContent($contentids,$last_org_id)){
							$this->Session->setFlash(Configure::read('Message.ADD_SUCCESS'));
							$this->SppOrganization->commit();
							return $this->redirect(array('action' => 'index'));
						} else {
							$this->SppOrganization->rollback();
							$this->Session->setFlash(Configure::read('Message.ERR_EXCEPTION'));
						}
					} else {
						$this->Session->setFlash(Configure::read('Message.ERR_EXCEPTION'));
					}
				}
					$organization_date = ($organization_date == "NULL")?"":$organization_date;

			} else {
				// set value back after select content
				if(!empty($data)){
					$code_large = trim($data['SppOrganization']['code_large']);
					$code_middle = trim($data['SppOrganization']['code_middle']);
					$code_small = trim($data['SppOrganization']['code_small']);
					$organization_name = $data['SppOrganization']['organization_name'];
					$allowed_registration_no = $data['SppOrganization']['allowed_registration_no'];
					$days_of_usage = $data['SppOrganization']['days_of_usage'];
					$certificate = !$data['SppOrganization']['certificate'];
					$payment_method_id = $data['SppOrganization']['payment_method_id'];
					$organization_date = (!empty($data['SppOrganization']['organization_date'])?$data['SppOrganization']['organization_date']:"");
				}
			}
		} catch (Exception $e){
			$this->SppOrganization->rollback();
			//$this->Session->setFlash(Configure::read('Message.ERR_EXCEPTION'));
			//				var_dump("Exception case 3");exit;
			$this->Session->setFlash($e->getMessage());
		}
		$this->loadModel('SppPaymentMethod');
		$payment_methods = $this->SppPaymentMethod->find('all');
		$this->set('payment_methods',$payment_methods);
		if (!empty($contentids)) {
			//get contents listing by $contentid
			$contents = $this->getContentByIds($contentids);

		}
		$this->set('contents', $contents);
		$this->set('data', $data);
		$this->set('code_large', $code_large);
		$this->set('code_middle', $code_middle);
		$this->set('code_small', $code_small);
		$this->set('organization_name', $organization_name);
		$this->set('allowed_registration_no', $allowed_registration_no);
		$this->set('days_of_usage', $days_of_usage);
		$this->set('certificate', $certificate);
		$this->set('payment_method_id', $payment_method_id);
		$this->set('organization_date', $organization_date);
	}

	/**
	 * Get content by ids
	 * input string $ids | ex: 1,4,5,12,3,6
	 * output array
	 */
	function getContentByIds($ids = '')
	{
		$this->loadModel('SppContent');
		$this->loadModel('SppUser');
		$contents = $this->SppContent->find('all', array(
            'conditions' => array('SppContent.id IN (' . $ids . ')'),
            'order' => array('SppContent.content_code ASC'),
            'recursive' => -1
		));
		foreach ($contents as $k => $d) {

			$user = $this->SppUser->findById($d['SppContent']['user_id']);
			$contents[$k]['SppUser']['user_name'] = $user['SppUser']['user_name'];
			$typeContent = ($d['SppContent']['content_type'] == 1) ? 'set' : 'item';
			$file_update_time = $this->getContentFileByContentID($d['SppContent']['id'], $typeContent);
			$contents[$k]['SppContent']['update_time_file'] = empty($file_update_time[0][0]['update_file_time']) ? '' : $file_update_time[0][0]['update_file_time'];
		}

		return $contents;
	}

	/**
	 * Get content by id listing
	 * input int | $id
	 * output string | maximum update_datetime
	 */
	function getContentFileByContentID($id = 0, $type = 'set')
	{
		if ($type == 'set')
		$ids = $this->getContentItem($id);
		else
		$ids = $id;
		if (!empty($ids)) {
			$this->loadModel('SppContentFile');
			$update_file_time = $this->SppContentFile->find('all', array(
                'conditions' => array('SppContentFile.content_id in (' . $ids . ')'),
                'fields' => array('max(SppContentFile.updated_datetime) as update_file_time')
			));
			//$contents=$this->query('select max(updated_datetime) as update_file_time from spp_content_files  where id  = '.$id);
		} else {
			$file_update_time = array();
			@$file_update_time[0][0]['update_file_time'] = '';
			//$update_file_time='';
		}
		return @$update_file_time;
	}
	
/**
	 * Get listing contentid by content set id
	 * input int $contentid| string|$type return listing id with type string if type is string else return array
	 * output array|string
	 */
	function getContentItem($contentid = 0, $type = 'string')
	{
		$this->loadModel('SppContentItem');
		$content_license = $this->SppContentItem->find('all', array(
            'conditions' => array('SppContentItem.content_id' => $contentid),
            'recursive' => -1,
		));
		$content_license_id = array();
		foreach ($content_license as $cl) {
			$content_license_id[] = $cl['SppContentItem']['child_content_id'];
		}

		if ($type == 'string') {
			$content_license_ids = implode(',', $content_license_id);
		} else {
			$content_license_ids = $content_license_id;
		}

		return $content_license_ids;
	}

	/**
	 * remove content from select list content
	 * input
	 * output
	 */
	function removecontentselect($id = 0)
	{
		if (isset($_POST['controller'])) {

			if (!empty($_POST['id'])) {
				$url = array('controller' => $_POST['controller'], 'action' => $_POST['action'], '?' => array('id' => $_POST['id']));
			} else {
				$url = array('controller' => $_POST['controller'], 'action' => $_POST['action']);
			}
			$this->Session->delete('selectcontent.url');
			$this->Session->write('selectcontent.url', $url);

			$this->Session->delete('selectcontent.databuffer');
			$this->Session->write('selectcontent.databuffer', $this->data);
			$contentid = $this->Session->read('selectcontent.contentid');
			if (!empty($contentid)) {
				$contentid = explode(',', $contentid);
				foreach ($contentid as $key => $con) {
					if ($con == $id) {
						unset($contentid[$key]);
					}
				}
				$contentid = implode(',', $contentid);
				$this->Session->delete('selectcontent.contentid');
				$this->Session->write('selectcontent.contentid', $contentid);
			}

		} else {
			$url = Dispatcher::baseUrl();
		}
		$this->redirect($url);

	}

	/**
	 * Empty session store
	 * input
	 * output
	 */
	function deleteTemp()
	{
		$this->Session->delete('selectcontent.url');
		$this->Session->delete('selectcontent.databuffer');
		$this->Session->delete('selectcontent.contentid');
	}

	function saveOrganizationContent($contentids, $organization_id){
		$this->loadModel('SppOrganizationContent');
		if (!empty($contentids)) {
			$contentids = explode(',', $contentids);
			if (count($contentids)) {
				foreach ($contentids as $coid) {
					if (!empty($coid)) {
						$this->SppOrganizationContent->create();
						$this->SppOrganizationContent->set(array(
										'organization_id' => $organization_id,
										'content_id'=>$coid));
						//add to table spp_organization_content
						if(!$this->SppOrganizationContent->save()){
							return false;
						}
					}
				}
			}
		}
		return true;
	}
	
	function saveLicenseContent($contentids, $license_id){
		if (!empty($contentids)) {
			$contentids = explode(',', $contentids);
			if (count($contentids)) {
				foreach ($contentids as $coid) {
					if (!empty($coid)) {
						$this->SppLicenseContent->create();
						$this->SppLicenseContent->set(array(
										'license_id' => $license_id,
										'content_id'=>$coid));
						//add to table spp_license_content
						if(!$this->SppLicenseContent->save()){
							return false;
						}
					}
				}
			}
		}
		return true;
	}
}