<?php // $Id$
/**
 * @copyright     2011 (c) SEVENSEAS TECHWORKS Co., Ltd. All Rights Reserved.
 * @package       skrskscs
 * @since         2011-02-22
 * We use CakePHP(tm) ver 1.3.7
 */
define("CREATED_DATETIME", "発行日");
define("LICENSE_CODE", "ライセンスID");
define("CREATOR_NAME", "発行者");
define("LICENSE_DESC", "名前");
define("LEARNER_ID", "学習者ＩＤ");
define("CLIENT_USED_DATE", "利用開始日");
define("EXPIRED_END_DATE", "有効期限");

class  SppLicenseController extends AppController
{
	var $name = 'SppLicense';
	var $helpers = array('Form', 'Dialog');
	var $uses = array("SppLicense", "SppLearningLog", "SppUser");
	var $components = array('Auth', 'Session', 'Csv', 'Pass4v');
	var $paginate = array(
	// 'limit' => 10,
        'order' => array(
            'SppLicense.created_datetime' => 'asc',
            'SppLicense.license_desc' => 'asc'));
	// role of user.
	var $role_user = array();
	private $aryFieldHeaders = array('created_datetime', 'license_code', 'creator_name', 'license_desc', 'learner_id', 'client_used_date', 'expired_end_date');
	//function alow not login
	function beforeFilter()
	{
		parent::beforeFilter();
		$this->Auth->allow('add', 'index', 'edit', 'login', 'removecontentselect', 'submitedit',
            'submitadd', 'dialogconfirm', 'delete', 'clearidentifier', 'csvExport', 'csvImport');
		// check session and role
		if(!$this->isSystemManagement()){
			$this->render('/elements/error');
			return;
		}
		
		// Load config file
		Configure::load('settings');
	}

	/**
	 * Get list license and set to layout
	 * input
	 * output :    license
	 */
	function index()
	{
		$this->Session->write('system.flag', 0);
		$this->Session->write('system.flag_filter', 0);

		//add url current to session store
		$this->Session->delete('license.url');
		$urlCurrent = $this->params['url']['url'];
		$this->Session->write('license.url', $urlCurrent);

		// trunglc - add - 28-10-2013

		$user = $this->Auth->user();
		if ($user['SppUser']['user_name'] == Configure::read('User.SYSADMIN')) {
			$visible = true;
			$this->set('visible', $visible);
		}

		// trunglc - end

		//$data = $this->getData();
		// update yamamoto
		if($user['SppUser']['user_name']== 'sysadmin'){
			$data = $this->getData();
		} else {
			// $data = $this->getData();

			$data = $this->getDataLimited($user['SppUser']['id']);
		}


		$this->set('role_user', $this->role_user);
		$this->set(compact('data'));

	}

	// add yamamoto
	/**
	 * getDataLimited
	 *
	 * @author yamamoto
	 */

	private function getDataLimited($id=0){

		//get keyword in session store
		$searchkey = $this->Session->read('Search.searchkey');

		if (isset($_POST['keyword'])) {

			$this->Session->delete('Search.searchkey');
			$this->Session->write('Search.searchkey', $_POST['keyword']);

			$searchkey = $this->Session->read('Search.searchkey');
		}

		$keyword = empty($searchkey) ? '' : $searchkey;

		// Huyen edit start
		$keyuser = isset($_POST['keyuser']);

		$this->Session->write('Search.keyuser', $keyuser);

		//*************Added by Tuanm**************//
		$tmp = $this->Auth->user();
		$webadmin = 0;
		if ($tmp['SppUser']['user_name'] == Configure::read('User.WEBADMIN')) {
			$keyuser = 1;
			$webadmin = 1;
			$filter_creator_ids = array($tmp['SppUser']['id'], Configure::read('CLIENT_ADMIN'));
		}

		if ($webadmin == 0) {
			$this->SppUser->unbindModel(array('hasAndBelongsToMany' => array('SppRole')));
			$user_id = $this->SppUser->find('first', array('conditions' => array('SppUser.user_name' => Configure::read('User.WEBADMIN')),
                'fields' => array('SppUser.id')));
			$filter_creator_ids = array($user_id['SppUser']['id'], Configure::read('CLIENT_ADMIN'));
		}

		//*****************************************//


		if ($keyuser == 1) {
			$this->Session->write('system.flag_filter', 1);
		}
		if (!empty($keyword)) {
			if ($keyuser == 1) {
				/**********************************Added by Tuannm on 2013/02/19************************************/
				if ($webadmin == 1) {
					$this->paginate = array(
                        'limit' => Configure::read('LICENSE.NUMBER_OF_PAGE'),
                        'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
                        'conditions' => array(
                            'SppLicense.learner_id <>' => ' NULL ',
					//'SppLicense.creator_id' => $filter_creator_ids,
                            'SppLicense.creator_id'=>$id, // change by yamamoto

                            'OR' => array(
                                'SppLicense.license_code LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                                'SppLicense.license_desc LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                                'SppLicense.learner_id LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                                'SppLicense.comment LIKE' => "%" . mysql_real_escape_string($keyword) . "%")),
                        'joins' => array(
					array('type' => 'LEFT', 'alias' => 'users', 'table' => 'spp_users',
                                'conditions' => 'SppLicense.creator_id = users.id')),
					);
					/*************************************************END***********************************************/
				} else {
					$this->paginate = array(
                        'limit' => Configure::read('LICENSE.NUMBER_OF_PAGE'),
                        'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
                        'conditions' => array(
                            'SppLicense.learner_id <>' => ' NULL ',
					//Added by Tuannm on 2013/04/16 for #20685
					//'NOT' => array('SppLicense.creator_id' => $filter_creator_ids),
                            'SppLicense.creator_id' => $id, // changed by yamamoto
					//End
                            'OR' => array(
                                'SppLicense.license_code LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                                'SppLicense.license_desc LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                                'SppLicense.learner_id LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                                'SppLicense.comment LIKE' => "%" . mysql_real_escape_string($keyword) . "%")),
                        'joins' => array(
					array('type' => 'LEFT', 'alias' => 'users', 'table' => 'spp_users',
                                'conditions' => 'SppLicense.creator_id = users.id')),
					);
				}
			} else {
				$this->paginate = array(
                    'limit' => Configure::read('LICENSE.NUMBER_OF_PAGE'),
                    'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
                    'conditions' => array(
				//Added by Tuannm on 2013/04/16 for #20685
				//'NOT' => array('SppLicense.creator_id' => $filter_creator_ids),
                        'SppLicense.creator_id' => $id, // changed by yamamoto
				//End
                        'OR' => array(
                            'SppLicense.license_code LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.learner_id LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.license_desc LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.comment LIKE' => "%" . mysql_real_escape_string($keyword) . "%")),
                    'joins' => array(
				array('type' => 'LEFT', 'alias' => 'users', 'table' => 'spp_users',
                            'conditions' => 'SppLicense.creator_id = users.id')),
				);
			}
		} else {
			if ($keyuser == 1) {
				/**********************************Added by Tuannm on 2013/02/19************************************/
				if ($webadmin == 1) {
					$this->paginate = array(
                        'limit' => Configure::read('LICENSE.NUMBER_OF_PAGE'),
                        'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
                        'conditions' => array(
                            'SppLicense.learner_id <>' => ' NULL ',
					//Added by Tuannm on 2013/04/16 for #20685
					//'SppLicense.creator_id' => $filter_creator_ids,
                            'SppLicense.creator_id'=>$id, // changed by yamamoto
					//End
					),
                        'joins' => array(
					array('type' => 'LEFT', 'alias' => 'users', 'table' => 'spp_users',
                                'conditions' => 'SppLicense.creator_id = users.id')),
					);
					/***********************************************END************************************************/
				} else {
					$this->paginate = array(
                        'limit' => Configure::read('LICENSE.NUMBER_OF_PAGE'),
                        'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
                        'conditions' => array(
                            'SppLicense.learner_id <>' => ' NULL ',
					//Added by Tuannm on 2013/04/16 for #20685
					//'NOT' => array('SppLicense.creator_id' => $filter_creator_ids),
                            'SppLicense.creator_id' => $id, // changed by yamamoto
					//End
					),
                        'joins' => array(
					array('type' => 'LEFT', 'alias' => 'users', 'table' => 'spp_users',
                                'conditions' => 'SppLicense.creator_id = users.id')),
					);
				}
			} else {
				$this->paginate = array(
                    'limit' => Configure::read('LICENSE.NUMBER_OF_PAGE'),
                    'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
				//Added by Tuannm on 2013/04/16 for #20685
				//'conditions' => array('NOT' => array('SppLicense.creator_id' => $filter_creator_ids)),
                    'conditions' => array('SppLicense.creator_id' => $id,), // changed by ywmwmoto
				//End
				);
			}
		}
		$this->set('keyword', $keyword);
		$this->set('keyuser', $keyuser);
		$data = $this->paginate('SppLicense', 2);
		$this->loadModel('SppUser');
		foreach ($data as $key => $d) {
			$this->SppUser->id = $d['SppLicense']['creator_id'];
			$userItem = $this->SppUser->read();
			$data[$key]['SppLicense']['creator_name'] = $userItem['SppUser']['user_name'];
		}

		return $data;
	}

	/**
	 * getData
	 *
	 * @author haitlt
	 */
	private function getData()
	{

		//get keyword in session store
		$searchkey = $this->Session->read('Search.searchkey');

		if (isset($_POST['keyword'])) {

			$this->Session->delete('Search.searchkey');
			$this->Session->write('Search.searchkey', $_POST['keyword']);

			$searchkey = $this->Session->read('Search.searchkey');
		}

		$keyword = empty($searchkey) ? '' : $searchkey;

		// Huyen edit start
		$keyuser = isset($_POST['keyuser']);

		$this->Session->write('Search.keyuser', $keyuser);

		//*************Added by Tuanm**************//
		$tmp = $this->Auth->user();
		$webadmin = 0;
		if ($tmp['SppUser']['user_name'] == Configure::read('User.WEBADMIN')) {
			$keyuser = 1;
			$webadmin = 1;
			$filter_creator_ids = array($tmp['SppUser']['id'], /*Configure::read('CLIENT_ADMIN')*/);
		}

		if ($webadmin == 0) {
			$this->SppUser->unbindModel(array('hasAndBelongsToMany' => array('SppRole')));
			$user_id = $this->SppUser->find('first', array('conditions' => array('SppUser.user_name' => Configure::read('User.WEBADMIN')),
                'fields' => array('SppUser.id')));
			$filter_creator_ids = array(Configure::read('CLIENT_ADMIN'));
			$filter_creator_ids = array(($user_id)?$user_id['SppUser']['id']:Configure::read('CLIENT_ADMIN'));
		}
		//print_r($filter_creator_ids);
		//*****************************************//

		if ($keyuser == 1) {
			$this->Session->write('system.flag_filter', 1);
		}
		if (!empty($keyword)) {
			if ($keyuser == 1) {
				/**********************************Added by Tuannm on 2013/02/19************************************/
				if ($webadmin == 1) {
					$this->paginate = array(
                        'limit' => Configure::read('LICENSE.NUMBER_OF_PAGE'),
                        'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
                        'conditions' => array(
                            'SppLicense.learner_id <>' => ' NULL ',
                            'SppLicense.creator_id' => $filter_creator_ids,
                            'OR' => array(
                                'SppLicense.license_code LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                                'SppLicense.license_desc LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                                'SppLicense.learner_id LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                                'SppLicense.comment LIKE' => "%" . mysql_real_escape_string($keyword) . "%")),
                        'joins' => array(
					array('type' => 'LEFT', 'alias' => 'users', 'table' => 'spp_users',
                                'conditions' => 'SppLicense.creator_id = users.id')),
					);
					/*************************************************END***********************************************/
				} else {
					$this->paginate = array(
                        'limit' => Configure::read('LICENSE.NUMBER_OF_PAGE'),
                        'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
                        'conditions' => array(
                            'SppLicense.learner_id <>' => ' NULL ',
					//Added by Tuannm on 2013/04/16 for #20685
                            'NOT' => array('SppLicense.creator_id' => $filter_creator_ids),
					//End
                            'OR' => array(
                                'SppLicense.license_code LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                                'SppLicense.license_desc LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                                'SppLicense.learner_id LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                                'SppLicense.comment LIKE' => "%" . mysql_real_escape_string($keyword) . "%")),
                        'joins' => array(
					array('type' => 'LEFT', 'alias' => 'users', 'table' => 'spp_users',
                                'conditions' => 'SppLicense.creator_id = users.id')),
					);
				}
			} else {
				$this->paginate = array(
                    'limit' => Configure::read('LICENSE.NUMBER_OF_PAGE'),
                    'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
                    'conditions' => array(
				//Added by Tuannm on 2013/04/16 for #20685
                        'NOT' => array('SppLicense.creator_id' => $filter_creator_ids),
				//End
                        'OR' => array(
                            'SppLicense.license_code LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.learner_id LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.license_desc LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.comment LIKE' => "%" . mysql_real_escape_string($keyword) . "%")),
                    'joins' => array(
				array('type' => 'LEFT', 'alias' => 'users', 'table' => 'spp_users',
                            'conditions' => 'SppLicense.creator_id = users.id')),
				);
			}
		} else {
			if ($keyuser == 1) {
				/**********************************Added by Tuannm on 2013/02/19************************************/
				if ($webadmin == 1) {
					$this->paginate = array(
                        'limit' => Configure::read('LICENSE.NUMBER_OF_PAGE'),
                        'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
                        'conditions' => array(
                            'SppLicense.learner_id <>' => ' NULL ',
					//Added by Tuannm on 2013/04/16 for #20685
                            'SppLicense.creator_id' => $filter_creator_ids,
					//End
					),
                        'joins' => array(
					array('type' => 'LEFT', 'alias' => 'users', 'table' => 'spp_users',
                                'conditions' => 'SppLicense.creator_id = users.id')),
					);
					/***********************************************END************************************************/
				} else {
					$this->paginate = array(
                        'limit' => Configure::read('LICENSE.NUMBER_OF_PAGE'),
                        'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
                        'conditions' => array(
                            'SppLicense.learner_id <>' => ' NULL ',
					//Added by Tuannm on 2013/04/16 for #20685
                            'NOT' => array('SppLicense.creator_id' => $filter_creator_ids),
					//End
					),
                        'joins' => array(
					array('type' => 'LEFT', 'alias' => 'users', 'table' => 'spp_users',
                                'conditions' => 'SppLicense.creator_id = users.id')),
					);
				}
			} else {
				$this->paginate = array(
                    'limit' => Configure::read('LICENSE.NUMBER_OF_PAGE'),
                    'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
				//Added by Tuannm on 2013/04/16 for #20685
                    'conditions' => array('NOT' => array('SppLicense.creator_id' => $filter_creator_ids)),
				//End
				);
			}
		}

		$this->set('keyword', $keyword);
		$this->set('keyuser', $keyuser);
		$data = $this->paginate('SppLicense', 2);
		$this->loadModel('SppUser');
		foreach ($data as $key => $d) {
			$this->SppUser->id = $d['SppLicense']['creator_id'];
			$userItem = $this->SppUser->read();
			$data[$key]['SppLicense']['creator_name'] = $userItem['SppUser']['user_name'];
		}

		return $data;
	}

	/**
	 * Show form add license
	 * input
	 * output
	 */
	function add()
	{
		//empty tem in session store if the first to page
		if (!empty($_GET['new'])) {
			$this->deleteTemp();
		}

		$data = $this->Session->read('selectcontent.databuffer');
		//get string id of content in session stores
		$contentids = $this->Session->read('selectcontent.contentid');

		//intalize $contents
		$contents = array();

		// trunglc add - 28/10/2013

		$disabled = '';

		$user = $this->Auth->user();
		if (!empty($user)) {
			$this->set('userid', $user['SppUser']['id']);
			$this->set('username', $user['SppUser']['user_name']);
			if ($user['SppUser']['user_name'] != Configure::read('User.SYSADMIN')) {
				$disabled = 'disabled';
			}
		}
		$this->set('disabled', $disabled);
		$users = array();

		if ($user['SppUser']['user_name'] != Configure::read('User.WEBADMIN')) {
			$users = $this->SppUser->find('list', array('conditions' => array('SppUser.user_name != ' => Configure::read('User.WEBADMIN')), 'fields' => array('SppUser.user_name')));
		} else{
			$users = $this->SppUser->find('list', array('fields' => array('SppUser.user_name')));
		}
		$this->set('users', $users);

		// end trunglc add

		if (!empty($contentids)) {
			//get contents listing by $contentid
			$contents = $this->getContentByIds($contentids);

		}
		$license_url = $this->Session->read('license.url');
		$this->set('license_url', '/' . $license_url);
		$this->set('contents', $contents);
		$this->set('data', $data);

	}


	/**
	 * remove content from select list content
	 * input
	 * output
	 */
	function removecontentselect($id = 0)
	{
		if (isset($_POST['controller'])) {

			if (!empty($_POST['id'])) {
				$url = array('controller' => $_POST['controller'], 'action' => $_POST['action'], '?' => array('id' => $_POST['id']));
			} else {
				$url = array('controller' => $_POST['controller'], 'action' => $_POST['action'], '?' => array('edittype' => 2));
			}
			$this->Session->delete('selectcontent.url');
			$this->Session->write('selectcontent.url', $url);

			$this->Session->delete('selectcontent.databuffer');
			$this->Session->write('selectcontent.databuffer', $this->data);
			$contentid = $this->Session->read('selectcontent.contentid');
			if (!empty($contentid)) {
				$contentid = explode(',', $contentid);
				foreach ($contentid as $key => $con) {
					if ($con == $id) {
						unset($contentid[$key]);
					}
				}
				$contentid = implode(',', $contentid);
				$this->Session->delete('selectcontent.contentid');
				$this->Session->write('selectcontent.contentid', $contentid);
			}

		} else {
			$url = Dispatcher::baseUrl();
		}
		$this->Session->write('system.flag', 1);
		$this->Session->write('system.version_update_flag', 1);
		$this->redirect($url);

	}

	/**
	 * Show form edit license
	 * input
	 * output
	 */
	function edit()
	{
		// trunglc add - 28/10/2013
		$disabled = '';
		$user = $this->Auth->user();
		if (!empty($user)) {
			$this->set('userid', $user['SppUser']['id']);
			$this->set('username', $user['SppUser']['user_name']);
			if ($user['SppUser']['user_name'] != Configure::read('User.SYSADMIN')) {
				$disabled = 'disabled';
			}
		}
		$this->set('disabled', $disabled);

		if ($user['SppUser']['user_name'] != Configure::read('User.WEBADMIN')) {
			$users = $this->SppUser->find('list', array('conditions' => array('SppUser.user_name != ' => Configure::read('User.WEBADMIN')), 'fields' => array('SppUser.user_name')));
		} else{
			$users = $this->SppUser->find('list', array('fields' => array('SppUser.user_name')));
		}

		//        debug($user['SppUser']['id']);
		//        debug($users);die;
		//        debug($users);die;

		$this->set('users', $users);

		// end trunglc add
		$edittype = 1;
		if (!empty($_GET['edittype'])) {
			$edittype = (int)($_GET['edittype']);
		}
		$this->set('edittype', $edittype);
		$this->Session->write('Edit.edittype', $edittype);

		if ($edittype != 2) {

			$this->SppLicense->id = (int)$_GET['id'];
			//get license item
			$license = $this->SppLicense->read();

			//Added by Tuannm on 2013/04/16 for #20685
			//if ($license['SppLicense']['creator_id'] == Configure::read('CLIENT_ADMIN')) {
			//    $this->render('/elements/error');
			//}
			//End

			if (!empty($_GET['new'])) {
				$contentids = $this->getContentByLicenseCode($this->SppLicense->id);
				//$contentids=$this->SppLicense->getContentLicense($this->SppLicense->id);
				//empty temp in session store
				$this->deleteTemp();
			} else {
				$contentids = $this->Session->read('selectcontent.contentid');
				$databuffer = $this->Session->read('selectcontent.databuffer');
				$this->Session->delete('selectcontent.databuffer');
				$this->set('databuffer', $databuffer);

			}

			//intalize $contents
			$contents = array();

			if (!empty($contentids)) {
				//get contents listing by $contentid
				$contents = $this->getContentByIds($contentids);
				$this->Session->write('selectcontent.contentid', $contentids);
			}

			$license_url = $this->Session->read('license.url');
			$this->set('license_url', '/' . $license_url);

			$this->set('contents', $contents);
			$this->set('license', $license);
			$this->set('userid', $license['SppLicense']['creator_id']);
			$this->set('role_user', $this->role_user);
		} else {
			$contents = array();
			$contentids = array();

			if (!empty($_GET['new'])) {
				$contentids = $this->getContentByLicenseCode($this->SppLicense->id);
				//$contentids=$this->SppLicense->getContentLicense($this->SppLicense->id);
				//empty temp in session store
				$this->deleteTemp();
			}

			$contentids = $this->Session->read('selectcontent.contentid');

			if (!empty($contentids)) {
				//get contents listing by $contentid
				$contents = $this->getContentByIds($contentids);
				$this->Session->write('selectcontent.contentid', $contentids);
			}

			$databuffer = $this->Session->read('selectcontent.databuffer');
			$this->Session->delete('selectcontent.databuffer');
			$this->set('databuffer', $databuffer);

			$license_url = $this->Session->read('license.url');
			$this->set('license_url', '/' . $license_url);

			$license = $this->SppLicense->read();
			$this->set('license', $license);

			$this->set('contents', $contents);

			$this->Session->write('usertype.sysadmin', 1);
			$this->set('role_user', $this->role_user);
		}
	}

	//Show dialog confirm
	function dialogConfirm()
	{
		$this->render('/elements/dialogconfirm');
	}

	/**
	 * add new license
	 * input    array | POST
	 * output
	 */
	function submitadd()
	{
		$tmp = $this->Auth->user();

		$this->loadModel('SppLicenseContent');

		$this->Session->delete('selectcontent.databuffer');
		$this->Session->write('selectcontent.databuffer', $this->data);

		//check validation
		if (empty($this->data['SppLicense']['number'])) {

			if ($tmp['SppUser']['user_name'] == Configure::read('User.WEBADMIN')) {
				$this->Session->setFlash(Configure::read('Message.ERR_USER_NUMBER'));
			} else {
				$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_NUMBER'));
			}
			$this->redirect(array('action' => 'add'));
		}

		if (!is_numeric($this->data['SppLicense']['number']) || $this->data['SppLicense']['number'] <= 0) {
			$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_NUMBER_IS_NUMBERIC'));
			$this->redirect(array('action' => 'add'));
		}

		if(empty($this->data['SppLicense']['check_flag'])){
			$this->data['SppLicense']['check_flag'] = 1;
		} else {
			$this->data['SppLicense']['check_flag'] = 0;
		}

		if (empty($this->data['SppLicense']['license_desc'])) {
			if ($tmp['SppUser']['user_name'] == Configure::read('User.WEBADMIN')) {
				$this->Session->setFlash(Configure::read('Message.ERR_USERNAME_EMPTY'));
			} else {
				$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_DESC'));
			}

			$this->redirect(array('action' => 'add'));
		}

		/********
		 ******* Added by Tuannm*******
		 *******/
		if ($tmp['SppUser']['user_name'] == Configure::read('User.WEBADMIN')
		&& $this->data['SppLicense']['number'] > 1
		&& empty($this->data['SppLicense']['check'])
		) {
			$this->Session->setFlash(Configure::read('Message.ERR_CONSEQUENCE_NUMBER_OF_USER'));
			$this->redirect(array('action' => 'add'));
		}

		//check maxlen
		if ($tmp['SppUser']['user_name'] == Configure::read('User.WEBADMIN')) {
			if (strlen($this->data['SppLicense']['license_desc']) > 16) {
				$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_USER_MAXLEN'));
				$this->redirect(array('action' => 'add'));
			}
		}

		/***********END********/

		//check maxlen
		if (strlen($this->data['SppLicense']['license_desc']) > 100) {
			$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_DESC_MAXLEN'));
			$this->redirect(array('action' => 'add'));
		}

		if (!empty($this->data['SppLicense']['number'])) {

			$contentids = $this->Session->read('selectcontent.contentid');
			if (!empty($contentids)) {
				$contentids = explode(',', $contentids);
			}

			$this->data['SppLicense']['expired_start_date'] = str_replace('/', '-', $this->data['SppLicense']['expired_start_date']);
			$this->data['SppLicense']['expired_end_date'] = str_replace('/', '-', $this->data['SppLicense']['expired_end_date']);
			if (strtotime($this->data['SppLicense']['expired_start_date']) > strtotime($this->data['SppLicense']['expired_end_date'])) {
				$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_DATE'));
				$this->redirect(array('action' => 'add'));
			}
			$license_desc = $this->data['SppLicense']['license_desc'];
			if (strlen($license_desc) > 256) {
				$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_DESC_MAXLEN'));
				$this->redirect(array('action' => 'add'));
			}
			$maxLengthNumber = strlen($this->data['SppLicense']['number']);

			/**
			 * Tuannm
			 */
			$this->SppLicense->begin();
			for ($i = 0; $i < $this->data['SppLicense']['number']; $i++) {
				$this->data['SppLicense']['license_desc'] = $license_desc;

				for($j=0;$j<1000;$j++){
					$this->data['SppLicense']['license_code']= $this->SppLicense->genRandomStringE(); // yamamoto customize
					if(!$this->checkLicenseCodeExit($this->data['SppLicense']['license_code'])){
						break;
					}
				}
				if ($this->checkLicenseCodeExit($this->data['SppLicense']['license_code'])) {
					$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_CODE_EXITS'));
					$this->redirect(array('action' => 'add'));
				}
				if ($tmp['SppUser']['user_name'] == Configure::read('User.WEBADMIN')) {
					if (!empty($this->data['SppLicense']['check'])) {
						if ($this->data['SppLicense']['number'] > 1) {
							$this->data['SppLicense']['license_desc'] .= $this->getConsequenceNumber($i + 1);
							if ($this->checkLicenseUserName($this->data['SppLicense']['license_desc'], $tmp['SppUser']['id'])) {
								$this->SppLicense->rollback();
								$this->Session->setFlash(Configure::read('Message.ERR_USERNAME_IN_CHAIN_NOT_UNIQUE'));
								$this->redirect(array('action' => 'add'));
							}
						} else {
							if ($this->checkLicenseUserName($this->data['SppLicense']['license_desc'], $tmp['SppUser']['id'])) {
								$this->Session->setFlash(Configure::read('Message.ERR_USERNAME_EXISTED'));
								$this->redirect(array('action' => 'add'));
							}
						}
					} else {
						if ($this->checkLicenseUserName($this->data['SppLicense']['license_desc'], $tmp['SppUser']['id'])) {
							$this->Session->setFlash(Configure::read('Message.ERR_USERNAME_EXISTED'));
							$this->redirect(array('action' => 'add'));
						}
					}
					//$this->data['SppLicense']['client_identifier_no'] = $this->Pass4v->genRandomString(8, '123456789abcdefghijklmnopqrstuvwxyz');
				} else {
					if (!empty($this->data['SppLicense']['check'])) {
						if ($maxLengthNumber > 1) {
							$this->data['SppLicense']['license_desc'] .= ' ' . $this->serialNumber($i + 1, $maxLengthNumber);
						} else {
							$this->data['SppLicense']['license_desc'] .= ' ' . '0' . ($i + 1);
						}
					}
				}

				$this->data['SppLicense']['created_datetime'] = date('Y-m-d H:i:s');
				$this->data['SppLicense']['id'] = 0;
				$this->data['SppLicense']['updated_datetime'] = date('Y-m-d H:i:s');
				$session = $this->Session->read();
				//$this->data['SppLicense']['creator_id'] = $session['Auth']['SppUser']['id'];

				//trunglc - edit - 28/10/2013

				//$this->data['SppLicense']['user_id'] = $session['Auth']['SppUser']['id'];

				//debug($this->data);die;

				if (!empty($this->data['SppLicense']['user_id'])) {
					$user = $this->SppUser->find('first', array('conditions' => array('SppUser.id' => $this->data['SppLicense']['user_id'])));
					$this->data['SppLicense']['user_name'] = $user['SppUser']['user_name'];
					$this->data['SppLicense']['creator_id'] = $this->data['SppLicense']['user_id'];
				} else {
					$this->data['SppLicense']['user_name'] = $tmp['SppUser']['user_name'];
					$this->data['SppLicense']['creator_id'] = $tmp['SppUser']['id'];
				}


				//trunglc end

				/***************************************END***********************************************/

				if ($this->SppLicense->save($this->data)) {
						
					if (count($contentids)) {
						foreach ($contentids as $coid) {
							if (!empty($coid)) {
								$this->data['SppLicenseContent']['license_id'] = $this->SppLicense->id;
								$this->data['SppLicenseContent']['content_id'] = $coid;
								$this->data['SppLicenseContent']['id'] = 0;
								//add to table license content
								$this->SppLicenseContent->save($this->data);
							}
						}
					}
					$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_ADDED'));
				}

			}
			$this->SppLicense->commit();

			//empty temp in session store
			$this->deleteTemp();
			$license_url = $this->Session->read('license.url');
			$this->redirect('/' . $license_url);
		}
	}


	/**
	 * Update license
	 * input    array | POST
	 * output
	 */

	function submitedit()
	{

		$tmp = $this->Auth->user();

		$edittype = $this->Session->read('Edit.edittype');

		$this->Session->delete('selectcontent.databuffer');
		$this->Session->write('selectcontent.databuffer', $this->data);

		$this->loadModel('SppLicenseContent');

		$contentids = $this->Session->read('selectcontent.contentid');
		$contentids = explode(',', $contentids);

		if ($edittype != 2) {

			$this->data['SppLicense']['expired_start_date'] = str_replace('/', '-', $this->data['SppLicense']['expired_start_date']);
			$this->data['SppLicense']['expired_end_date'] = str_replace('/', '-', $this->data['SppLicense']['expired_end_date']);

			//check validation
			if (!($tmp['SppUser']['user_name'] == Configure::read('User.WEBADMIN'))) {
				if (empty($this->data['SppLicense']['license_desc'])) {
					$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_DESC'));
					$this->redirect(array('action' => 'edit', '?' => array('id' => $_POST['id'])));
				}
			}

			//check maxlen
			if (!($tmp['SppUser']['user_name'] == Configure::read('User.WEBADMIN'))) {
				if (strlen($this->data['SppLicense']['license_desc']) > 100) {
					$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_DESC_MAXLEN'));
					$this->redirect(array('action' => 'edit', '?' => array('id' => $_POST['id'])));
				}
			}
			//check date valid
			if (strtotime($this->data['SppLicense']['expired_start_date']) > strtotime($this->data['SppLicense']['expired_end_date'])) {
				$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_DATE'));
				$this->redirect(array('action' => 'edit', '?' => array('id' => $_POST['id'])));
			}

			$this->data['SppLicense']['id'] = (int)$_POST['id'];
			$this->data['SppLicense']['updated_datetime'] = date('Y-m-d H:i:s');
			$session = $this->Session->read();

			if(empty($this->data['SppLicense']['check_flag'])){
				$this->data['SppLicense']['check_flag'] = 1;
			} else {
				$this->data['SppLicense']['check_flag'] = 0;
			}

			//trunglc - edit - 28/10/2013

			//$this->data['SppLicense']['user_id'] = $session['Auth']['SppUser']['id'];
			if ($tmp['SppUser']['user_name'] == Configure::read('User.SYSADMIN')) {
				$this->data['SppLicense']['creator_id'] = $this->data['SppLicense']['user_id'];
			}

			//debug($this->data);die;
			//trunglc end


			if ($this->SppLicense->save($this->data)) {
				$this->SppLicenseContent->deleteAll(array('SppLicenseContent.license_id' => $this->data['SppLicense']['id']));
				if (count($contentids)) {
					foreach ($contentids as $coid) {
						if (!empty($coid)) {
							$this->data['SppLicenseContent']['license_id'] = $this->data['SppLicense']['id'];
							$this->data['SppLicenseContent']['content_id'] = $coid;
							$this->data['SppLicenseContent']['id'] = 0;
							$this->SppLicenseContent->save($this->data);
						}
					}
				}
				$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_UPDATED'));
			}

		} else {

			$expired_start_date = '';
			$expired_end_date = '';

			if (!empty($this->data['SppLicense']['expired_start_date'])) {
				$expired_start_date = str_replace('/', '-', $this->data['SppLicense']['expired_start_date']);
			}
			if (!empty($this->data['SppLicense']['expired_end_date'])) {
				$expired_end_date = str_replace('/', '-', $this->data['SppLicense']['expired_end_date']);
			}

			//check date valid
			if (!empty($expired_start_date) && !empty($expired_end_date)) {
				if (strtotime($this->data['SppLicense']['expired_start_date']) > strtotime($this->data['SppLicense']['expired_end_date'])) {
					$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_DATE'));
					$this->redirect(array('action' => 'edit', '?' => array('edittype' => 2)));
				}
			}

			$keyword = $this->Session->read('Search.searchkey');

			$this->SppUser->unbindModel(array('hasAndBelongsToMany' => array('SppRole')));
			$user_id = $this->SppUser->find('first', array('conditions' => array('SppUser.user_name' => Configure::read('User.WEBADMIN')),
                'fields' => array('SppUser.id')));
			$filter_creator_ids = array($user_id['SppUser']['id'], Configure::read('CLIENT_ADMIN'));
			$keyuser = $this->Session->read('Search.keyuser');

			$condition = null;

			if (!empty($keyword)) {
				if ($keyuser == 1) {
					$condition = array(
                        'SppLicense.learner_id <>' => ' NULL ',
					//Added by Tuannm on 2013/04/16 for #20685
					//'NOT' => array('SppLicense.creator_id' => $filter_creator_ids),
					//End
                        'OR' => array(
                            'SppLicense.license_code LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.license_desc LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.learner_id LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.comment LIKE' => "%" . mysql_real_escape_string($keyword) . "%"));
				} else {
					$condition = array(
					//Added by Tuannm on 2013/04/16 for #20685
					//'NOT' => array('SppLicense.creator_id' => $filter_creator_ids),
					//End
                        'OR' => array(
                            'SppLicense.license_code LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.learner_id LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.license_desc LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.comment LIKE' => "%" . mysql_real_escape_string($keyword) . "%"));
				}
			} else {
				if ($keyuser == 1) {
					$condition = array(
                        'SppLicense.learner_id <>' => ' NULL ',
					//Added by Tuannm on 2013/04/16 for #20685
                        'NOT' => array('SppLicense.creator_id' => $filter_creator_ids),
					//End
					);
				} else {
					$condition = array('NOT' => array('SppLicense.creator_id' => $filter_creator_ids));
				}
			}

			//debug($condition);die;
			/* $this->SppLicense->updateAll(array('SppLicense.expired_start_date' => $this->data['SppLicense']['expired_start_date'],
			 'SppLicense.expired_end_date' => $this->data['SppLicense']['expired_end_date'],
			 'SppLicense.updated_datetime' => date('Y/m/d'),
			 'SppLicense.user_id' => $user['SppUser']['id']), $condition
			 );*/

			$listLicense = $this->SppLicense->find('all', array('conditions' => $condition));

			foreach ($listLicense as $license) {

				if (!empty($expired_start_date)) {
					$license['SppLicense']['expired_start_date'] = $this->data['SppLicense']['expired_start_date'];
				}
				if (!empty($expired_end_date)) {
					$license['SppLicense']['expired_end_date'] = $this->data['SppLicense']['expired_end_date'];
				}

				if(empty($this->data['SppLicense']['check_flag'])){
					$license['SppLicense']['check_flag'] = 1;
				} else {
					$license['SppLicense']['check_flag'] = 0;
				}

				$license['SppLicense']['updated_datetime'] = date('Y-m-d H:i:s');
				$license['SppLicense']['user_id'] = $this->data['SppLicense']['user_id'];
				$license['SppLicense']['creator_id'] = $this->data['SppLicense']['user_id'];
				empty($this->data['SppLicense']['license_desc']) ? '' : $license['SppLicense']['license_desc'] = $this->data['SppLicense']['license_desc'];
				empty($this->data['SppLicense']['comment']) ? '' : $license['SppLicense']['comment'] = $this->data['SppLicense']['comment'];

				$contentids = array_filter($contentids);

				if ($this->SppLicense->save($license)) {
					if (count($contentids)) {
						$this->SppLicenseContent->deleteAll(array('SppLicenseContent.license_id' => $license['SppLicense']['id']));
						foreach ($contentids as $coid) {
							if (!empty($coid)) {
								$this->data['SppLicenseContent']['license_id'] = $license['SppLicense']['id'];
								$this->data['SppLicenseContent']['content_id'] = $coid;
								$this->data['SppLicenseContent']['id'] = 0;
								$this->SppLicenseContent->save($this->data);
							}
						}
					}
				}
			}
			$this->Session->delete('selectcontent.contentid');
			$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_UPDATED'));
		}
		//empty temp in session store
		$this->deleteTemp();
		$license_url = $this->Session->read('license.url');
		$this->redirect('/' . $license_url);
	}

	/**
	 * Delete license
	 * input    id of license
	 * output
	 */

	function delete()
	{

		$this->loadModel('SppLicenseContent');
		$id = empty($_GET['id']) ? 0 : $_GET['id'];
		$this->SppLicenseContent->deleteAll(array('SppLicenseContent.license_id' => $id));
		$this->SppLicense->delete($id);
		$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_DELETED'));
		$license_url = $this->Session->read('license.url');
		$this->redirect('/' . $license_url);
		//$this->redirect(array('action' => 'index'));
	}

	/**
	 * Delete license
	 * input    id of license
	 * output
	 */

	function clearidentifier()
	{

		$id = empty($_GET['id']) ? 0 : $_GET['id'];
		$this->data['SppLicense']['id'] = (int)$id;
		//$this->data['SppLicense']['learner_id'] = null;
		$this->data['SppLicense']['client_used_date'] = null;
		$this->SppLicense->save($this->data);
		$this->Session->setFlash(Configure::read('Message.ERR_LICENSE_UPDATED'));
		$license_url = $this->Session->read('license.url');
		$this->redirect('/' . $license_url);
	}


	/**
	 * Create random string
	 * input length of string
	 * output string
	 */
	function genRandomString($length = 10)
	{
		$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPRSTUVWXYZ';
		$string = null;
		for ($p = 0; $p < $length; $p++) {
			if ($p % 4 == 0 & $p > 0) {
				$string .= '-';
			}
			$string .= $characters[mt_rand(0, strlen($characters) - 1)];
		}
		return $string;
	}

	/**
	 * Empty session store
	 * input
	 * output
	 */
	function deleteTemp()
	{
		$this->Session->delete('selectcontent.url');
		$this->Session->delete('selectcontent.databuffer');
		$this->Session->delete('selectcontent.contentid');
		$this->Session->delete('system.active_flag');
		$this->Session->delete('system.version_update_flag');
	}

	/**
	 * Get listing contentid by license code
	 * input int $licenseid| string|$type return listing id with type string if type is string else return array
	 * output array|string
	 */
	function getContentByLicenseCode($licenseid = 0, $type = 'string')
	{
		$this->loadModel('SppLicenseContent');
		$content_license = $this->SppLicenseContent->find('all', array('conditions' => array('SppLicenseContent.license_id' => $licenseid)));

		$content_license_id = array();
		foreach ($content_license as $cl) {
			$content_license_id[] = $cl['SppLicenseContent']['content_id'];
		}

		if ($type == 'string') {
			$content_license_ids = implode(',', $content_license_id);
		} else {
			$content_license_ids = $content_license_id;
		}

		return $content_license_ids;
	}

	/**
	 * Check license code extis
	 * input int $licensecode
	 * output boolean. return true if its exits, else return false
	 */
	function checkLicenseCodeExit($licensecode = '')
	{

		$license = $this->SppLicense->find('all', array('conditions' => array('SppLicense.license_code' => $licensecode)));
		if (!empty($license[0]['SppLicense']['id'])) {
			return true;
		}
		return false;
	}
	/**
	 * Get content by ids
	 * input string $ids | ex: 1,4,5,12,3,6
	 * output array
	 */
	function getContentByIds($ids = '')
	{
		$this->loadModel('SppContent');
		$this->loadModel('SppUser');
		$contents = $this->SppContent->find('all', array(
            'conditions' => array('SppContent.id IN (' . $ids . ')'),
            'order' => array('SppContent.content_code ASC'),
            'recursive' => -1
		));
		foreach ($contents as $k => $d) {

			$user = $this->SppUser->findById($d['SppContent']['user_id']);
			$contents[$k]['SppUser']['user_name'] = $user['SppUser']['user_name'];
			$typeContent = ($d['SppContent']['content_type'] == 1) ? 'set' : 'item';
			$file_update_time = $this->getContentFileByContentID($d['SppContent']['id'], $typeContent);
			$contents[$k]['SppContent']['update_time_file'] = empty($file_update_time[0][0]['update_file_time']) ? '' : $file_update_time[0][0]['update_file_time'];
		}

		return $contents;
	}

	/**
	 * Get content by id listing
	 * input int | $id
	 * output string | maximum update_datetime
	 */
	function getContentFileByContentID($id = 0, $type = 'set')
	{
		if ($type == 'set')
		$ids = $this->getContentItem($id);
		else
		$ids = $id;
		if (!empty($ids)) {
			$this->loadModel('SppContentFile');
			$update_file_time = $this->SppContentFile->find('all', array(
                'conditions' => array('SppContentFile.content_id in (' . $ids . ')'),
                'fields' => array('max(SppContentFile.updated_datetime) as update_file_time')
			));
			//$contents=$this->query('select max(updated_datetime) as update_file_time from spp_content_files  where id  = '.$id);
		} else {
			$file_update_time = array();
			@$file_update_time[0][0]['update_file_time'] = '';
			//$update_file_time='';
		}
		return @$update_file_time;
	}


	/**
	 * Get listing contentid by content set id
	 * input int $contentid| string|$type return listing id with type string if type is string else return array
	 * output array|string
	 */
	function getContentItem($contentid = 0, $type = 'string')
	{
		$this->loadModel('SppContentItem');
		$content_license = $this->SppContentItem->find('all', array(
            'conditions' => array('SppContentItem.content_id' => $contentid),
            'recursive' => -1,
		));
		$content_license_id = array();
		foreach ($content_license as $cl) {
			$content_license_id[] = $cl['SppContentItem']['child_content_id'];
		}

		if ($type == 'string') {
			$content_license_ids = implode(',', $content_license_id);
		} else {
			$content_license_ids = $content_license_id;
		}

		return $content_license_ids;
	}

	/**
	 * SPP_3 method
	 * export license list to csv
	 * haitlt
	 */
	function csvExport()
	{
		Configure::write('debug', 0);
		$this->layout = false;
		$encode = $_POST['encode'];

		$user = $this->Auth->user();
		if($user['SppUser']['user_name']== 'sysadmin'){
			$data = $this->getCSVData();
		} else {
			$data = $this->getCSVDataLimited($user['SppUser']['id']);
		}
		$array = array();

		//edit array
		foreach ($data as $detail) {
			$newDetail = array(
			date('Y/m/d', strtotime($detail['SppLicense']['created_datetime'])),
			$detail['SppLicense']['license_code'],
			$detail['SppLicense']['creator_name'],
			$detail['SppLicense']['license_desc'],
			$detail['SppLicense']['learner_id'],
			(!empty($detail['SppLicense']['client_used_date'])) ? date('Y/m/d', strtotime($detail['SppLicense']['client_used_date'])) : '',
			(!empty($detail['SppLicense']['expired_end_date'])) ? date('Y/m/d', strtotime($detail['SppLicense']['expired_end_date'])) : ''
			);

			array_push($array, $newDetail);
		}

		$header = array(CREATED_DATETIME, LICENSE_CODE, CREATOR_NAME, LICENSE_DESC, LEARNER_ID, CLIENT_USED_DATE, EXPIRED_END_DATE);
		$fileName = date('Ymdhms');
		$this->Csv->export($encode, $array, $header, $fileName . '.csv');
	}

	public function csvImport(){
		$this->layout = FALSE;
		$this->autoRender = false;
		if ($name = $this->_uploadfile()) {
			try{
				$data = $this->Csv->import("files/" . $name, $this->aryFieldHeaders );
				unlink(WWW_ROOT . "files/" . $name);
			} catch (Exception $e){
				$this->Session->setFlash(Configure::read('Message.ERR_WRONG_FORMAT'));
				return;
			}
			if(!$data && is_bool($data) === true){
				$this->Session->setFlash(Configure::read('Message.ERR_WRONG_FORMAT'));
				return;
			}

			if(empty($data) ||  count($data) <= 1){
				$this->Session->setFlash(Configure::read('Message.ERR_HAVE_NO_DATA'));
				return;
			}

			$this->SppLicense->begin();
			try {
				$numberUpdate = 0;
				unset($data[0]);
				foreach ($data as $key => $item) {
					$license = $this->SppLicense->find("first",array("conditions" => array("license_code" => $item['SppLicense']['license_code'])));
					if(!empty($license)){
						if($license['SppLicense']['license_desc'] != $item['SppLicense']['license_desc']){
							$license['SppLicense']['license_desc'] = $item['SppLicense']['license_desc'];
							$license['SppLicense']['updated_datetime'] = date("Y-m-d H:i:m");
							$this->SppLicense->save($license,array('conditions' => array('SppLicense.id' => $license['SppLicense']['id'])));
							$numberUpdate++;
						}
					} else {
						$user = $this->Auth->user();
						$item['SppLicense']['creator_id'] = $user['SppUser']['id'];
						$item['SppLicense']['created_datetime'] = date("Y-m-d H:i:m");
						if(empty($item['SppLicense']['client_used_date'])){
							$item['SppLicense']['client_used_date'] = NULL;
						}
						$this->SppLicense->create();
						$this->SppLicense->set($item);
						$this->SppLicense->save();
						$numberUpdate++;
					}
				}
				$this->SppLicense->commit();
				$this->Session->setFlash($numberUpdate.Configure::read('Message.MSG_ROW_UPDATE'));
				return;
			} catch (Exception $e) {
				$this->Session->setFlash(Configure::read('Message.ERR_IMPORT'));
				$this->SppLicense->rollback();
				return;
			}
		}
	}

	/**
	 *
	 * upload file
	 */
	function _uploadfile() {
		$name = time() . ".csv";
		$filename = "files/" . $name;
		/* copy uploaded file */
		if (move_uploaded_file($this->data['Pages']['file']['tmp_name'], $filename)) {
			/* save message to session */
			//$this->Session->setFlash('File uploaded successfuly.');
			return $name;
		} else {
			/* save message to session */
			echo 'There was a problem uploading file. Please try again.';
			return FALSE;
		}
	}

	/**
	 * getCSVData
	 *
	 * @author haitlt
	 */
	private function getCSVData()
	{

		//get keyword in session store
		$searchkey = $this->Session->read('Search.searchkey');

		if (isset($_POST['keyword'])) {

			$this->Session->delete('Search.searchkey');
			$this->Session->write('Search.searchkey', $_POST['keyword']);

			$searchkey = $this->Session->read('Search.searchkey');
		}

		$keyword = empty($searchkey) ? '' : $searchkey;

		// Huyen edit start
		//$keyuser = isset($_POST['keyuser']);
		$keyuser = $this->Session->read('system.flag_filter');

		//*************Added by Tuanm**************//
		$tmp = $this->Auth->user();
		$webadmin = 0;
		if ($tmp['SppUser']['user_name'] == Configure::read('User.WEBADMIN')) {
			$keyuser = 1;
			$webadmin = 1;
			$filter_creator_ids = array($tmp['SppUser']['id'], Configure::read('CLIENT_ADMIN'));
		}

		if ($webadmin == 0) {
			$this->SppUser->unbindModel(array('hasAndBelongsToMany' => array('SppRole')));
			$user_id = $this->SppUser->find('first', array('conditions' => array('SppUser.user_name' => Configure::read('User.WEBADMIN')),
                'fields' => array('SppUser.id')));
			$filter_creator_ids = array($user_id['SppUser']['id'], Configure::read('CLIENT_ADMIN'));
		}
		if (!empty($keyword)) {
			if ($keyuser == 1) {
				$keySearch = array(
                    'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
                    'conditions' => array(
                        'SppLicense.learner_id <>' => ' NULL ',
                        'OR' => array(
                            'SppLicense.license_code LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.license_desc LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.learner_id LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
				//'SppLicense.creator_id' => $filter_creator_ids,
                            'SppLicense.comment LIKE' => "%" . mysql_real_escape_string($keyword) . "%")),
                    'joins' => array(
				array('type' => 'LEFT', 'alias' => 'users', 'table' => 'spp_users',
                            'conditions' => 'SppLicense.creator_id = users.id')),
				);
			} else {
				$keySearch = array(
                    'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
                    'conditions' => array(
                        'OR' => array(
                            'SppLicense.license_code LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.learner_id LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.license_desc LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
				//'SppLicense.creator_id' => $filter_creator_ids,
                            'SppLicense.comment LIKE' => "%" . mysql_real_escape_string($keyword) . "%")),
                    'joins' => array(
				array('type' => 'LEFT', 'alias' => 'users', 'table' => 'spp_users',
                            'conditions' => 'SppLicense.creator_id = users.id')),
				);
			}
		} else {
			if ($keyuser == 1) {
				$keySearch = array(
                    'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
                    'conditions' => array(
                        'SppLicense.learner_id <>' => ' NULL ',
				// 'SppLicense.creator_id' => $filter_creator_ids,
				),
                    'joins' => array(
				array('type' => 'LEFT', 'alias' => 'users', 'table' => 'spp_users',
                            'conditions' => 'SppLicense.creator_id = users.id')),
				);
			} else {
				$keySearch = array(
				//'conditions' => array('SppLicense.creator_id' => $filter_creator_ids),

                    'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC')
				);
			}
		}

		$this->set('keyword', $keyword);
		$this->set('keyuser', $keyuser);
		$data = $this->SppLicense->find('all', $keySearch);
		$this->loadModel('SppUser');
		foreach ($data as $key => $d) {
			$this->SppUser->id = $d['SppLicense']['creator_id'];
			$userItem = $this->SppUser->read();
			$data[$key]['SppLicense']['creator_name'] = $userItem['SppUser']['user_name'];
		}

		return $data;
	}
	/**
	 * getCSVData
	 *
	 * @author haitlt
	 */
	private function getCSVDataLimited($id=0)
	{

		//get keyword in session store
		$searchkey = $this->Session->read('Search.searchkey');

		if (isset($_POST['keyword'])) {

			$this->Session->delete('Search.searchkey');
			$this->Session->write('Search.searchkey', $_POST['keyword']);

			$searchkey = $this->Session->read('Search.searchkey');
		}

		$keyword = empty($searchkey) ? '' : $searchkey;

		// Huyen edit start
		//$keyuser = isset($_POST['keyuser']);
		$keyuser = $this->Session->read('system.flag_filter');

		//*************Added by Tuanm**************//
		$tmp = $this->Auth->user();
		$webadmin = 0;
		if ($tmp['SppUser']['user_name'] == Configure::read('User.WEBADMIN')) {
			$keyuser = 1;
			$webadmin = 1;
			$filter_creator_ids = array($tmp['SppUser']['id'], Configure::read('CLIENT_ADMIN'));
		}

		if ($webadmin == 0) {
			$this->SppUser->unbindModel(array('hasAndBelongsToMany' => array('SppRole')));
			$user_id = $this->SppUser->find('first', array('conditions' => array('SppUser.user_name' => Configure::read('User.WEBADMIN')),
                'fields' => array('SppUser.id')));
			$filter_creator_ids = array($user_id['SppUser']['id'], Configure::read('CLIENT_ADMIN'));
		}
		if (!empty($keyword)) {
			if ($keyuser == 1) {
				$keySearch = array(
                    'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
                    'conditions' => array(
                        'SppLicense.learner_id <>' => ' NULL ',
                        'SppLicense.creator_id' => $id,
                        'OR' => array(
                            'SppLicense.license_code LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.license_desc LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.learner_id LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
				//'SppLicense.creator_id' => $filter_creator_ids,
                            'SppLicense.comment LIKE' => "%" . mysql_real_escape_string($keyword) . "%")),
                    'joins' => array(
				array('type' => 'LEFT', 'alias' => 'users', 'table' => 'spp_users',
                            'conditions' => 'SppLicense.creator_id = users.id')),
				);
			} else {
				$keySearch = array(
                    'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
                    'conditions' => array(
                        'SppLicense.creator_id' => $id,
                        'OR' => array(
                            'SppLicense.license_code LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.learner_id LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                            'SppLicense.license_desc LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
				//'SppLicense.creator_id' => $filter_creator_ids,
                            'SppLicense.comment LIKE' => "%" . mysql_real_escape_string($keyword) . "%")),
                    'joins' => array(
				array('type' => 'LEFT', 'alias' => 'users', 'table' => 'spp_users',
                            'conditions' => 'SppLicense.creator_id = users.id')),
				);
			}
		} else {
			if ($keyuser == 1) {
				$keySearch = array(
                    'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC'),
                    'conditions' => array(
                        'SppLicense.learner_id <>' => ' NULL ',
                        'SppLicense.creator_id' => $id,
				),
                    'joins' => array(
				array('type' => 'LEFT', 'alias' => 'users', 'table' => 'spp_users',
                            'conditions' => 'SppLicense.creator_id = users.id')),
				);
			} else {
				$keySearch = array(
                    'conditions'=> array( 'SppLicense.creator_id' => $id),

                    'order' => array('SppLicense.created_datetime ASC', 'SppLicense.license_desc ASC')
				);
			}
		}

		$this->set('keyword', $keyword);
		$this->set('keyuser', $keyuser);
		$data = $this->SppLicense->find('all', $keySearch);
		$this->loadModel('SppUser');
		foreach ($data as $key => $d) {
			$this->SppUser->id = $d['SppLicense']['creator_id'];
			$userItem = $this->SppUser->read();
			$data[$key]['SppLicense']['creator_name'] = $userItem['SppUser']['user_name'];
		}

		return $data;
	}

	/**
	 *
	 * Create consequence number
	 * @param unknown_type $number
	 * @author: Tuannm
	 */
	private function getConsequenceNumber($number)
	{
		$mynumber = $number;
		if ($number < 10) {
			$mynumber = '0000' . $number;
		} else if ($number < 100) {
			$mynumber = '000' . $number;
		} else if ($number < 1000) {
			$mynumber = '00' . $number;
		} else if ($number < 10000) {
			$mynumber = '0' . $number;
		} else if ($number < 100000) {
			$mynumber = $number;
		}
		return $mynumber;
	}

	private function checkLicenseUserName($license_user_name, $creator)
	{
		$user_name = $this->SppLicense->find('all',
		array('conditions' => array('SppLicense.license_desc' => $license_user_name,
                'SppLicense.creator_id' => $creator)));
		if ($user_name) {
			return true;
		}
		return false;
	}

}

?>
