<?php // $Id$
/**
 * @copyright     2012 (c) Fasteps Co., Ltd. All Rights Reserved.
 * @package
 * @since
 * We use CakePHP(tm) ver 1.3
 */
//BBS 2012.11 Start
define("LEARNER_ID", "ID(email)");
define("LEARNER_NAME", "氏名");
define("ORGANIZATION_CODE", "利用コード");
define("START_LEARNING_DATE", "利用開始日");
define("REMAINING_DAYS", "利用期限");
define("LEARNING_TIME_TOTAL", "総学習時間");
define("LEARNING_AVERAGE_MINUTES", "平均時間（分）");
define("QUIZ_PROGRESS", "問題進捗率");
define("CORRECT_RATE", "正答率");
define("RANK_NAME", "ランク");
define("MARK", "ポイント");
define("START_APP_COUNT", "アプリ起動数");
define("LATEST_START_APP", "最終利用日");
define("LATEST_START_APP_FROM_PUSH", "プッシュ確認日");
define("LEARNING_PROGRESS", "レッスン消化率");
define("CORRECTION_COUNT", "添削回数");
class  SppDescStudyRecordController extends AppController {
	var $name = 'SppDescStudyRecord';
	var $helpers = array('Html', 'Form', 'Session', 'Javascript');
	var $components = array('Auth', 'Session', 'Csv','RequestHandler');
	var $role_user = array();
	var $paginate = array();
//	var $uses = array('SppStudyRecord','SppUser', 'SppLearner','SppOrganization','SppRankMaster','SppCorrection','SppLicense','SppLearningLog');
	var $uses = array('SppStudyRecord','SppUser', 'SppLearner','SppOrganization','SppRankMaster','SppCorrection','SppLicense','SppLearningLog','SppQuizLog');

	/**
	 * Override method
	 */
	function beforeFilter()
	{
		parent::beforeFilter();
		$this->Auth->allow('logout', 'index', 'detail', 'login', 'menu','csvExport','updateMark');
		if(!$this->checkUserLogin()){
			$this->render('/elements/error');
			return;
		}
		// Load config file
		Configure::load('settings');

	}

	/**
	 * Get study records list and set to layout
	 * input : Nothing
	 * output :	study records
	 */
	function index()
	{
		// Using page layout
		$this->layout = 'default';

		$session = $this->Session->read();
		$user_id = $session['Auth']['SppUser']['id'];

		$this->Session->write('system.flag',0);
		$this->Session->write('system.flag_filter',0);

		//add url current to session store
		$this->Session->delete('descstudyrecord.url');
		$urlCurrent=$this->params['url']['url'];
		$this->Session->write('descstudyrecord.url', $urlCurrent);
		$is_only_achivement_role = !$this->isSystemManagement()/* && !$this->isSupporter()*/;
		$learner_id = "";
		$first_name = "";
		$last_name = "";
		$organization_code = "";
		$quiz_progress = "";
		if ($this->RequestHandler->isPost()){
			$this->Session->delete('Search.searchkey');
			$search_key = array();
			if(!empty($this->data['SppStudyRecord']['learner_id'])){
				$learner_id = $this->data['SppStudyRecord']['learner_id'];
				$search_key['SppStudyRecord']['learner_id'] = $learner_id;
			}
			if(!empty($this->data['SppStudyRecord']['first_name'])){
				$first_name = $this->data['SppStudyRecord']['first_name'];
				$search_key['SppStudyRecord']['first_name'] = $first_name;
			}
			if(!empty($this->data['SppStudyRecord']['last_name'])){
				$last_name = $this->data['SppStudyRecord']['last_name'];
				$search_key['SppStudyRecord']['last_name'] = $last_name;
			}
			if(!empty($this->data['SppStudyRecord']['organization_code'])){
				$organization_code = $this->data['SppStudyRecord']['organization_code'];
				$search_key['SppStudyRecord']['organization_code'] = $organization_code;
			}
			$quiz_progress = $this->data['SppStudyRecord']['quiz_progress'];
			if ($quiz_progress != "0" && (empty($quiz_progress) ||  !is_numeric($quiz_progress) || $quiz_progress < 0 || $quiz_progress > 100)) {
				$quiz_progress = "";
			}
			$search_key['SppStudyRecord']['quiz_progress'] = $quiz_progress;
			
			$this->Session->write('Search.searchkey', $search_key);
			if(isset($this->data['submit_csv_output'])){
				$this->csvExport($_POST['encode'], $user_id, $is_only_achivement_role, $learner_id, $first_name, $last_name);
			}

		} else {
			$search_key = $this->Session->read('Search.searchkey');
			if(!empty($search_key)){
				
				if(!empty($search_key['SppStudyRecord']['learner_id'])){
					$learner_id = $search_key['SppStudyRecord']['learner_id'];
				}
				
				if(!empty($search_key['SppStudyRecord']['first_name'])){
					$first_name = $search_key['SppStudyRecord']['first_name'];
				}
				
				if(!empty($search_key['SppStudyRecord']['last_name'])){
					$last_name = $search_key['SppStudyRecord']['last_name'];
				}
				
				if(!empty($search_key['SppStudyRecord']['organization_code'])){
					$organization_code = $search_key['SppStudyRecord']['organization_code'];
				}
				
				if($search_key['SppStudyRecord']['quiz_progress'] == "0" || !empty($search_key['SppStudyRecord']['quiz_progress'])){
					$quiz_progress = $search_key['SppStudyRecord']['quiz_progress'];
				}
			}
		}
		// get and set study data
/*
		$this->paginate  = $this->SppStudyRecord->getDataStudyRecord2($learner_id, $first_name, $last_name, $organization_code,$user_id, $is_only_achivement_role, $quiz_progress);
		$allData = $this->paginate('SppStudyRecord', 2);
		$data = array();
		foreach ($allData as $item) {
			$learer_id = $item['SppStudyRecord']['learner_id'];
			$sql = "select sum(timestampdiff(SECOND,time_start,time_end)) as sum from spp_learning_logs where learner_id='".$item['SppStudyRecord']['learner_id']."'";
			$ret = $this->SppLearningLog->query($sql);
			$num = $ret[0][0]['sum'];
			if($num == null){
				$num = 0;
			}
			$item['SppStudyRecord']['learning_time_seconds'] = $num;
			
			$datetime = new DateTime('now');
			$current = new DateTime($start);
			$diff = $current->diff($datetime);
			$days = $diff->days;
			if($days == 0){
				$days = 1;
			}
			$item['SppStudyRecord']['learning_average_minutes'] = round($num/$days/60,0);//."($days)";

//			$item['remaining_days'] = $this->SppLicense->getRemainingDays($item['SppStudyRecord']['learner_id']);
			$item['remaining_days'] = $this->SppLicense->getExpiredEndDate($item['SppStudyRecord']['learner_id']);
			$item['correction_count'] = $this->SppCorrection->countCorrectionByLearnerId($item['SppStudyRecord']['learner_id']);

			$learner = $this->SppLearner->findById($learer_id);
			$item['SppStudyRecord']['email'] = $learner['SppLearner']['email'];
			
			array_push($data, $item);
		}
		$this->set('data', $data);
*/
		if($is_only_achivement_role){
			$organizations = $this->SppOrganization->getOrgCodeForAchivementUser($user_id);
		}else{
			$organizations = $this->SppOrganization->find('all',array('fields'=>'CONCAT(code_large,code_middle,code_small) AS code, organization_name'));
		}
		$this->set('organizations', $organizations);
		$this->set('learner_id', $learner_id);
		$this->set('first_name', $first_name);
		$this->set('last_name', $last_name);
		$this->set('organization_code', $organization_code);
		$this->set('quiz_progress', $quiz_progress);
		$this->set('is_only_achivement_role', $is_only_achivement_role);
		$this->set('role_user', $this->role_user);

		//##### 20221221 記述式用 START #####
		//$sql = "select logs.* from spp_quiz_logs where learner_id like '%$orgCode%'";
//		$sql = "select * from spp_quiz_logs where desc_answer is not null";
//		$data2 = $this->SppQuizLog->query($sql);
//		$data2 = SppQuizLogs->get($id);
//		$data2 = $this->SppQuizLog->getData2();
//		$data2 = $this->SppQuizLog->getData([
//			'desc_answer' -> not null
//			]);
//		$this->log($sql);
//		$this->log($ret);
//		$this->log($data2);

//		$data3 = $this->SppQuizLog->getData3();
//		$this->log($data3);

		$this->paginate  = $this->SppQuizLog->getData3($learner_id, $first_name, $last_name);
		$allData = $this->paginate('SppQuizLog', 2);
		$data3 = array();
		foreach ($allData as $item) {
			array_push($data3, $item);
		}
		$this->log($data3);
		$this->set('data3', $data3);

		//$this->paginate  = $this->SppStudyRecord->getDataStudyRecord2($learner_id, $first_name, $last_name, $organization_code,$user_id, $is_only_achivement_role, $quiz_progress);
		//$allData = $this->paginate('SppStudyRecord', 2);
//		$data2 = array();
//		array_push($data2, $ret);

//		$this->set('data2', $data2);
		//##### 20221221 記述式用 END #####
	}

	function updateMark(){
		$this->autoRender = false;
		$learner_id = $_POST['learner_id'];
		$point_update = intval($_POST['point_update']);
		$study_record = $this->SppStudyRecord->getStudyRecordByLearner($learner_id);
		if(!empty($study_record)){
			$point_update += $study_record['SppStudyRecord']['point_update'];
			$total_mark = $study_record['SppStudyRecord']['mark'] + $point_update;
			if($total_mark >= 0){
				$this->loadModel('SppRankMaster');
				$rank_id = $this->SppRankMaster->getRankByMark($total_mark);
				if($study_record['SppStudyRecord']['rank_id'] != $rank_id){
					$study_record['SppStudyRecord']['rank_id'] = $rank_id;
					// update expired date because rank up
					if(intval($_POST['point_update']) > 0){
						$new_rank = $this->SppRankMaster->findById($rank_id);
						if(!empty($new_rank) && !empty($new_rank['SppRankMaster']['extend_days'])){
							$this->SppLicense->updateExpiredDate(null, $learner_id, $new_rank['SppRankMaster']['extend_days']);
						}
					}
				}
				$study_record['SppStudyRecord']['point_update'] = $point_update;
				if($this->SppStudyRecord->save($study_record['SppStudyRecord'])){
					return true;
				}
			}
		}
		return false;
	}
	/**
	 * Get detail study data and set to layout.
	 */
	function detail()
	{
		// Using page layout
		$this->layout = 'default_studyrecord_detail';
	
		$learner_id = $_GET['learner_id'];

		$this->Session->write('system.flag',0);
		$this->Session->write('system.flag_filter',0);

		//add url current to session store
		$this->Session->delete('studyrecord.url');
		$urlCurrent=$this->params['url']['url'];
		$this->Session->write('studyrecord.url', $urlCurrent);

		// Get study data by learner_id and set to layout.
		$detailData = $this->SppStudyRecord->getDetail($learner_id);
		$learnerSummaryData = $this->SppStudyRecord->getLearnerGeneralSummary($learner_id);
		$catesData = array();
		$categoryNames = Configure::read ( 'study_record.category_names' );
		foreach ($detailData as $item) {
			if(isset($categoryNames)){
				$item[0]['category_no'] = $item['LOGS']['category_no'];
				$item[0]['category_name'] = $categoryNames[$item[0]['category_no']];
			}
			array_push($catesData, $item[0]);
		}
		$orgAvgLearningData = array();
		if($learnerSummaryData){
			$learnerSummaryViewData = array();
			$learn_progress_rate = $learnerSummaryData[0][0]['learner_progress_rate'];
			$learn_archivement_rate = $learnerSummaryData[0][0]['learner_achievement_rate'];
			$sum_learning_time = $learnerSummaryData[0][0]['learner_sum_learning_time'];
			$sumLearningTimeHour = (int)($sum_learning_time/3600);
			$sumLearningTimeMinute = (int)(($sum_learning_time%3600)/60);
			$sumLearningTimeSecond = $sum_learning_time%60;
			$sumLearningTimeString = $sumLearningTimeHour."h".$sumLearningTimeMinute."m".$sumLearningTimeSecond."s";
			$learnerSummaryViewData['learner_progress_rate'] = $learn_progress_rate."％";
			$learnerSummaryViewData['learner_achievement_rate'] = $learn_archivement_rate."％";
			$learnerSummaryViewData['learner_sum_learning_time'] = $sumLearningTimeString;
			//temporarily set personal data to org average usage in case: learner is not member of any org
			$orgAvgLearningData['avg_progress_rate'] = $learn_progress_rate."％";
			$orgAvgLearningData['avg_achievement_rate'] = $learn_archivement_rate."％";
			$orgAvgLearningData['avg_sum_learning_time'] = $sumLearningTimeString;
			$this->set('learnerSummaryData',$learnerSummaryViewData);
		}
		$learner = $this->SppLearner->findById($learner_id);
		if(!empty($learner) && !($learner['SppLearner']['organization_code'] == Configure::read('PERSONAL_CODE'))){
			$orgCode = $learner['SppLearner']['organization_code'];

			$sql = "select count(*) as ct from spp_quiz_logs where learner_id like '%$orgCode%'";
			$ret = $this->SppLearningLog->query($sql);
			$num = $ret[0][0]['ct'];
			$sql2 = "select count(*) as ct from spp_learners where organization_code='$orgCode'";
			$ret2 = $this->SppLearningLog->query($sql2);
			$num2 = $ret2[0][0]['ct'];

			$orgAvgLearningSumaryFix = $this->SppStudyRecord->getOrgGeneralSummaryFix($orgCode);
			$orgAvgLearningSumary = $this->SppStudyRecord->getOrgGeneralSummary($orgCode);
			$orgAvgProgressRate = $orgAvgLearningSumaryFix[0][0]['avg_progress_rate'];
			$orgAvgArchivementRate = $orgAvgLearningSumary[0][0]['avg_achievement_rate'];
			$orgAvgLearningTime = $orgAvgLearningSumary[0][0]['avg_sum_learning_time'];
			$sumLearningTimeHour = (int)($orgAvgLearningTime/3600);
			$sumLearningTimeMinute = (int)(($orgAvgLearningTime%3600)/60);
			$sumLearningTimeSecond = $orgAvgLearningTime%60;
			$sumLearningTimeString = $sumLearningTimeHour."h".$sumLearningTimeMinute."m".$sumLearningTimeSecond."s";
			$orgAvgLearningData['avg_progress_rate'] = $orgAvgProgressRate."％";
			$orgAvgLearningData['avg_achievement_rate'] = $orgAvgArchivementRate."％";
			$orgAvgLearningData['avg_sum_learning_time'] = $sumLearningTimeString;

			if($num == 0){
				$orgAvgLearningData['avg_progress_rate'] = "0％";
				$orgAvgLearningData['avg_achievement_rate'] = "0％";

				$orgAvgLearningTime = $orgAvgLearningSumary[0][0]['avg_sum_learning_time']/$num2;
				$sumLearningTimeHour = (int)($orgAvgLearningTime/3600);
				$sumLearningTimeMinute = (int)(($orgAvgLearningTime%3600)/60);
				$sumLearningTimeSecond = $orgAvgLearningTime%60;
				$sumLearningTimeString = $sumLearningTimeHour."h".$sumLearningTimeMinute."m".$sumLearningTimeSecond."s";
				$orgAvgLearningData['avg_sum_learning_time'] = $sumLearningTimeString;
			
			}
		}
		$this->set('orgAvgLearningData',$orgAvgLearningData);
		$this->set('catesData', $catesData);
		
		$learner = $this->SppLearner->getListLearnerById($learner_id);//debug($learner);die;
		//$this->set('learnerId',$learner_id);
		$this->set('learnerId',$learner['SppLearner']['email']);
		$this->set('learnerName',$learner['SppLearner']['first_name'] .' '. $learner['SppLearner']['last_name']);
		
		$this->set('role_user', $this->role_user);
	}

	function csvExport($encode, $user_id, $is_only_achivement_role, $learner_id, $first_name, $last_name){
		$this->layout = false;

		$allData  = $this->SppQuizLog->getData3csv($learner_id, $first_name, $last_name);

		$array = array();
		//edit array
		if(!empty($allData)){
			foreach ($allData as $studyrecord) {
			
				$temp = array(
				$studyrecord['SppLearner']['email'],
				$studyrecord['SppLearner']['first_name'].' '.$studyrecord['SppLearner']['last_name'],
				$studyrecord['SppQuizLog']['category_name'],
				$studyrecord['SppQuizLog']['subcategory_name'],
				$studyrecord['SppQuizLog']['quiz_no'],
				$studyrecord['SppQuizLog']['desc_answer'],
				$studyrecord['SppQuizLog']['desc_answer_date'],
				);
				array_push($array, $temp);
			}
		}
		$header = array("ID(email)", "氏名", "カテゴリ名", "サブカテゴリ名", "問題番号",
		"解答","解答日");
		$fileName = '記述式解答'.date('Ymdhms');
		$this->Csv->export($encode, $array, $header, $fileName . '.csv');
	}
} //BBS 2012.11 End
?>
