<?php // $Id$
/**
 * @copyright     2011 (c) SEVENSEAS TECHWORKS Co., Ltd. All Rights Reserved.
 * @package       skrskscs
 * @since         2011-02-22
 * We use CakePHP(tm) ver 1.3.7
 */

class  SppContentController extends AppController
{


    var $name = 'SppContent';
    var $helpers = array('Html', 'Form', 'Session', 'Form', 'Dialog', 'pass4v');
    var $uses = array('SppContent', 'SppContentFile', 'SppUser', "SppUserRole", 'SppRole', 'SppContentItem', 'Quizz');
    var $components = array('Uploader.Uploader', 'Auth', 'Session', 'Pass4v');

    var $paginate = array(
        // 'limit' => 10000000,
        'order' => array(
            'SppContent.content_code' => 'asc'));
    // role user
    var $role_user = array();

    //function alow not logineditContent
    function beforeFilter()
    {
        parent::beforeFilter();

        $this->Auth->allow('add', 'index', 'edit', 'login', 'contentselect', 'getlistid', 'submitadd', 'dialogConfirm',
         'submitedit', 'delete', 'addContent', 'uploadContent', 'getVersion', 'editContent', 'deleteContent',
         'downloadFile', 'activeRecord', 'deleteFile', 'testMethod','synchToSPPWeb', 'dataExpansion');

        // Load config file
        Configure::load('settings');

        // Setup file upload
        $this->Uploader->uploadDir = 'files/uploads/';
        $this->Uploader->enableUpload = true;
        //$this->Uploader->maxFileSize = '2M';
        $this->Uploader->maxNameLength = 25;
        $this->Uploader->tempDir = TMP;

    
		// check session and role
		if(!$this->isSystemManagement()){
			$this->render('/elements/error');
			return;
		}
		
        if ($this->action == 'index') {
            $this->SppContent->unBindModel(array('hasMany' => array('SppContentFile')));
        }
    }

    function testMethod()
    {
        echo "gf";
        exit;
    }

    /**
     * Get list content and set to layout
     * input
     * output :    content
     */
    function index()
    {
        
        $this->Session->write('system.flag', 0);

        //add url current to session store
        $this->Session->delete('content.url');
        $urlCurrent = $this->params['url']['url'];
        $this->Session->write('content.url', $urlCurrent);

        //get keyword in session store
        $searchkey = $this->Session->read('Search.searchkey');

        if(isset($this->params['url']['delid'])){
        	$delid = $this->params['url']['delid'];
        	if($delid != ""){
        		$this->SppContent->delete($delid,true);// ��Ϣ�ơ��֥����
        		$content_url = $this->Session->read('content.url');
        		$this->redirect('/' . $content_url.'/sppcontent/index');
			}
			$this->set("delid",$delid);
        }
		

        if (isset($_POST['keyword'])) {
            $this->Session->delete('Search.searchkey');
            $this->Session->write('Search.searchkey', $_POST['keyword']);

            $searchkey = $this->Session->read('Search.searchkey');
        }

        $keyword = empty($searchkey) ? '' : $searchkey;
        if (!empty($keyword)) {
            $this->paginate = array(
                'limit' => Configure::read('CONTENT.NUMBER_OF_PAGE'),
                'recursive' => -1,
                'order' => array('SppContent.content_type DESC', 'SppContent.content_code ASC'),
                'conditions' => array(
                    'OR' => array(
                        'SppContent.content_code LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                        'SppContent.content_name LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                        'SppContent.before_purchase_desc LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                        'SppContent.after_purchase_desc LIKE' => "%" . mysql_real_escape_string($keyword) . "%",
                        'SppContent.comment LIKE' => "%" . mysql_real_escape_string($keyword) . "%"
                    )
                ),

            );

        } else {
            $this->paginate = array(
                'limit' => Configure::read('CONTENT.NUMBER_OF_PAGE'),
                'recursive' => -1,
                'order' => array('SppContent.content_type DESC', 'SppContent.content_code ASC'),
            );
        }

        $this->set('keyword', $keyword);
        //$this->SppContent->unBindModel(array('hasMany' => array('SppContentFile')));
        $data = $this->paginate('SppContent');
        foreach ($data as $k => $d) {
            $typeContent = ($d['SppContent']['content_type'] == 1) ? 'set' : 'item';
            $file_update_time = $this->getContentFileByContentID($d['SppContent']['id'], $typeContent);
            $user = $this->SppUser->findById($d['SppContent']['user_id']);
            $data[$k]['SppUser']['user_name'] = $user['SppUser']['user_name'];
            $data[$k]['SppContent']['update_time_file'] = empty($file_update_time[0][0]['update_file_time']) ? '' : $file_update_time[0][0]['update_file_time'];
        }

        $this->set(compact('data'));
        // role user
        $this->set('role_user', $this->role_user);
        // Delete all file store in session
        $this->Session->delete('Upload.File');
        $this->Session->delete('content.Item');
        $this->Session->delete('dataBuff');
    }


    /**
     * Show form add content
     * input
     * output
     */
    function add()
    {
        //start process flag 
        $flag = $this->Session->read('system.flag');
        if (empty($flag)) {
            $this->deleteTemp();
        }
        $this->Session->write('system.flag', 0);
        //end

        //empty tem in session store if the first to page 
        if (empty($_GET['new'])) {
            $data = $this->Session->read('selectcontent.databuffer');
            $this->set('data', $data);
        }
        

        //get string id of content in session stores
        $contentids = $this->Session->read('selectcontent.contentid');
        
        //intalize $contents
        $contents = array();

        if (!empty($contentids)) {
            //get contents listing by $contentid
            $contents = $this->getContentByIds($contentids);
            foreach ($contents as $k => $d) {
                $file_update_time = $this->getContentFileByContentID($d['SppContent']['id'], 'item');
                $contents[$k]['SppContent']['updated_datetime'] = empty($file_update_time[0][0]['update_file_time']) ? '' : $file_update_time[0][0]['update_file_time'];
            }
        }

        $content_url = $this->Session->read('content.url');
        $this->set('content_url', '/' . $content_url);

        $this->set('contents', $contents);
    }

    /**
     * Show form edit content
     * input
     * output
     */
    function edit()
    {
        
        $this->set('role_user', $this->role_user);

        //#6381
        if (!empty($_GET['id'])) {
            $this->SppContent->id = (int)$_GET['id'];
        }

        $contentItem = $this->SppContent->read();

        //start process flag 
        $flag = $this->Session->read('system.flag');


        if (empty($flag)) {
            $this->deleteTemp();
            $contentids = $this->getContentItem($this->SppContent->id);
        } else {
            $contentids = $this->Session->read('selectcontent.contentid');
            $databuffer = $this->Session->read('selectcontent.databuffer');
            $this->set('databuffer', $databuffer);

        }
        $this->Session->write('system.flag', 0);
        //end

        //intalize $contents
        $contents = array();
        if (!empty($contentids)) {
            //get contents listing by $contentid
            $contents = $this->getContentByIds($contentids);
            foreach ($contents as $k => $d) {
                $file_update_time = $this->getContentFileByContentID($d['SppContent']['id'], 'item');
                $contents[$k]['SppContent']['updated_datetime'] = empty($file_update_time[0][0]['update_file_time']) ? '' : $file_update_time[0][0]['update_file_time'];
            }
            $this->Session->write('selectcontent.contentid', $contentids);
        }

        $content_url = $this->Session->read('content.url');
        $this->set('content_url', '/' . $content_url);

        $this->set('contents', $contents);
        $this->set('contentItem', $contentItem);
    }

    /**
     * Update content
     * input    array | POST
     * output
     */

    function submitedit()
    {
        $this->Session->delete('selectcontent.databuffer');
        $this->Session->write('selectcontent.databuffer', $this->data);

        $this->loadModel('SppContentItem');
        $contentids = $this->Session->read('selectcontent.contentid');
        $contentids = explode(',', $contentids);
        $version = $this->getVersionContent($_POST['id']);
        $version_flag = $this->Session->read('system.version_update_flag');
        if (!empty($version_flag)) {
            $this->data['SppContent']['version'] = $version + 1;
        }
        $this->data['SppContent']['sale_start_date'] = str_replace('/', '-', $this->data['SppContent']['sale_start_date']);
        $this->data['SppContent']['sale_end_date'] = str_replace('/', '-', $this->data['SppContent']['sale_end_date']);

        if (empty($this->data['SppContent']['content_name'])) {
            //set flag
            $this->Session->write('system.flag', 1);
            $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_NAME'));
            $this->redirect(array('action' => 'edit', '?' => array('id' => $_POST['id'])));
        }

        if (strlen($this->data['SppContent']['content_name']) > 256) {
            //set flag
            $this->Session->write('system.flag', 1);
            $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_NAME_LENGTH'));
            $this->redirect(array('action' => 'edit', '?' => array('id' => $_POST['id'])));
        }

        if (strtotime($this->data['SppContent']['sale_start_date']) > strtotime($this->data['SppContent']['sale_end_date'])) {
            //set flag
            $this->Session->write('system.flag', 1);

            $this->Session->setFlash(Configure::read('Message.ERR_DATE'));
            $this->redirect(array('action' => 'edit', '?' => array('id' => $_POST['id'])));
        }

        if (strlen($this->data ['SppContent'] ['before_purchase_desc']) > 2000) {
            $this->Session->write('system.flag', 1);
            $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_BEFOR_LENGTH'));
            $this->redirect(array('action' => 'edit', '?' => array('id' => $_POST['id'])));
        }

        if (strlen($this->data ['SppContent'] ['after_purchase_desc']) > 2000) {
            $this->Session->write('system.flag', 1);
            $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_AFTER_LENGTH'));
            $this->redirect(array('action' => 'edit', '?' => array('id' => $_POST['id'])));
        }

        if (empty($this->data['SppContent']['before_purchase_desc'])) {
            //set flag
            $this->Session->write('system.flag', 1);

            $this->Session->setFlash(Configure::read('Message.ERR_BEFORE_DESC'));
            $this->redirect(array('action' => 'edit', '?' => array('id' => $_POST['id'])));
        }

        if (empty($this->data['SppContent']['after_purchase_desc'])) {
            //set flag
            $this->Session->write('system.flag', 1);

            $this->Session->setFlash(Configure::read('Message.ERR_AFTER_DESC'));
            $this->redirect(array('action' => 'edit', '?' => array('id' => $_POST['id'])));
        }

        $this->data['SppContent']['id'] = (int)$_POST['id'];
        if (!isset($this->data['SppContent']['builtin_flag'])) {
            $this->data['SppContent']['builtin_flag'] = 0;
        }

        if (!isset($this->data['SppContent']['license_flag'])) {
            $this->data['SppContent']['license_flag'] = 0;
        }

        if (!isset($this->data['SppContent']['store_flag'])) {
            $this->data['SppContent']['store_flag'] = 0;
        }
        if (empty($this->data['SppContent']['store_flag']) && empty($this->data['SppContent']['license_flag']) 
        	&& empty($this->data['SppContent']['builtin_flag']) && empty($this->data['SppContent']['subscribe_flag'])) {
            //set flag
            $this->Session->write('system.flag', 1);
            $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_CHECK'));
            $this->redirect(array('action' => 'edit', '?' => array('id' => $_POST['id'])));
        }

        $this->data['SppContent']['created_datetime'] = date('Y-m-d H:i:s');
        $this->data['SppContent']['updated_datetime'] = date('Y-m-d H:i:s');

        $session = $this->Session->read();
        $this->data['SppContent']['user_id'] = $session['Auth']['SppUser']['id'];

        // Begin transaction
        $this->SppContent->begin();

        try {
            if ($this->SppContent->save($this->data)) {
                $this->SppContentItem->deleteAll(array('SppContentItem.content_id' => $this->data['SppContent']['id']));

                //add content item
                if (count($contentids)) {
                    foreach ($contentids as $coid) {
                        if (!empty($coid)) {
                            $this->data['SppContentItem']['content_id'] = $this->data['SppContent']['id'];
                            $this->data['SppContentItem']['child_content_id'] = $coid;
                            $this->data['SppContentItem']['id'] = 0;
                            $this->SppContentItem->save($this->data);
                        }
                    }
                }
                $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_UPDATED'));
            }

            // Commit transaction
            $this->SppContent->commit();

            //empty temp in session store
            $this->deleteTemp();
            $content_url = $this->Session->read('content.url');
            $this->redirect('/' . $content_url);
        } catch (Exception $e) {
            $this->SppContent->rollback();
            $this->Session->write('system.flag', 1);

            $this->Session->setFlash(Configure::read('Message.ERR_EXCEPTION'));
            $this->redirect(array('action' => 'edit', '?' => array('id' => $_POST['id'])));
        }


    }


    /**
     * add new license
     * input    array | POST
     * output
     */
    function submitadd()
    {
        
        $this->loadModel('SppContentItem');

        $this->Session->delete('selectcontent.databuffer');
        $this->Session->write('selectcontent.databuffer', $this->data);

        //check validation
        if (empty($this->data['SppContent']['content_code'])) {
            $this->Session->write('system.flag', 1);
            $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_CODE'));
            $this->redirect(array('action' => 'add'));
        }

        if ($this->CheckContentCodeExits($this->data['SppContent']['content_code'])) {
            //set flag
            $this->Session->write('system.flag', 1);

            $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_CODE_EXITS'));
            $this->redirect(array('action' => 'add'));
        }
        if (preg_match("/^[0-9a-zA-Z-_]*$/", $this->data['SppContent']['content_code']) === 0) {
            $this->Session->write('system.flag', 1);

            $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_CODE_RULE'));
            $this->redirect(array('action' => 'add'));
        }

        if (strlen($this->data['SppContent']['content_code']) > 32) {
            //set flag
            $this->Session->write('system.flag', 1);
            $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_CODE_LENGTH'));
            $this->redirect(array('action' => 'add'));
        }

        if (strlen($this->data['SppContent']['content_name']) > 256) {
            //set flag
            $this->Session->write('system.flag', 1);
            $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_NAME_LENGTH'));
            $this->redirect(array('action' => 'add'));
        }

        if (empty($this->data['SppContent']['content_name'])) {
            //set flag
            $this->Session->write('system.flag', 1);

            $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_NAME'));
            $this->redirect(array('action' => 'add'));
        }

        if (strtotime($this->data['SppContent']['sale_start_date']) > strtotime($this->data['SppContent']['sale_end_date'])) {
            //set flag
            $this->Session->write('system.flag', 1);

            $this->Session->setFlash(Configure::read('Message.ERR_DATE'));
            $this->redirect(array('action' => 'add'));
        }

        if (empty($this->data['SppContent']['before_purchase_desc'])) {
            //set flag
            $this->Session->write('system.flag', 1);

            $this->Session->setFlash(Configure::read('Message.ERR_BEFORE_DESC'));
            $this->redirect(array('action' => 'add'));
        }

        if (empty($this->data['SppContent']['after_purchase_desc'])) {
            //set flag
            $this->Session->write('system.flag', 1);

            $this->Session->setFlash(Configure::read('Message.ERR_AFTER_DESC'));
            $this->redirect(array('action' => 'add'));
        }

        if (strlen($this->data ['SppContent'] ['before_purchase_desc']) > 2000) {
            $this->Session->write('system.flag', 1);
            $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_BEFOR_LENGTH'));
            //$this->redirect(array('action' => 'edit','?'=>array('id'=>$_POST['id'])));
            $this->redirect(array('action' => 'add'));
        }

        if (strlen($this->data ['SppContent'] ['after_purchase_desc']) > 2000) {
            $this->Session->write('system.flag', 1);
            $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_AFTER_LENGTH'));
            //$this->redirect(array('action' => 'edit','?'=>array('id'=>$_POST['id'])));
            $this->redirect(array('action' => 'add'));
        }

        $contentids = $this->Session->read('selectcontent.contentid');
        if (!empty($contentids)) {
            $contentids = explode(',', $contentids);
        }

        if (empty($this->data['SppContent']['store_flag']) 
        	&& empty($this->data['SppContent']['license_flag']) 
        	&& empty($this->data['SppContent']['subscribe_flag'])) {
            //set flag
            $this->Session->write('system.flag', 1);
            $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_CHECK'));
            $this->redirect(array('action' => 'add', false));
            return;
        }

        $this->data['SppContent']['id'] = 0;
        $this->data['SppContent']['content_type'] = 1;
        $this->data['SppContent']['active_flag'] = 0;
        $this->data['SppContent']['version'] = 1;
        $this->data['SppContent']['sale_start_date'] = str_replace('/', '-', $this->data['SppContent']['sale_start_date']);
        $this->data['SppContent']['sale_end_date'] = str_replace('/', '-', $this->data['SppContent']['sale_end_date']);
        $this->data['SppContent']['created_datetime'] = date('Y-m-d H:i:s');
        $this->data['SppContent']['updated_datetime'] = date('Y-m-d H:i:s');
        
        $session = $this->Session->read();
        $this->data['SppContent']['user_id'] = $session['Auth']['SppUser']['id'];

        // Begin transaction
        $this->SppContent->begin();
        try {
            if ($this->SppContent->save($this->data)) {
                //add content item
                if (count($contentids)) {
                    foreach ($contentids as $coid) {
                        if (!empty($coid)) {
                            $this->data['SppContentItem']['content_id'] = $this->SppContent->id;
                            $this->data['SppContentItem']['child_content_id'] = $coid;
                            $this->data['SppContentItem']['id'] = 0;
                            //add to table license content
                            $this->SppContentItem->save($this->data);
                        }
                    }
                } else {
                    $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_ADDED'));
                }
            }
            // Commit transaction
            $this->SppContent->commit();
            //empty temp in session store
            $this->deleteTemp();
            $content_url = $this->Session->read('content.url');
            $this->redirect('/' . $content_url);
        } catch (Exception $e) {
            // Rollback transaction
            $this->SppContent->rollback();
            $this->Session->write('system.flag', 1);

            $this->Session->setFlash(Configure::read('Message.ERR_EXCEPTION'));
            $this->redirect(array('action' => 'edit', '?' => array('id' => $_POST['id'])));
        }

    }

    function getVersionContent($id = 0)
    {
        $this->SppContent->id = $id;
        $contentItem = $this->SppContent->read('SppContent.version');
        return (int)$contentItem['SppContent']['version'];
    }

    /**
     * update active flag of content to session store
     * input int|$id this is id of content set
     * output
     */
    function active($id = 0)
    {
        if (isset($_POST['controller'])) {

            if (!empty($_POST['id'])) {
                $url = array('controller' => $_POST['controller'], 'action' => $_POST['action'], '?' => array('id' => $_POST['id']));
            } else {
                $url = array('controller' => $_POST['controller'], 'action' => $_POST['action']);
            }
            $this->Session->delete('selectcontent.url');
            $this->Session->write('selectcontent.url', $url);

            $this->Session->delete('selectcontent.databuffer');
            $this->Session->write('selectcontent.databuffer', $this->data);
        } else {
            $url = Dispatcher::baseUrl();
        }
        $this->Session->write('system.active_flag', 1);
        $this->Session->write('system.flag', 1);
        $this->redirect($url);

    }


    /**
     * Delete content
     * input    id of content
     * output
     */

    function delete()
    {
        
        $this->loadModel('SppContentItem');
        $id = empty($_GET['id']) ? 0 : $_GET['id'];

        // Begin transaction
        $this->SppContent->begin();
        try {
            $this->SppContentItem->deleteAll(array('SppContentItem.content_id' => $id));
            $this->SppContent->delete($id);
            $this->SppContent->commit();
            $this->Session->setFlash(Configure::read('Message.ERR_CONTENT_DELETED'));
            //empty temp in session store
            $this->deleteTemp();

            $content_url = $this->Session->read('content.url');
            $this->redirect('/' . $content_url);
        } catch (Exception $e) {
            $this->SppContent->rollback();
            $this->Session->setFlash(Configure::read('Message.ERR_EXCEPTION'));
            //empty temp in session store
            $this->deleteTemp();

            $content_url = $this->Session->read('content.url');
            $this->redirect('/' . $content_url);
        }
    }

    /**
     * Get list content to select
     * input
     * output :    license
     */
    function contentselect()
    {
        if (isset($_POST['controller'])) {
            if (!empty($_POST['id'])) {
                $url = array('controller' => $_POST['controller'], 'action' => $_POST['action'], '?' => array('id' => $_POST['id']));
            } else {
                if ($_POST['action'] == 'edit') {
                    $url = array('controller' => $_POST['controller'], 'action' => $_POST['action'], '?' => array('edittype' => 2));
                } else {
                    $url = array('controller' => $_POST['controller'], 'action' => $_POST['action']);
                }
            }

            $this->Session->delete('selectcontent.url');
            $this->Session->write('selectcontent.url', $url);

            $this->Session->delete('selectcontent.databuffer');
            $this->Session->write('selectcontent.databuffer', $this->data);
            $this->set('url', $url);
        } else {
            $url = Dispatcher::baseUrl();
        }

        $contentids = $this->Session->read('selectcontent.contentid');

        //if select from content page
        if (@$_POST['controller'] == 'sppcontent') {
            /*#23132
            if(!empty($_POST['id'])){
                if(!empty($contentids)){
                    $contentids.=','.(int)$_POST['id'];
                }else{
                    $contentids=(int)$_POST['id'];
                }
            }*/

            //get listing id skip
            //$idskip=$this->getContentItemIds($contentids);
            $this->set('page', 'content');
            /* $this->paginate = array(
                     'conditions' => array(
                         'AND' => array(
                                 'UNIX_TIMESTAMP(SppContent.sale_end_date) >= ' => strtotime('now'),
                                 'UNIX_TIMESTAMP(SppContent.sale_start_date) <= ' => strtotime('now'),
                                 'SppContent.content_type != ' => 1),
                         //'NOT' => array(
                            //     'SppContent.id' => $idskip)
                         ),
                     'recursive' => -1
                     );*/
            $data = $this->SppContent->find('all', array(
                'conditions' => array(
                    'AND' => array(
                        'SppContent.sale_end_date >= ' => date('Y-m-d'),
                        'SppContent.sale_start_date <= ' => date('Y-m-d'),
                        'SppContent.content_type != ' => 1,
                        'OR' => array(
                            'SppContent.license_flag' => 1,
                            'SppContent.store_flag' => 1,
                        ),

                    ),


                    //'NOT' => array(
                    //     'SppContent.id' => $idskip)
                ),
                'order' => array('SppContent.content_code ASC'),
                'recursive' => -1,
            ));
        } else {
            /*#23132
            if(!empty($_POST['id'])){
                if(!empty($contentids)){
                    $contentids.=','.(int)$_POST['id'];
                }else{
                    $contentids=(int)$_POST['id'];
                }
            }*/

            //get listing id skip
            //$idskip=$this->getContentLicenseIds($contentids);

            $this->set('page', 'license');
            //if select from license page
            $data = $this->SppContent->find('all', array(
                'conditions' => array('SppContent.license_flag =1 '),
                'recursive' => -1,
                'order' => array('SppContent.content_code ASC'),
            ));
            // $this->paginate = $this->SppContent->find('all','conditions' => array('SppContent.license_flag =1 '),'recursive' => -1);
        }


        if (!empty($contentids)) {
            $contentids = explode(',', $contentids);
        } else {
            $contentids = array();
        }
        //$data = $this->paginate('SppContent');

        foreach ($data as $k => $d) {
            $typeContent = ($d['SppContent']['content_type'] == 1) ? 'set' : 'item';
            $file_update_time = $this->getContentFileByContentID($d['SppContent']['id'], $typeContent);
            $user = $this->SppUser->findById($d['SppContent']['user_id']);
            $data[$k]['SppUser']['user_name'] = $user['SppUser']['user_name'];
            $data[$k]['SppContent']['update_time_file'] = empty($file_update_time[0][0]['update_file_time']) ? '' : $file_update_time[0][0]['update_file_time'];
        }

        $this->Session->write('system.flag', 1);
        $this->set('contentids', $contentids);

        $this->set(compact('data'));

    }

    /**
     * add list content id to session store
     * input
     * output
     */
    function getlistid()
    {
        $contentidold = $this->Session->read('selectcontent.contentid');
        if (!empty($contentidold)) {
            $contentidold_array = explode(',', $contentidold);
        } else {
            $contentidold_array = array();
        }
        if (count($_POST['contentid'])) {
            $contentid_array = array_merge($contentidold_array, $_POST['contentid']);
            $contentid = implode(',', $contentid_array);
            $this->Session->delete('selectcontent.contentid');
            $this->Session->write('selectcontent.contentid', $contentid);
        }

        //get url
        $url = $this->Session->read('selectcontent.url');
        $this->Session->write('system.flag', 1);
        $this->Session->write('system.version_update_flag', 1);
        $this->redirect($url);
    }


    //Show dialog confirm
    function dialogConfirm()
    {
        $this->Session->write('system.flag', 1);
        $this->render('/elements/dialogconfirm');
    }


    /**
     * Empty session store
     * input
     * output
     */
    function deleteTemp()
    {
        $this->Session->delete('selectcontent.url');
        $this->Session->delete('selectcontent.databuffer');
        $this->Session->delete('selectcontent.contentid');
        $this->Session->delete('system.active_flag');
        $this->Session->delete('system.version_update_flag');

        // Delete all file store in session
        $this->Session->delete('Upload.File');
        $this->Session->delete('content.Item');
        $this->Session->delete('dataBuff');
    }

    /**
     * Get listing contentid by content set id
     * input int $contentid| string|$type return listing id with type string if type is string else return array
     * output array|string
     */
    function getContentItem($contentid = 0, $type = 'string')
    {
        $this->loadModel('SppContentItem');
        $content_license = $this->SppContentItem->find('all', array(
            'conditions' => array('SppContentItem.content_id' => $contentid),
            'recursive' => -1,
        ));
        $content_license_id = array();
        foreach ($content_license as $cl) {
            $content_license_id[] = $cl['SppContentItem']['child_content_id'];
        }

        if ($type == 'string') {
            $content_license_ids = implode(',', $content_license_id);
        } else {
            $content_license_ids = $content_license_id;
        }

        return $content_license_ids;
    }

    /**
     * Get content by ids
     * input string $ids | ex: 1,4,5,12,3,6
     * output array
     */
    function getContentByIds($ids = '')
    {
        $contents = $this->SppContent->find('all', array(
            'conditions' => array('SppContent.id IN (' . $ids . ')'),
            'order' => array('SppContent.content_code ASC'),
            'recursive' => -1
        ));
        foreach ($contents as $k => $d) {

            $user = $this->SppUser->findById($d['SppContent']['user_id']);
            $contents[$k]['SppUser']['user_name'] = $user['SppUser']['user_name'];
        }
        return $contents;
    }

    /**
     * Check content code exits
     * input string $contentcode
     * output true if content code is exits else return false
     */
    function CheckContentCodeExits($contentcode = '')
    {

        $license = $this->SppContent->find('all', array('conditions' => array('SppContent.content_code="' . $contentcode . '"'),
            'recursive' => -1
        ));

        if (!empty($license[0]['SppContent']['id'])) {
            return true;
        }
        return false;
    }


    /**
     * Get content license by license id
     * input int $licenseid
     * output array | listing content licenses result
     */
    function getContentLicenseIds($contentids)
    {
        $this->loadModel('SppLicenseContent');
        if (!empty($contentids)) {
            $content_license = $this->SppLicenseContent->find('all', array(
                'conditions' => array('SppLicenseContent.license_id NOT IN (' . $contentids . ')'),
                'fields' => array('SppLicenseContent.content_id')
            ));
        } else {
            $content_license = $this->SppLicenseContent->find('all');
        }
        //$content_license=$this->query('select content_id from spp_license_contents');
        $content_license_id = array();
        foreach ($content_license as $cl) {
            $content_license_id[] = $cl['SppLicenseContent']['content_id'];
        }

        return $content_license_id;
    }


    /**
     * Get content item by content id
     * input int $content_id
     * output array | listing content items result
     */
    function getContentItemIds($contentids)
    {
        $this->loadModel('SppContentItem');
        if (!empty($contentids)) {
            $content_license = $this->SppContentItem->find('all', array(
                'conditions' => array('SppContentItem.content_id NOT IN (' . $contentids . ')')
            ));
        } else {
            $content_license = $this->SppContentItem->find('all');
        }

        $content_license_id = array();
        foreach ($content_license as $cl) {
            $content_license_id[] = $cl['SppContentItem']['child_content_id'];
        }

        return $content_license_id;
    }

    /**
     * Get content by id listing
     * input int | $id
     * output string | maximum update_datetime
     */
    function getContentFileByContentID($id = 0, $type = 'set')
    {
        if ($type == 'set')
            $ids = $this->getContentItem($id);
        else
            $ids = $id;
        if (!empty($ids)) {
            $this->loadModel('SppContentFile');
            $update_file_time = $this->SppContentFile->find('all', array(
                'conditions' => array('SppContentFile.content_id in (' . $ids . ')'),
                'fields' => array('max(SppContentFile.updated_datetime) as update_file_time')
            ));
            //$contents=$this->query('select max(updated_datetime) as update_file_time from spp_content_files  where id  = '.$id);
        } else {
            $file_update_time = array();
            @$file_update_time[0][0]['update_file_time'] = '';
            //$update_file_time='';
        }

        /*if($id==55){
            echo $ids;
            var_dump($update_file_time);die;
            }*/
        return @$update_file_time;
    }

    /**
     * Binhtt
     */
    function addContent()
    {
    	if (!empty($this->data)) {
    		//check validation
    		$this->Session->write('dataBuff', $this->data);
    		if (empty($this->data['SppContent']['content_code'])) {
    			$this->Session->setFlash(Configure::read('Message.ERR_CONTENT_CODE'));
    			$this->redirect($this->referer());
    		}
    		if ($this->CheckContentCodeExits($this->data['SppContent']['content_code'])) {
    			$this->Session->setFlash(Configure::read('Message.ERR_CONTENT_CODE_EXITS'));
    			$this->redirect($this->referer());
    		}

    		if (preg_match("/^[0-9a-zA-Z-_]*$/", $this->data['SppContent']['content_code']) === 0) {
    			$this->Session->setFlash(Configure::read('Message.ERR_CONTENT_CODE_RULE'));
    			$this->redirect($this->referer());
    		}

    		if (strlen($this->data['SppContent']['content_code']) > 32) {
    			$this->Session->setFlash(Configure::read('Message.ERR_CONTENT_CODE_LENGTH'));
    			$this->redirect($this->referer());
    		}

    		if (empty($this->data['SppContent']['content_name'])) {
    			$this->Session->setFlash(Configure::read('Message.ERR_CONTENT_NAME'));
    			$this->redirect($this->referer());
    		}

    		if (strlen($this->data['SppContent']['content_name']) > 256) {
    			//echo 123;die;#6380
    			$this->Session->setFlash(Configure::read('Message.ERR_CONTENT_NAME_LENGTH'));
    			$this->redirect($this->referer());
    		}

    		if (strtotime($this->data['SppContent']['sale_start_date']) > strtotime($this->data['SppContent']['sale_end_date'])) {
    			$this->Session->setFlash(Configure::read('Message.ERR_DATE'));
    			$this->redirect($this->referer());
    		}

    		if (strlen($this->data['SppContent']['before_purchase_desc']) > 2000) {
    			$this->Session->setFlash(Configure::read('Message.ERR_CONTENT_BEFOR_LENGTH'));
    			$this->redirect($this->referer());
    		}

    		if (strlen($this->data['SppContent']['after_purchase_desc']) > 2000) {
    			$this->Session->setFlash(Configure::read('Message.ERR_CONTENT_AFTER_LENGTH'));
    			$this->redirect($this->referer());
    		}

    		if (empty($this->data['SppContent']['before_purchase_desc'])) {
    			$this->Session->setFlash(Configure::read('Message.ERR_BEFORE_DESC'));
    			$this->redirect($this->referer());
    		}

    		if (empty($this->data['SppContent']['after_purchase_desc'])) {
    			$this->Session->setFlash(Configure::read('Message.ERR_AFTER_DESC'));
    			$this->redirect($this->referer());
    		}

    		if (empty($this->data['SppContent']['builtin_flag']) && empty($this->data['SppContent']['license_flag']) 
    			&& empty($this->data['SppContent']['store_flag']) && empty($this->data['SppContent']['subscribe_flag'])) {
    			$this->Session->setFlash(Configure::read('Message.ERR_CONTENT_CHECK'));
    			$this->redirect($this->referer());
    		}
    		
    		$this->data['SppContent']['content_type'] = 0;
    		$this->data['SppContent']['active_flag'] = 0;
    		$this->data['SppContent']['sale_start_date'] = str_replace('/', '-', $this->data['SppContent']['sale_start_date']);
    		$this->data['SppContent']['sale_end_date'] = str_replace('/', '-', $this->data['SppContent']['sale_end_date']);
    		$this->data['SppContent']['created_datetime'] = date('Y-m-d H:i:s');
    		$this->data['SppContent']['updated_datetime'] = date('Y-m-d H:i:s');
    		$this->data['SppContent']['version'] = null;
    		$this->data['SppContent']['user_id'] = $this->Session->read('Auth.SppUser.id');

    		if (is_uploaded_file($this->data['SppContent']['content_file']['tmp_name']) == false) {
    			$this->Session->setFlash(Configure::read('Message.ERR_UPLOAD_FILE'));
    			$this->redirect($this->referer());
    		}

    		$fileData = file_get_contents($this->data['SppContent']['content_file']['tmp_name']);
    		

      //       /*
      //       *
      //       *
      //       *
      //       * @updated 2019.01.24
      //        */

      //       $content_base64 = '';
      //       $arrayImage = [];
    		// if(move_uploaded_file($this->data['SppContent']['content_file']['tmp_name'],
    		//  TMP)) {

    		   
    		// }else
      //       {
      //           $this->Session->setFlash(Configure::read('Message.ERR_MOVE_FILE'));
      //           $this->redirect($this->referer());
      //       }

    		// Begin transaction
    		$this->SppContent->begin();

    		try {
    			if (!empty($fileData) && $this->SppContent->save($this->data)) {
    				$contentId = $this->SppContent->getInsertId();
    				// create record content file
    				$this->SppContentFile->create();
    				$upload = array();

    				$upload['SppContentFile']['before_download_desc'] = '';
    				$upload['SppContentFile']['file_name'] = $this->data['SppContent']['content_file']['name'];
    				$upload['SppContentFile']['file_size'] = $this->data['SppContent']['content_file']['size'];
    				$upload['SppContentFile']['file_content'] = $fileData;
    				$upload['SppContentFile']['active_flag'] = 0;
    				$upload['SppContentFile']['version'] = 0; // Coz content didn't active
    				$upload['SppContentFile']['created_datetime'] = date('Y-m-d H:i:s');
    				$upload['SppContentFile']['updated_datetime'] = date('Y-m-d H:i:s');
    				$upload['SppContentFile']['user_id'] = $this->Session->read('Auth.SppUser.id');
    				$upload['SppContentFile']['content_id'] = $contentId;
    				if ($this->SppContentFile->save($upload)) {
    					//Commit transaction
    					$this->SppContent->commit();
    					$this->Session->delete('dataBuff');
    					//$this->redirect(array('action' => 'index'));
    					$this->Session->setFlash(Configure::read('Message.ADD_SUCCESS'));
    					$content_url = $this->Session->read('content.url');
    					$this->Session->delete('content.url');
    					$this->redirect('/' . $content_url);
    				}
    			} else {
    				$this->Session->setFlash(Configure::read('Message.ERR_UPLOAD_FILE'));
    				$this->redirect($this->referer());
    			}
    		} catch (Exception $e) {
    			$this->SppContent->rollback();
    			$this->Session->setFlash(Configure::read('Message.ERR_EXCEPTION'));
    			$this->redirect($this->referer());
    		}

    	} else {
    		//echo "upload data faild";
    		$this->set('data', $this->Session->read('dataBuff'));
    		$this->Session->delete('dataBuff');
    	}

    }

    function editContent($id = NULL)
    {
    	$this->SppContent->id = $id;
    	$tmp = $this->Auth->user();
		if ($tmp['SppUser']['user_name'] == Configure::read('User.WEBADMIN')) {
			$this->set('is_web_admin', true);
		} else {
			$this->set('is_web_admin', false);
		}
    	if (!empty($this->data)) { 
    		if (!empty($this->data['SppContent']['builtin_flag']) && $this->data['SppContent']['builtin_flag'] == 1) {
    			$this->data['SppContent']['builtin_flag'] = 1;
    		} else {
    			$this->data['SppContent']['builtin_flag'] = 0;
    		}
    		if (!empty($this->data['SppContent']['license_flag']) && $this->data['SppContent']['license_flag'] == 1) {
    			$this->data['SppContent']['license_flag'] = 1;
    		} else {
    			$this->data['SppContent']['license_flag'] = 0;
    		}
    		if (!empty($this->data['SppContent']['store_flag']) && $this->data['SppContent']['store_flag'] == 1) {
    			$this->data['SppContent']['store_flag'] = 1;
    		} else {
    			$this->data['SppContent']['store_flag'] = 0;
    		}
    		$this->Session->write('content.Item', $this->data);
    		//check validation
    		$contentId = $this->Session->read('editContent.Id');
    		$this->Session->delete('editContent.Id');
    		if (empty($this->data['SppContent']['content_name'])) {
    			$this->Session->setFlash(Configure::read('Message.ERR_CONTENT_NAME'));
    			$this->redirect(array('action' => 'editContent', $contentId));
    		}

    		if (strlen($this->data['SppContent']['content_name']) > 256) {
    			$this->Session->setFlash(Configure::read('Message.ERR_CONTENT_NAME_LENGTH')); //#6382
    			$this->redirect($this->referer());
    		}

    		if (strtotime($this->data['SppContent']['sale_start_date']) > strtotime($this->data['SppContent']['sale_end_date'])) {
    			$this->Session->setFlash(Configure::read('Message.ERR_DATE'));
    			$this->redirect(array('action' => 'editContent', $contentId));
    		}

    		if (empty($this->data['SppContent']['before_purchase_desc'])) {
    			$this->Session->setFlash(Configure::read('Message.ERR_BEFORE_DESC'));
    			$this->redirect(array('action' => 'editContent', $contentId));
    		}

    		if (empty($this->data['SppContent']['after_purchase_desc'])) {
    			$this->Session->setFlash(Configure::read('Message.ERR_AFTER_DESC'));
    			$this->redirect(array('action' => 'editContent', $contentId));
    		}

    		if (strlen($this->data['SppContent']['before_purchase_desc']) > 2000) {
    			$this->Session->setFlash(Configure::read('Message.ERR_CONTENT_BEFOR_LENGTH'));
    			$this->redirect($this->referer());
    		}

    		if (strlen($this->data['SppContent']['after_purchase_desc']) > 2000) {
    			$this->Session->setFlash(Configure::read('Message.ERR_CONTENT_AFTER_LENGTH'));
    			$this->redirect($this->referer());
    		}

    		if (empty($this->data['SppContent']['builtin_flag']) 
    			&& empty($this->data['SppContent']['license_flag']) 
    			&& empty($this->data['SppContent']['store_flag'])
    			&& empty($this->data['SppContent']['subscribe_flag'])) {
    			$this->Session->setFlash(Configure::read('Message.ERR_CONTENT_CHECK'));
    			$this->redirect(array('action' => 'editContent', $contentId));
    		}
    		$content = $this->SppContent->findById($contentId);


    		if (!empty($content)) {
    			$data = $this->data; 
    			$this->data = $content;
    			// Validation
    			$this->data['SppContent']['content_name'] = $data['SppContent']['content_name'];
    			$this->data['SppContent']['sale_start_date'] = $data['SppContent']['sale_start_date'];
    			$this->data['SppContent']['sale_end_date'] = $data['SppContent']['sale_end_date'];
    			$this->data['SppContent']['before_purchase_desc'] = $data['SppContent']['before_purchase_desc'];
    			$this->data['SppContent']['after_purchase_desc'] = $data['SppContent']['after_purchase_desc'];
    			$this->data['SppContent']['comment'] = $data['SppContent']['comment'];
    			$this->data['SppContent']['update_datetime'] = date('Y-m-d H:i:s');

    			$this->data['SppContent']['builtin_flag'] = $data['SppContent']['builtin_flag'];
    			$this->data['SppContent']['license_flag'] = $data['SppContent']['license_flag'];
    			$this->data['SppContent']['store_flag'] = $data['SppContent']['store_flag'];
    			$this->data['SppContent']['subscribe_flag'] = (isset($data['SppContent']['subscribe_flag'])) ? $data['SppContent']['subscribe_flag'] : '';
    			$this->data['SppContent']['update_type'] = $data['SppContent']['update_type'];
    			// Begin transaction
    			$this->SppContent->begin();

    			try {
    				if ($this->SppContent->save($this->data)) {
    					// active record
    					$active = $data['SppContent']['active_record'];
    					$session = $this->Session->read('Upload.File');

    					$this->Session->delete('Upload.File');

    					if (!empty($session)) {
    						$this->Pass4v->accessLog($this->name, "Info", "(".__FUNCTION__."),delete recode:".$data['SppContent']['delete_record'], $referer, $_SERVER['HTTP_USER_AGENT']);
    						 
    						// Delete record in session and in database
    						if (!empty($data['SppContent']['delete_record'])) {
    							// delete record
    							$deletes = substr($data['SppContent']['delete_record'], 0, strlen($data['SppContent']['delete_record']) - 1);
    							$deletes = explode(',', $deletes);
    							foreach ($deletes as $del) {
    								foreach ($session as $key => $sess) {
    									//debug($sess);
    									if ($del == $sess['id']) {
    										unset($session[$key]);

    									} else {
    										$this->Pass4v->accessLog($this->name, "Info", "(".__FUNCTION__."),delete del:".$del, $referer, $_SERVER['HTTP_USER_AGENT']);
    										$this->SppContentFile->delete($del);
    									}
    								}
    							}
    						}
    						if (!empty($active)) {
    							$isActived = false;
    							foreach ($session as $key => $sess) {
    								if ($active == $sess['id']) {
    									$session[$key]['active_flag'] = 1;

    									$this->_increaseVersion($contentId);
    									$version = $this->_getSessionVersion($session[$key]['content_id']);
    									if ($version == 0) {
    										$version = 1;
    									}
    									$session[$key]['version'] = $version;
    									$isActived = true;
    								}
    							}
    							// unactive all record relate with content id
    							$this->SppContentFile->updateAll(array('SppContentFile.active_flag' => 0), array('SppContentFile.content_id = ' => $contentId));
    							if ($isActived == false) {
    								$this->SppContentFile->updateAll(array('SppContentFile.active_flag' => 1), array('SppContentFile.id = ' => $active));
    								/**
    								 * TODO: Increase version of content
    								 */
    								$this->_increaseVersion($contentId);
    								$this->_increaseFileVersion($active);
    							}
    						}
    						// insert record from session to databse
    						//debug($session);die;
    						foreach ($session as $key => $rec) {
    							unset($rec['id']);
    							$this->SppContentFile->create();
    							$fileData = file_get_contents($this->Uploader->uploadDir . $rec['file_name']);

    							//$filePath = $this->Uploader->uploadDir . $rec['file_name'];

    							$rec['file_content'] = $fileData;
    							//#19138
    							$rec['file_name'] = $rec['file_name_old'];
    							$this->SppContentFile->save($rec);
    							/*
    							 $result = $this->syncContent($content['SppContent']['content_code']);

    							 if(!$result){
    							 $this->Session->setFlash(Configure::read('Message.ERR_UPDATE_CONTENT_ON_WEB_APP'));
    							 }*/

    						}
    						$this->Session->delete('Upload.File');

    					} else {
    						if (!empty($active)) {
    							// unactive all record relate with content id
    							$this->SppContentFile->updateAll(array('SppContentFile.active_flag' => 0), array('SppContentFile.content_id = ' => $contentId));

    							$this->SppContentFile->updateAll(array('SppContentFile.active_flag' => 1), array('SppContentFile.id = ' => $active));

    							/**
    							 * TODO: Increase version of content
    							 */
    							$this->_increaseVersion($contentId);
    							$this->_increaseFileVersion($active);
    						}

    						if (!empty($data['SppContent']['delete_record'])) {
    							// delete record
    							$deletes = substr($data['SppContent']['delete_record'], 0, strlen($data['SppContent']['delete_record']) - 1);
    							$deletes = explode(',', $deletes);

    							foreach ($deletes as $del) {
    								$this->SppContentFile->delete($del);

    								$this->Pass4v->accessLog($this->name, "Info", "(".__FUNCTION__."),delete contentId:$contentId id:$del", $referer, $_SERVER['HTTP_USER_AGENT']);
    							}
    						}
    					}
    					// Commit transaction
    					$this->SppContent->commit();
    					if (!empty($active)) {
                            /*
                            *
                            *
                            * @updated 2019.01.24
                            */
                            $this->expansionContent($contentId);

    						//haitlt #20522 --start--//
    						$this->Session->setFlash(Configure::read('Message.EDIT_SUCCESS'));


    						$this->Session->delete('content.Item');
    						$content_url = $this->Session->read('content.url');
    						$this->redirect('/' . $content_url);
    						//haitlt #20522 --end--//
    					}


    					//$this->redirect(array('action' => 'index'));
    					$this->Session->delete('content.Item');
    					$this->Session->setFlash(Configure::read('Message.EDIT_SUCCESS'));
    					$content_url = $this->Session->read('content.url');
    					//$this->Session->delete('content.url');
    					$this->redirect('/' . $content_url);
    				}
    			} catch (Exception $e) {
    				$this->SppContent->rollback();
    				$this->Session->setFlash(Configure::read('Message.ERR_EXCEPTION'));
    				$this->redirect($this->referer());
    			}

    		}
    		$this->Session->delete('editContent.Id');
    	} else {
    		$content = $this->SppContent->find('first', array('recursive' => -1, 'conditions' => array('SppContent.id' => $id)));
    		//debug($content);
    		$content['SppContentFile'] = array();
    		if (!empty($content)) {
    			$this->Session->write('editContent.Id', $content['SppContent']['id']);
    			$fields = array('SppContentFile.id', 'SppContentFile.before_download_desc', 'SppContentFile.file_name', 'SppContentFile.file_size', 'SppContentFile.active_flag', 'SppContentFile.version', 'SppContentFile.updated_datetime', 'SppContentFile.content_id', 'SppContentFile.user_id');
    			$contentFiles = $this->SppContentFile->find('all', array(
                        'conditions' => array('SppContentFile.content_id' => $content['SppContent']['id']), 'fields' => $fields
    			));
    			if (!empty($contentFiles)) {
    				foreach ($contentFiles as $key => $file) {
    					$this->loadModel('SppUser');
    					$updater = $this->SppUser->findById($file['SppContentFile']['user_id']);
    					$content['SppContentFile'][$key] = $file['SppContentFile'];
    					$content['SppContentFile'][$key]['updater'] = $updater['SppUser']['user_name'];
    					//unset($content['SppContentFile'][$key]['file_content']);
    				}
    			}

    			$sess = $this->Session->read('Upload.File');
    			//$this->Session->delete('Upload.File');
    			if (!empty($sess)) {
    				foreach ($sess as $ses) {
    					$this->loadModel('SppUser');
    					$updater = $this->SppUser->findById($ses['user_id']);
    					$ses['updater'] = $updater['SppUser']['user_name'];
    					array_push($content['SppContentFile'], $ses);
    				}
    			}
    			$this->set('content', $content);
    			//debug($content);die;
    		}
    		$dataBuffer = $this->Session->read('content.Item');
    		$this->set('dataBuffer', $dataBuffer);
    		$this->Session->delete('content.Item');
    		$content_url = $this->Session->read('content.url');
    		//$this->Session->delete('content.url');
    		$this->set('content_url', '/' . $content_url);
    		// role user
                $this->set('role_user', $this->role_user);
            }
        
    }

    /**
     *
     * sync content data to SPP_WEB
     * @param String $content_id
     * @author haitlt
     */
    private function syncContent($url = null)
    {

    	$result = file_get_contents($url);
    	return $result;
    }

    public function synchToSPPWeb(){
    	$this->autoRender = false;
    	try{
    		$spp_web_url = Configure::read('SPP_WEB.URL');
    		if (isset($spp_web_url) && !empty($spp_web_url)) {
    			$content_id = $_POST['content_id'];
    			$content_file_id = $_POST['content_file_id'];
    			$param = 'content_id='.$content_id.'&content_file_id='.$content_file_id;
    			$url = $spp_web_url . 'Services/syncContent?' . $param . '';
    			$result = $this->syncContent($url);
    			return $result ? 'true':'false';
    		}
    		return 'false';
    	}catch (Exception $e){
    		return $e->getMessage();
    	}
    }

    public function dataExpansion(){
    	$this->autoRender = false;
	    
        if (!empty($_GET['id'])) {
            $content_id = (int)$_GET['id'];
        }
		
    	$fields = array('SppContentFile.file_name,SppContent.content_name,SppContentFile.file_content,SppContentFile.file_size');
    	$conditions =( array('SppContentFile.content_id'=>$content_id,
    						'SppContent.sale_start_date <='=> date('Y-m-d'),
    						'SppContent.sale_end_date >='=> date('Y-m-d'),
    						'SppContent.active_flag'=>'1'));
		
    	if (!$contentfile = $this->SppContentFile->find('first',array('conditions'=>$conditions,'fields'=>$fields))) {
    		$this->Session->setFlash(Configure::read('Message.ERR_NO_CONTENT'));
    		$content_url = $this->Session->read('content.url');
    		$this->redirect('/' . $content_url);
    	}
    	
		$path = WWW_ROOT . 'files/';
		$db_zip = $path . 'spp.zip';
		$db_file = $path.'spp/spp.db';
    	$dbh = null;
    	$dbh = $this->getBDObject($contentfile);
    		
    	//Read quizzes data
    	$quizzes = $this->getQuizzList($dbh);
    		
    	//Update:
    	$this->Quizz->begin();
    	try{
    		// clean all data by content_id
    		$this->Quizz->deleteAll(array('content_id' => $content_id), false);

    		if(!empty($quizzes)){
    			if(!$this->updateQuizz($quizzes, $content_id)) {
    				$this->Quizz->rollback();
    				$this->deleteFileFolder($db_zip, $db_file, $path);
					$this->Session->setFlash(Configure::read('Message.ERR_UPDATE_QUIZZ_FAILURE'));
					$this->redirect(array('action' => 'editContent', $content_id));
    			}
    		}

    		$this->Quizz->commit();
    	} catch (Exception $e){
			$this->Quizz->rollback();
			error_log($e->getMessage());
			$this->deleteFileFolder($db_zip, $db_file, $path);
			$this->Session->setFlash(Configure::read('Message.ERR_UPDATE_QUIZZ_FAILURE'));
			$this->redirect(array('action' => 'editContent', $content_id));
		}
		
		$this->deleteFileFolder($db_zip, $db_file, $path);
		$this->Session->setFlash(Configure::read('Message.UPDATE_QUIZZ_SUCCESS'));
		$this->redirect(array('action' => 'editContent', $content_id));
    }
    
    private function deleteFileFolder($db_zip, $db_file, $path){
    	unlink($db_zip);
		unlink($db_file);
		
    	$files = glob($path . 'spp/related_av/*'); // get all file names
    	foreach($files as $file){ // iterate files
    		if(is_file($file))
    		unlink($file); // delete file
    	}
    	
    	rmdir($path . 'spp/related_av');
    	rmdir($path . 'spp');
    }
    
    function deleteContent($id = null)
    {

    	if (!empty($id)) {
    		// Begin transaction
    		$this->SppContent->begin();
    		try {
    			// Delete all files relate with this content
    			$this->_deleteContentFile($id);

    			$this->Pass4v->accessLog($this->name, "Info", "(".__FUNCTION__."),delete content id:".$id, $referer, $_SERVER['HTTP_USER_AGENT']);

    			$this->SppContent->delete($id);
    			$this->Session->delete('content.Item');

    			// Commit transaction
    			$this->SppContent->commit();

    			$this->Session->setFlash(Configure::read('Message.DELETE_SUCCESS'));
    			$content_url = $this->Session->read('content.url');
    			//$this->Session->delete('content.url');
    			$this->redirect('/' . $content_url);
    		} catch (Exception $e) {
    			$this->SppContent->rollback();
    			$this->Session->setFlash(Configure::read('Message.ERR_EXCEPTION'));
    			$content_url = $this->Session->read('content.url');
    			//$this->Session->delete('content.url');
    			$this->redirect('/' . $content_url);
    		}

    	}

    }

    function downloadFile($id = NULL)
    {
    	if (!empty($id)) {
    		$file = $this->SppContentFile->findById($id);
    		if (!empty($file)) {
    			header("Content-disposition: attachment; filename=" . $file['SppContentFile']['file_name']);
    			header("Content-type: application/octet-stream; name=" . $file['SppContentFile']['file_name']);
    			header("Content-Length: " . $file['SppContentFile']['file_size']);
    			//print(file_get_contents($this->Uploader->uploadDir . $file['SppContentFile']['file_name']));
    			echo $file['SppContentFile']['file_content'];
    			exit();
    		}
    	}
    	exit();
    }

    function uploadContent($id = null)
    {
    	$this->SppContentFile->id = $id;

    	if (!empty($_POST)) {
    		if (isset($_POST['data']['SppContent']['action']) && $_POST['data']['SppContent']['action'] == 'editContent') {
    			if (!empty($_POST['data']['SppContent']['builtin_flag']) && $_POST['data']['SppContent']['builtin_flag'] == 1) {
    				$_POST['data']['SppContent']['builtin_flag'] = 1;
    			} else {
    				$_POST['data']['SppContent']['builtin_flag'] = 0;
    			}
    			if (!empty($this->data['SppContent']['license_flag']) && $_POST['data']['SppContent']['license_flag'] == 1) {
    				$_POST['data']['SppContent']['license_flag'] = 1;
    			} else {
    				$_POST['data']['SppContent']['license_flag'] = 0;
    			}
    			if (!empty($this->data['SppContent']['store_flag']) && $_POST['data']['SppContent']['store_flag'] == 1) {
    				$_POST['data']['SppContent']['store_flag'] = 1;
    			} else {
    				$_POST['data']['SppContent']['store_flag'] = 0;
    			}
    			$this->Session->write('content.Item', $_POST['data']);
    			//debug($this->Session->read('content.Item'));
    			$content = $this->SppContent->find('first', array('conditions' => array('id' => $id), 'recursive' => -1));
    			$this->Session->write('uploadContent', $content);
    			//$this->Session->delete('content_id');
    			$this->Session->write('content_id', $content['SppContent']['id']);
    			$this->set('content', $content);
    		} else {
    			//debug($this->data);
    			$uploadContent = $this->Session->read('uploadContent');
    			//$this->Session->delete('uploadContent');

    			$this->set('content', $uploadContent, $this->data);
    			if (empty($this->data['SppContent']['before_download_desc'])) {
    				$this->Session->setFlash(Configure::read('Message.ERR_DOWNLOAD_DESC'));
    				//$this->redirect($this->referer());
    			} else {
    				if (strlen($this->data['SppContent']['before_download_desc']) > 2000) {
    					$this->Session->setFlash(Configure::read('Message.ERR_CONTENT_DOWNLOAD_LENGTH'));
    					//$this->redirect($this->referer());
    				} else {
    					if (empty($this->data['SppContent']['content_file']['error'])) {
    						if (!empty($this->data['SppContent']['content_file'])) {
    							$data = $this->Uploader->upload('content_file', array('name' => $this->data['SppContent']['content_file']['name']));
    							if (!empty($data)) {
    								// create record content file
    								$contentId = $this->Session->read('content_id');
    								$this->Session->delete('content_id');

    								$upload = array();
    								$upload['before_download_desc'] = $this->data['SppContent']['before_download_desc'];
    								$upload['file_name'] = $data['name'];
    								//#19138
    								$upload['file_name_old'] = $this->data['SppContent']['content_file']['name'];
    								$upload['file_size'] = $data['size'];
    								$upload['active_flag'] = 0;
    								$upload['created_datetime'] = date('Y-m-d H:i:s');
    								$upload['updated_datetime'] = date('Y-m-d H:i:s');
    								$upload['user_id'] = $this->Session->read('Auth.SppUser.id');
    								$upload['content_id'] = $contentId;
    								$upload['id'] = time();
    								$upload['is_new'] = true;

    								$sess = $this->Session->read('Upload.File');
    								$this->Session->delete('Upload.File');
    								if (!empty($sess)) {
    									$upload['version'] = null;
    									array_push($sess, $upload);
    									$this->Session->write('Upload.File', $sess);
    								} else {
    									$upload['version'] = null;
    									$this->Session->write('Upload.File.0', $upload);
    								}
    								//echo $contentId;die;
    								$this->redirect(array('action' => 'editContent', $contentId));
    							} else {
    								$this->Session->setFlash(Configure::read('Message.ERR_UPLOAD_FILE'));
    								//$this->redirect($this->referer());
    							}
    						} else {
    							$this->Session->setFlash(Configure::read('Message.ERR_UPLOAD_FILE'));
    							//$this->redirect($this->referer());
    						}
    					} else {
    						$this->Session->setFlash(Configure::read('Message.ERR_UPLOAD_FILE'));
    					}
    				}
    			}
    		}
    	} else {
    		$content = $this->SppContent->find('first', array('conditions' => array('id' => $id), 'recursive' => -1));
    		$this->Session->write('content_id', $content['SppContent']['id']);
                $this->set('content', $content);
            }
        
    }

    function deleteFile()
    {

    }

    /**
     * 
     * @param $contentId
     * @return 
     */
    function expansionContent($contentId = null)
    {
        try {
            $content = $this->SppContentFile->find('first', array(
                'conditions' => array(
                    'SppContentFile.content_id' => $contentId
                ),
                'order' => 'SppContentFile.version DESC'
            ));
            if (!empty($content)) {

                    $arrayImage = [];
                    $file_name   = $path = WWW_ROOT . DS . 'pwa_web' . DS . $content['SppContentFile']['file_name'] ;

                    if (file_put_contents($file_name, $content['SppContentFile']['file_content'])) {
                        if( chmod($file_name, 0777) ) {
                            chmod($file_name, 0777);
                        }
                        $finfo = new finfo(FILEINFO_MIME_TYPE);
                        $mime = $finfo->file($file_name);
                        // Check file is sqlite3
                        if ($mime == 'application/x-sqlite3') {
                           $filename = $file_name;
                        } else {
                           $path = pathinfo(realpath($file_name), PATHINFO_DIRNAME);

                           $zip = new ZipArchive;
                           $res = $zip->open($file_name);
                           if ($res === TRUE) {
                               $zip->extractTo($path);
                               $zip->close();
                               unlink($file_name);
                           }
                           $filename = WWW_ROOT . DS . 'pwa_web' . DS . 'spp.db';
                       }

                       $oDatabaseHandler  = new SQlite3ToJSON($filename);
                       $data  = $oDatabaseHandler->getJSONFromSQLite();

                       $name_folder = $data['contents'][0]['content_id'];
                       $folderContentId = WWW_ROOT . 'pwa_web' . DS . $name_folder;
                       $source = WWW_ROOT . 'pwa_web' .DS.  'insert_images';
                       if (!is_dir($folderContentId)) {
                           mkdir($folderContentId, 0777, true);
                           $dist = $folderContentId . DS . 'insert_images';
                        }

                        if (!is_dir($dist)) {
                            mkdir($dist, 0777, true);
                        }

                        if (is_dir($source)) {
                            if ($dh = opendir($source)) {
                                while (($file = readdir($dh)) !== false) {
                                    //exclude unwanted

                                    if ($file==".") continue;

                                    if ($file=="..")continue;
                                    $path_end_img = $name_folder . DS . 'insert_images/' .$file;
                                    array_push($arrayImage, $path_end_img);
                                    copy("$source/$file","$dist/$file");
                                }
                                closedir($dh);
                            }
                            rmdir($source);
                        }
                     
                       if( chmod($dist, 0777) ) {
                           chmod($dist, 0777);
                        }

                        $content['SppContentFile']['content_base64'] = base64_encode(json_encode($data));
                        $content['SppContentFile']['image_list'] = base64_encode(json_encode($arrayImage));
                        $this->SppContentFile->save($content);
                        unlink($filename);
                } 
            }
        } catch (Exception $e) {
        }
    }


    /**
     * Get max version of content
     * @param $contentId
     * @return max version of Content
     */
    function _getFileVersion($contentId = null)
    {
        //$this->loadModel('SppContentFile');
        $content = $this->SppContentFile->find('first', array(
            'conditions' => array(
                'SppContentFile.content_id' => $contentId
            ),
            'fields' => array('version'),
            'order' => 'SppContentFile.version DESC'
        ));
        if (!empty($content)) {
            $version = $content['SppContentFile']['version'];
            return $version;
        }
    }

    function _getSessionVersion($id)
    {
        $contentVersion = $this->SppContent->find('first', array('conditions' => array('SppContent.id' => $id), 'fields' => array('version'), 'recursive' => -1));
        //debug($contentVersion);die;
        $version = $contentVersion['SppContent']['version'];
        return $version;
    }

    /**
     * Increase version of content
     */

    function _increaseVersion($contentId)
    {
        $this->SppContent->id = $contentId;
        $content = $this->SppContent->find('first', array(
            'conditions' => array(
                'SppContent.id' => $contentId
            ),
            'fields' => array('version'),
            'order' => 'SppContent.version DESC'
        ));
        if (!empty($content)) {
            $version = $content['SppContent']['version'];
        } else {
            $version = 0;
        }
        $this->SppContent->saveField('version', $version + 1);
        $this->SppContent->saveField('active_flag', 1);

        // increase version of parent content if have
        $parentContent = $this->SppContentItem->find('all', array(
                'conditions' => array(
                    'SppContentItem.child_content_id' => $contentId,
                    'SppContent.active_flag' => 1
                ))
        );
        if (!empty($parentContent)) {
            foreach ($parentContent as $parent) {
                $this->SppContent->id = $parent['SppContent']['id'];
                $ver = $parent['SppContent']['version'];
                $ver = $ver + 1;
                $this->SppContent->saveField('version', $ver);
            }
        }
        //debug($parentContent);die;
    }

    function _increaseFileVersion($id)
    {
        $file = $this->SppContentFile->find('first', array(
            'fields' => array('content_id'),
            'conditions' => array('SppContentFile.id' => $id)
        ));
        //debug($file);die;
        $contentVersion = $this->SppContent->find('first', array('conditions' => array('SppContent.id' => $file['SppContentFile']['content_id']), 'fields' => array('version'), 'recursive' => -1));
        $version = $contentVersion['SppContent']['version'];
        //$version = $version + 1;
        $this->SppContentFile->id = $id;
        $this->SppContentFile->saveField('version', $version);
    }

    /**
     * Delete all file relate with content
     * @param $contentId
     */
    function _deleteContentFile($contentId = NULL)
    {
        $files = $this->SppContentFile->find('all', array(
            'conditions' => array(
                'SppContentFile.content_id' => $contentId
            ),
            'fields' => array('SppContentFile.id, SppContentFile.content_id')
        ));
        if (!empty($files)) {
            foreach ($files as $file) {
                $this->SppContentFile->delete($file['SppContentFile']['id']);
            }
        }
    }
    /**
     * End Binhtt
     */
    /**
     * 
     * for dataExpansion
     * @param unknown_type $dbh
     */
    private function getQuizzList($dbh = null){
		$quizzes = array();
		if($dbh != null){
			$testSql = 'SELECT q.category_no,
							c.category_name,
        					q.subcategory_no, 
        					s.subcategory_name,
        					q.quiz_no,
        					q.sentence,
        					q.comment,
        					q.keyword,
        					q.related_image_name,
        					q.choice_row_count,
        					q.answer_no,
        					q.time_limit,
        					q.rank 
        			FROM quizzes as q 
        			LEFT JOIN categories as c ON q.category_no = c.category_no 
        			LEFT JOIN subcategories as s ON q.category_no = s.category_no AND q.subcategory_no = s.subcategory_no
        			ORDER BY q.category_no,
        					q.subcategory_no,
        					q.quiz_no';
			foreach ($dbh->query($testSql) as $row) {
				$quizz['category_no'] = $row['category_no'];
				$quizz['category_name'] = $row['category_name'];
				$quizz['subcategory_no'] = $row['subcategory_no'];
				$quizz['subcategory_name'] = $row['subcategory_name'];
				$quizz['quiz_no'] = $row['quiz_no'];
				$quizz['sentence'] = $row['sentence'];
				$quizz['comment'] = $row['comment'];
				$quizz['keyword'] = $row['keyword'];
				$quizz['related_image_name'] = $row['related_image_name'];
				$quizz['choice_row_count'] = $row['choice_row_count'];
				$quizz['answer_no'] = $row['answer_no'];
				$quizz['time_limit'] = $row['time_limit'];
				$quizz['rank'] = $row['rank'];

				$quizzes[] = $quizz;
			}
		}

		return $quizzes;
    }
    /**
     * updateQuizz
     */
	private function updateQuizz($quizzes = null, $content_id = null){

		if($quizzes == null || $content_id == null) return false;
		//insert quizzes
		foreach ($quizzes as $quizz){
			$quizz['content_id'] = $content_id;
			$quizz['id'] = '0';
			if(!$this->Quizz->save($quizz))
				return false;
		}
		return true;
	}
	/**
	 * 
	 * for dataExpansion
	 */
    private function getBDObject($contentfile = null){
    	$path = WWW_ROOT . 'files/';
    	
    	//set mod 777 for webroot folder
    	$folder_webroot = new Folder($path, true, 0777);
		
    	//write to file
    	$myFile = $path . "spp.zip";
    	
    	$fh = fopen($myFile, 'w') or die("can't open file");
    	fwrite($fh, $contentfile['SppContentFile']['file_content']);
    	
    	//zip file extraction
    	$zip = new ZipArchive;
    	$zip->open($myFile);
    	$zip->extractTo($path.'spp');
    	$zip->close();

    	//open file sqlite from data
		$db_file = $path.'spp/spp.db';
		$dbh = new PDO("sqlite:" . $db_file);
		return $dbh;
	}
}
class SQlite3ToJSON
{
    /**
     * The SQlite 3 database
     */
    private $database = NULL;

    /**
     * Open the database by creating a new SQLite3 instance from the
     * filename given to the constructor initially
     */
    public function __construct($sDatabaseFileName = NULL) {
        $this->openDatabase($sDatabaseFileName);
    }

    /**
     * Open the database by creating a new SQLite3 instance from the
     * filename given to the constructor initially
     */
    public function openDatabase($databaseFileName = NULL) {
        $this->database = new SQLite3($databaseFileName);
        assert($this->database);
    }

    /**
     * This method returns information about the given table name
     */
    private function columnsInformationWithTableName($sTableName) {
        // Setting the query
        $sQueryColumns = "PRAGMA table_info(':name')";
        $sQueryColumns = str_replace(':name', $sTableName, $sQueryColumns);

        // Preparing the query
        $oResult = $this->database->query($sQueryColumns);

        // Fetching result and preparing formatting of the result to a
        // convenient usable format.
        $aResult = array();
        while ($aRow = $oResult->fetchArray(SQLITE3_ASSOC)) {
            $aResult[] = $aRow;
        }

        return $aResult;
    }

    /**
     * This method returns information about the given table name
     */
    private function tablesInformation() {
        // Launch the query to find information about tables
        // of the database
        $sQueryTables = "SELECT * FROM sqlite_master WHERE type='table'";
        $uResult = $this->database->query($sQueryTables);

        // Fetching result and preparing formatting of the result to a
        // convenient usable format.
        $aResult = array();
        while ($aRow = $uResult->fetchArray(SQLITE3_ASSOC)) {
            $aResult[] = $aRow;
        }

        return $aResult;
    }

    private function schemaInformation() {
        $aSchema = array();
        $aTables = $this->tablesInformation();
        foreach ($aTables as $aTableInformation) {
            if (!isset($aTableInformation['name'])) {
                throw new Exception();
            }

            $sTableName = $aTableInformation['name'];
            $aColumns = $this->columnsInformationWithTableName($sTableName);
            $aSchema[$sTableName] = $aColumns;

            unset($sTableName);
        }
        unset($aTables);
        return $aSchema;
    }

    private function dataInformation($sTableName) {

        $sQueryData = "SELECT * FROM " .$sTableName;
        $uResult = $this->database->query($sQueryData);

        // Fetching result and preparing formatting of the result to a
        // convenient usable format.
        $aResult = array();
        while ($aRow = $uResult->fetchArray(SQLITE3_ASSOC)) {
            $aResult[] = $aRow;
        }

        return $aResult;
    }

    /**
     * Main method that will export the SQLite Database to a JSON stirng format.
     */
    public function getJSONFromSQLite() {
        $aData = array();
        $aTables = $this->schemaInformation();
        foreach($aTables as $sTableName => $aColumns) {
            $aRows = $this->dataInformation($sTableName);
            $aData[$sTableName] = $aRows;
        }

        return $aData;
    }
}
?>
