<?php
define("CONTENT_ID", "コンテンツID");
define("CONTENT_NAME", "コンテンツ名");
define("CATEGORY_NO", "カテゴリID");
define("CATEGORY_NAME", "カテゴリ名");
define("SUBCATEGORY_NO", "サブカテゴリID");
define("SUBCATEGORY_NAME", "サブカテゴリ名");
define("QUIZ_NO", "問題番号");
define("QUIZ_KEYWORD", "キーワード");
define("QUIZ_SET_TIMES", "出題回数");
define("QUIZ_CLASSIFICATION", "問題分類");
define("QUIZ_TYPE", "問題形式");
define("QUIZ_DIFFICULTY", "難易度");
define("CORRECT_RATE", "正答率");
class QuizzesForSearchController extends AppController
{
    var $name = 'QuizzesForSearch';
    var $helpers = array('Html', 'Form', 'Session', 'Form', 'Dialog', 'pass4v');
    var $uses = array("QuizzesForSearch", "SppContent", "Quizz", "SppOrganization");
    var $components = array('RequestHandler', 'Auth', 'Session', 'Csv', 'Pass4v');
	
    function beforeFilter()
    {
        parent::beforeFilter();
        $this->Auth->allow('add', 'index', 'csvImport', 'getQuizSentence', 'getSubCategory', 'exportCSV');
		// check session and role
		if(!$this->isSystemManagement() && !$this->isAchievementManagement()){
			$this->render('/elements/error');
			return;
		}
		if (!$this->isSystemManagement()) {
			$action = $this->params['action'];
			if ($action == "add" || $action == "csvImport" || $action ==  "exportCSV") {
				$this->render('/elements/error');
				return;
			}
		}
    }

    function index()
    {
    	$this->QuizzesForSearch->recursive = -1;
    	$session = $this->Session->read();
    	$user_id = $session['Auth']['SppUser']['id'];
    	$categories = $this->QuizzesForSearch->find('all', array('fields' => array('DISTINCT category_name'), 'conditions' => array('category_name <>' => '')));
    	$subcategories = $this->QuizzesForSearch->find('all', array('fields' => array('DISTINCT subcategory_name'), 'conditions' => array('subcategory_name <>' => '')));
    	$quiz_set_times = $this->QuizzesForSearch->find('all', array('fields' => array('DISTINCT quiz_set_times'), 'conditions' => array('quiz_set_times <>' => '')));
    	$quiz_classifications = $this->QuizzesForSearch->find('all', array('fields' => array('DISTINCT quiz_classification'), 'conditions' => array('quiz_classification <>' => '')));
    	$quiz_types = $this->QuizzesForSearch->find('all', array('fields' => array('DISTINCT quiz_type'), 'conditions' => array('quiz_type <>' => '')));
    	$quiz_difficulties = $this->QuizzesForSearch->find('all', array('fields' => array('DISTINCT quiz_difficulty'), 'conditions' => array('quiz_difficulty <>' => '')));
    	$selected_category_name = "";
    	$selected_subcategory_name = "";
    	$selected_quiz_set_times = "";
    	$selected_quiz_difficulty = "";
    	$selected_quiz_classification = "";
    	$correct_rate = "";
    	$quiz_keyword = "";
    	$selected_quiz_type = "";
    	$learner_id = "";
    	
    	$quizzesForSearchData = array();
    	$fields = array('QuizzesForSearch.*, ROUND(AVG(ViewCorrectRate.correct_rate)) AS correct_rate');
    	$conditions = array();
    	$joins = array(
    				   array('table' => 'v_correct_rates',
					         'alias' => 'ViewCorrectRate',
					         'type' => 'LEFT',
					         'conditions' => array(
    				   		 'ViewCorrectRate.category_no = QuizzesForSearch.category_no',
    				   		 'ViewCorrectRate.subcategory_no = QuizzesForSearch.subcategory_no',
    				   		 'ViewCorrectRate.quiz_no = QuizzesForSearch.quiz_no'
				  )));
		if(!$this->isSystemManagement()){
			$organizations = $this->SppOrganization->getOrgCodeForAchivementUser($user_id);
			$organization_codes = array();
			if (!empty($organizations)) {
				foreach ($organizations as $organizations) {
					array_push($organization_codes, $organizations[0]['code']);
				}
			}
			$conditions['OR'] = array('ViewCorrectRate.organization_code' => $organization_codes, 'ViewCorrectRate.organization_code IS NULL');
			//$conditions['ViewCorrectRate.organization_code'] = $organization_codes;
		}
		$order = array('QuizzesForSearch.category_no', 'QuizzesForSearch.subcategory_no', 'QuizzesForSearch.quiz_no');
		$group = array('QuizzesForSearch.category_no', 'QuizzesForSearch.subcategory_no', 'QuizzesForSearch.quiz_no');
    	if ($this->RequestHandler->isPost() && isset($this->data['submit_search'])){
    		if (!empty($this->data['category_name'])) {
    			$selected_category_name = $this->data['category_name'];
    			$conditions['QuizzesForSearch.category_name'] = $selected_category_name;
    		}
    		
    		if (!empty($this->data['subcategory_name'])) {
    			$selected_subcategory_name = $this->data['subcategory_name'];
    			$conditions['QuizzesForSearch.subcategory_name'] = $selected_subcategory_name;
    		}
    		
    		if (!empty($this->data['quiz_set_times'])) {
    			$selected_quiz_set_times = $this->data['quiz_set_times'];
    			$conditions['QuizzesForSearch.quiz_set_times'] = $selected_quiz_set_times;
    		}
    		
    		if (!empty($this->data['quiz_difficulty'])) {
    			$selected_quiz_difficulty = $this->data['quiz_difficulty'];
    			$conditions['QuizzesForSearch.quiz_difficulty'] = $selected_quiz_difficulty;
    		}
    		
    		if (!empty($this->data['quiz_classification'])) {
    			$selected_quiz_classification = $this->data['quiz_classification'];
    			$conditions['QuizzesForSearch.quiz_classification'] = $selected_quiz_classification;
    		}
    		
    		if ($this->data['QuizzesForSearch']['correct_rate'] == "0" || !empty($this->data['QuizzesForSearch']['correct_rate'])) {
    			$correct_rate = $this->data['QuizzesForSearch']['correct_rate'];
    			if (is_numeric($correct_rate) && $correct_rate >= 0 && $correct_rate <= 100) {
    				$conditions[] = "ViewCorrectRate.correct_rate <= ".$correct_rate;
    			} else {
    				//$this->Session->setFlash('正解率');
    			}
    		}
    		
    		if (!empty($this->data['QuizzesForSearch']['quiz_keyword'])) {
    			$quiz_keyword = $this->data['QuizzesForSearch']['quiz_keyword'];
    			$conditions[] = "QuizzesForSearch.quiz_keyword LIKE '%".$quiz_keyword."%'";
    		}
    		
    		if (!empty($this->data['quiz_type'])) {
    			$selected_quiz_type = $this->data['quiz_type'];
    			$conditions['QuizzesForSearch.quiz_type'] = $selected_quiz_type;
    		}
    		
    		if (!empty($this->data['QuizzesForSearch']['learner_id'])) {
    			$learner_id = $this->data['QuizzesForSearch']['learner_id'];
    			$conditions['ViewCorrectRate.learner_id'] = $learner_id;
    		}
    		
    	}
    	if ($this->RequestHandler->isPost() && isset($this->data['submit_csv_output'])){
    		$conditions['QuizzesForSearch.id'] = $this->data['download_checked'];
    		$quizzesForSearchData = $this->QuizzesForSearch->find('all', array('fields' => $fields, 'joins' => $joins,
    		 'conditions' => $conditions, 'order' => $order, 'group' => $group));
    		return $this->downloadCSVFromSearch($quizzesForSearchData);
    	}
    	$quizzesForSearchData = $this->QuizzesForSearch->find('all', array('fields' => $fields, 'joins' => $joins,
    	'conditions' => $conditions, 'order' => $order, 'group' => $group));
    	
    	$this->set(compact("categories"));
    	$this->set(compact("subcategories"));
    	$this->set(compact("quiz_set_times"));
    	$this->set(compact("quiz_classifications"));
    	$this->set(compact("quiz_types"));
    	$this->set(compact("quiz_difficulties"));
    	$this->set("quizzesForSearchs",$quizzesForSearchData);
    	$this->set(compact("selected_category_name"));
    	$this->set(compact("selected_subcategory_name"));
    	$this->set(compact("selected_quiz_set_times"));
    	$this->set(compact("selected_quiz_difficulty"));
    	$this->set(compact("selected_quiz_classification"));
    	$this->set(compact("correct_rate"));
    	$this->set(compact("quiz_keyword"));
    	$this->set(compact("selected_quiz_type"));
    	$this->set(compact("learner_id"));
    	
    }

    function downloadCSVFromSearch($datas) {
    	$this->layout = false;
		$array = array();
		//edit array
		if(!empty($datas)){
			foreach ($datas as $item) {
				$temp = array(
				$item['QuizzesForSearch']['category_name'],
				$item['QuizzesForSearch']['subcategory_name'],
				$item['QuizzesForSearch']['quiz_no'],
				$item[0]['correct_rate'],
				$item['QuizzesForSearch']['quiz_keyword'],
				$item['QuizzesForSearch']['quiz_set_times'],
				$item['QuizzesForSearch']['quiz_classification'],
				$item['QuizzesForSearch']['quiz_type'],
				$item['QuizzesForSearch']['quiz_difficulty']
				);
				array_push($array, $temp);
			}
		}
		$header = array(CATEGORY_NAME, SUBCATEGORY_NAME, QUIZ_NO, CORRECT_RATE, QUIZ_KEYWORD, 
						QUIZ_SET_TIMES, QUIZ_CLASSIFICATION, QUIZ_TYPE, QUIZ_DIFFICULTY);
		$fileName = '検索タグ'.date('Ymdhms');
		$this->Csv->export("SJIS", $array, $header, $fileName . '.csv');
    }
    
    function add()
    {
    	$this->SppContent->recursive = -1;
    	$selected_content_id = -1;
    	$contents = $this->SppContent->find('all', array(
    				'joins' => array( array(
					            'table' => 'quizzs',
					            'alias' => 'Quizz',
					            'type' => 'INNER',
					            'conditions' => array(
					                'Quizz.content_id = SppContent.id'
					            )
					        )),
					  'fields' => array('DISTINCT SppContent.id', 'SppContent.content_name')
    				));
    	$this->set(compact('contents'));
    	if ($this->RequestHandler->isPost()){
    		if(isset($this->data['submit_csv_export'])){
    			$selected_content_id = $this->data['selected_content_id'];
				$this->exportCSV($this->data['selected_content_id']);
			}
    	}    	
    	$this->set(compact('selected_content_id'));
    }
    
    function getSubCategory() {
    	$this->autoRender = false;
    	$category_name = $_GET['category_name'];
    	$subcategories = $this->QuizzesForSearch->find('all', array('fields' => array('DISTINCT subcategory_name'), 
    	'conditions' => array('category_name' => $category_name, 'subcategory_name <>' => '')));
    	return json_encode($subcategories);
    }
    
    function getQuizSentence() {
    	$this->autoRender = false;
		$category_no = $_GET['category_no'];
		$subcategory_no = $_GET['subcategory_no'];
		$quiz_no = $_GET['quiz_no'];
		$quiz = $this->Quizz->find('first', array('fields' => array('sentence'), 
										  'conditions' => array('category_no' => $category_no,
		            											'subcategory_no' => $subcategory_no,
																'quiz_no' => $quiz_no)));
		return $quiz['Quizz']['sentence'];
    }
    
	function exportCSV($content_id){
		$this->layout = false;
		$datas = array();
		$conditions = array();
		$fields = array('SppContent.id', 'SppContent.content_name', 'Quizz.category_no', 'Quizz.category_name',
					         'Quizz.subcategory_no', 'Quizz.subcategory_name', 'Quizz.quiz_no', 'Quizz.keyword');
		$order = array('SppContent.id', 'Quizz.category_no', 'Quizz.subcategory_no', 'Quizz.quiz_no');
		$joins = array( array(
					            'table' => 'quizzs',
					            'alias' => 'Quizz',
					            'type' => 'INNER',
					            'conditions' => array(
					                'Quizz.content_id = SppContent.id'
					            )
					        ));
		if ($content_id != -1) {
			$conditions['SppContent.id'] = $content_id;
		}
		$datas = $this->SppContent->find('all', array(
					'conditions' => $conditions,
    				'joins' => $joins,
					'fields' => $fields,
					'order' => $order
    				));
    				
		$array = array();
		//edit array
		if(!empty($datas)){
			foreach ($datas as $item) {
				$temp = array(
				$item['SppContent']['id'],
				$item['SppContent']['content_name'],
				$item['Quizz']['category_no'],
				$item['Quizz']['category_name'],
				$item['Quizz']['subcategory_no'],
				$item['Quizz']['subcategory_name'],
				$item['Quizz']['quiz_no'],
				$item['Quizz']['keyword'],
				'','','',''
				);
				array_push($array, $temp);
			}
		}
		$header = array(CONTENT_ID, CONTENT_NAME, CATEGORY_NO, CATEGORY_NAME, SUBCATEGORY_NO, SUBCATEGORY_NAME, QUIZ_NO, QUIZ_KEYWORD, 
						QUIZ_SET_TIMES, QUIZ_CLASSIFICATION, QUIZ_TYPE, QUIZ_DIFFICULTY);
		$fileName = '検索タグ'.date('Ymdhms');
		$this->Csv->export("SJIS", $array, $header, $fileName . '.csv');
	}
	
    function csvImport() {
    	if ($name = $this->_uploadfile()) {
			try{
				$aryFieldHeaders = array('content_id', 'content_name', 'category_no', 'category_name',
				 'subcategory_no', 'subcategory_name', 'quiz_no', 'quiz_keyword', 
				 'quiz_set_times', 'quiz_classification', 'quiz_type', 'quiz_difficulty');
				$data = $this->Csv->import("files/" . $name, $aryFieldHeaders );
				unlink(WWW_ROOT . "files/" . $name);
			} catch (Exception $e){
				$this->Session->setFlash(Configure::read('Message.ERR_WRONG_FORMAT'));
				return $this->redirect(array('action' => 'add'));
			}
			if(!$data && is_bool($data) === true){
				$this->Session->setFlash(Configure::read('Message.ERR_WRONG_FORMAT'));
				return $this->redirect(array('action' => 'add'));
			}

			if(empty($data) ||  count($data) <= 1){
				$this->Session->setFlash(Configure::read('Message.ERR_HAVE_NO_DATA'));
				return $this->redirect(array('action' => 'add'));
			}
			$quizDatas = $this->Quizz->find('all', array('fields' => array('content_id', 'category_no', 'subcategory_no', 'quiz_no')));
			$this->QuizzesForSearch->begin();
			try {
				unset($data[0]);
				$dataError = array();
				// validate all data before insert
				$error = false;
				$contents_id_deleted = array(); // list content_id conflict between data_import và data in table QizzesForSearch (it will be deleted before insert new data)
				foreach ($data as $item) {
					$result_validate = $this->validateData($item['QuizzesForSearch'], $quizDatas);
					if($result_validate !== true){
						$error = true;
						$item['QuizzesForSearch']['err_msg'] = $result_validate;
						array_push($dataError, $item);
					} else {
						if(!$error) {
							if (!in_array($item['QuizzesForSearch']['content_id'], $contents_id_deleted)) {
								$content_existed = $this->QuizzesForSearch->checkExistedByContent($item['QuizzesForSearch']['content_id']);
								if($content_existed) {
									$this->QuizzesForSearch->deleteByContent($item['QuizzesForSearch']['content_id']);
								}
								array_push($contents_id_deleted, $item['QuizzesForSearch']['content_id']);
							}
						}
						$item['QuizzesForSearch']['id'] = 0;
						if (!$this->QuizzesForSearch->save($item)) {
							$error = true;
						}
					}
				}
				if(!$error){
					$this->QuizzesForSearch->commit();
					$this->Session->setFlash(Configure::read('Message.MSG_ROW_INSERT'));
				} else {
					$this->QuizzesForSearch->rollback();
					if(count($dataError) > 0){
						$this->set('dataError',$dataError);
						return;
					}
					$this->Session->setFlash(Configure::read('Message.ERR_IMPORT'));
				}
			} catch (Exception $e) {
				$this->QuizzesForSearch->rollback();
				$this->Session->setFlash(Configure::read('Message.ERR_IMPORT'));
			}
		} else {
			$this->Session->setFlash(Configure::read('Message.ERR_IMPORT'));
		}
		return $this->redirect(array('action' => 'add'));
    }
    
	/**
	 *
	 * upload file
	 */
	private function _uploadfile() {
		$name = time() . ".csv";
		$filename = "files/" . $name;
		/* copy uploaded file */
		if (move_uploaded_file($this->data['csv_import']['file']['tmp_name'], $filename)) {
			return $name;
		} else {
			/* save message to session */
			echo 'There was a problem uploading file. Please try again.';
			return FALSE;
		}
	}
	
	private function validateData($data, $quizDatas) {
		try {
			if( !empty($data)) {
				$content_id = $data['content_id'];
				$content_id_existed = false;
				if(empty($content_id)) {
					return Configure::read('Message.ERR_MISSING_CONTENT_ID');
				}
				
				$category_no = $data['category_no'];
				$category_no_existed = false;
				if(empty($category_no)) {
					return Configure::read('Message.ERR_MISSING_CATEGORY_NO');
				}
				
				$subcategory_no = $data['subcategory_no'];
				$subcategory_no_existed = false;
				if(empty($subcategory_no)) {
					return Configure::read('Message.ERR_MISSING_SUBCATEGORY_NO');
				}
				
				$quiz_no = $data['quiz_no'];
				$quiz_no_existed = false;
				if(empty($quiz_no)) {
					return Configure::read('Message.ERR_MISSING_QUIZ_NO');
				}
				/*$is_existed = $this->Quizz->checkQuizExisted($content_id, $category_no, $subcategory_no, $quiz_no);
				if (!$is_existed) {
					return Configure::read('Message.ERR_WRONG_QUIZ_FOR_SEARCH');
				}*/
				if(!empty($quizDatas)) {
					foreach ($quizDatas as $quizData) {
						if ($quizData['Quizz']['content_id'] == $content_id) {
							$content_id_existed = true;
							if ($quizData['Quizz']['category_no'] == $category_no) {
								$category_no_existed = true;
								if ($quizData['Quizz']['subcategory_no'] == $subcategory_no) {
									$subcategory_no_existed = true;
									if($quizData['Quizz']['quiz_no'] == $quiz_no) {
										$quiz_no_existed = true;
										break;
									}
								}
							}
						}
					}
				}
				
				if(!$content_id_existed) {
					return Configure::read('Message.ERR_WRONG_CONTENT_ID');
				}
				if(!$category_no_existed) {
						return Configure::read('Message.ERR_WRONG_CATEGORY_NO');
					}
				if(!$subcategory_no_existed) {
						return Configure::read('Message.ERR_WRONG_SUBCATEGORY_NO');
					}
				if(!$quiz_no_existed) {
					return Configure::read('Message.ERR_WRONG_QUIZ_NO');
				}
				return true;
			} else {
				return 'NULL';
			}
		} catch (Exception $e) {
			return $e->getMessage();
		}
	}

}

?>
