<?php
class CsvComponent extends Object{

	var $delimiter = ",";

	var $enclosure = '"';

	var $line = "\n";
	 public $defaults = array(
        'length' => 0,
        'delimiter' => ',',
        'enclosure' => '"',
        'escape' => '\\',
        'headers' => true
    );
	public function initialize(Controller $controller, $settings = array()) {
		// saving the controller reference for later use
		$this->controller = $controller;
		$this->defaults = array_merge($this->defaults, $settings);
	}

	function arrayToCsv($data, $header = null, $encoding = null, $col_sep = ",", $row_sep = "\n", $qut = '"')
	{
		$output = "";

		//Header row.
		if ($header)
		{
			foreach ($header as $key => $val)
			{
				//Escaping quotes.
				$key = str_replace($this->enclosure, "$this->enclosure$this->enclosure", $val);
				$output .= "$this->delimiter$this->enclosure$key$this->enclosure";
			}
			$output = substr($output, 1)."\n";
		}

		//Data rows.
		if(is_array($data) and count($data) > 0){
			if (is_array($data[0])) {
				foreach ($data as $key => $val)
				{
					$tmp = '';
					foreach ($val as $cellKey => $cellVal)
					{
						//Escaping quotes.
						$cellVal = str_replace($this->enclosure, "$this->enclosure$this->enclosure", $cellVal);
						$tmp .= "$this->delimiter$this->enclosure$cellVal$this->enclosure";
					}
					$output .= substr($tmp, 1).$this->line;
				}
			}
		}

		// Encoding
		if($encoding) {
			return mb_convert_encoding ( $output, $encoding, "auto" );
		}
		return $output;
	}

 	protected function _encode($str = '') {
       return mb_convert_encoding($str, 'UTF-8', 'SJIS'); 
    }
    
	function export($encode, $data, $header = null, $filename) {
		$csv_data = $this->arrayToCsv($data, $header, $encode);

		// send response headers to the browser
		if(empty($filename)) {
			$filename = 'export.csv';
		}

		header ( 'Content-Type: text/csv' );
		header ( 'Content-Disposition: attachment;filename=' . $filename );
		echo $csv_data;
		exit();
	}

	public function import($filename, $fields = array(), $options = array()) {
		$options = array_merge($this->defaults, $options);
		$data = array();

		// open the file
		if ($file = @fopen($filename, 'r')) {
			if (empty($fields)) {
				// read the 1st row as headings
				$fields = fgetcsv($file, $options['length'], $options['delimiter'], $options['enclosure']);
			}
			// Row counter
			$r = 0;
			// read each data row in the file
			while ($row = fgetcsv($file, 0, ',', '"')) {
				// for each header field
				foreach ($fields as $f => $field) {
					// get the data field from Model.field
					if (strpos($field, '.')) {
						$keys = explode('.', $field);
						if (isset($keys[2])) {
							$data[$r][$keys[0]][$keys[1]][$keys[2]] = $this->_encode($row[$f]);
						} else {
							$data[$r][$keys[0]][$keys[1]] = $this->_encode($row[$f]);
						}
					} else {
						if (!isset($row[$f])) {
							return false;
						}
						$data[$r][$this->controller->modelClass][$field] = $this->_encode($row[$f]);
					}
				}
				$r++;
			}

			// close the file
			fclose($file);

			// return the messages
			return $data;
		} else {
			return false;
		}
	}
}